/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.accum.Entropy;

public class LogEntropy
extends BaseAccumulation {
    public LogEntropy(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public LogEntropy() {
    }

    public LogEntropy(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public LogEntropy(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public LogEntropy(INDArray x) {
        super(x);
    }

    public LogEntropy(INDArray x, INDArray y) {
        super(x, y);
    }

    public LogEntropy(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.lengthLong());
    }

    @Override
    public int opNum() {
        return 17;
    }

    @Override
    public String opName() {
        return "logentropy";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.REDUCE;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        List<SDVariable> entropyGrad = Entropy.grad(this.f(), this.arg(), f1.get(0), this.dimensions);
        return Collections.singletonList(entropyGrad.get(0).div(this.f().exp(this.outputVariable())));
    }
}

