/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.AttributeAdapter;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.descriptors.properties.adapters.BooleanAdapter;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class CumProd
extends DynamicCustomOp {
    protected boolean exclusive = false;
    protected boolean reverse = false;
    protected int[] axis = new int[0];

    public CumProd() {
    }

    public CumProd(SameDiff sameDiff, SDVariable x, int ... axis) {
        this(sameDiff, x, false, false, axis);
    }

    public CumProd(SameDiff sameDiff, SDVariable x, boolean exclusive, boolean reverse, int ... axis) {
        super(null, sameDiff, new SDVariable[]{x});
        this.sameDiff = sameDiff;
        this.exclusive = exclusive;
        this.reverse = reverse;
        this.axis = axis;
        this.tArguments.clear();
        this.iArguments.clear();
        this.addArgs();
    }

    public CumProd(INDArray in, INDArray result, boolean exclusive, boolean reverse, int ... axis) {
        super(null, new INDArray[]{in}, new INDArray[]{result}, null, (List<Integer>)null);
        this.exclusive = exclusive;
        this.reverse = reverse;
        this.axis = axis;
        this.tArguments.clear();
        this.iArguments.clear();
        this.addArgs();
    }

    @Override
    public String opName() {
        return "cumprod";
    }

    @Override
    public String tensorflowName() {
        return "Cumprod";
    }

    @Override
    public Map<String, Map<String, AttributeAdapter>> attributeAdaptersForFunction() {
        HashMap<String, Map<String, AttributeAdapter>> ret = new HashMap<String, Map<String, AttributeAdapter>>();
        LinkedHashMap<String, BooleanAdapter> tfMappings = new LinkedHashMap<String, BooleanAdapter>();
        tfMappings.put("exclusive", new BooleanAdapter());
        tfMappings.put("reverse", new BooleanAdapter());
        ret.put(this.tensorflowName(), tfMappings);
        return ret;
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping exclusiveMapper = PropertyMapping.builder().tfAttrName("exclusive").propertyNames(new String[]{"exclusive"}).build();
        PropertyMapping reverseMapper = PropertyMapping.builder().tfAttrName("reverse").propertyNames(new String[]{"reverse"}).build();
        map.put("exclusive", exclusiveMapper);
        map.put("reverse", reverseMapper);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.getInstance().initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    protected void addArgs() {
        this.addIArgument(this.exclusive ? 1 : 0, this.reverse ? 1 : 0);
        if (this.axis != null) {
            for (int a : this.axis) {
                this.addIArgument(a);
            }
        }
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        super.initFromOnnx(node, initWith, attributesForNode, graph);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        return Collections.singletonList(this.f().cumprodBp(this.arg(0), grad.get(0), this.exclusive, this.reverse, this.axis));
    }
}

