/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.List;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShapeOp
extends BaseOp {
    private static final Logger log = LoggerFactory.getLogger(ShapeOp.class);

    public ShapeOp() {
    }

    public ShapeOp(SameDiff sameDiff) {
        this.sameDiff = sameDiff;
    }

    public ShapeOp(SameDiff sameDiff, SDVariable i_v, boolean inPlace) {
        this(sameDiff, i_v, i_v.getShape(), inPlace, null);
    }

    public ShapeOp(SameDiff sameDiff, SDVariable i_v, int[] shape, boolean inPlace, Object[] extraArgs) {
        this(sameDiff, i_v, ArrayUtil.toLongArray((int[])shape), inPlace, extraArgs);
    }

    public ShapeOp(SameDiff sameDiff, SDVariable i_v, long[] shape, boolean inPlace, Object[] extraArgs) {
        super(sameDiff, inPlace, extraArgs);
        if (i_v != null) {
            this.f().validateDifferentialFunctionsameDiff(i_v);
            this.xVertexId = i_v.getVarName();
            sameDiff.addArgsFor(new String[]{this.xVertexId}, (DifferentialFunction)this);
            if (Shape.isPlaceholderShape(i_v.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v.getVarName());
            }
        } else {
            throw new IllegalArgumentException("Input not null variable.");
        }
    }

    public ShapeOp(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public ShapeOp(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    @Override
    public List<long[]> calculateOutputShape() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Op.Type opType() {
        return Op.Type.SHAPE;
    }

    public ShapeOp(INDArray x) {
        super(x);
    }

    public ShapeOp(INDArray x, INDArray z) {
        super(x, z);
    }
}

