/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning.config;

import java.util.Map;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.AdaGradUpdater;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class AdaGrad
implements IUpdater {
    public static final double DEFAULT_ADAGRAD_LEARNING_RATE = 0.1;
    public static final double DEFAULT_ADAGRAD_EPSILON = 1.0E-6;
    private double learningRate;
    private ISchedule learningRateSchedule;
    private double epsilon;

    public AdaGrad() {
        this(0.1, null, 1.0E-6);
    }

    public AdaGrad(double learningRate) {
        this(learningRate, null, 1.0E-6);
    }

    public AdaGrad(double learningRate, double epsilon) {
        this(learningRate, null, epsilon);
    }

    public AdaGrad(ISchedule learningRateSchedule) {
        this(Double.NaN, learningRateSchedule, 1.0E-6);
    }

    public AdaGrad(ISchedule learningRateSchedule, double epsilon) {
        this(Double.NaN, learningRateSchedule, epsilon);
    }

    private AdaGrad(@JsonProperty(value="learningRate") double learningRate, @JsonProperty(value="learningRateSchedule") ISchedule learningRateSchedule, @JsonProperty(value="epsilon") double epsilon) {
        this.learningRate = learningRate;
        this.learningRateSchedule = learningRateSchedule;
        this.epsilon = epsilon;
    }

    @Override
    public long stateSize(long numParams) {
        return numParams;
    }

    @Override
    public GradientUpdater instantiate(INDArray viewArray, boolean initializeViewArray) {
        AdaGradUpdater u = new AdaGradUpdater(this);
        u.setStateViewArray(viewArray, viewArray.shape(), viewArray.ordering(), initializeViewArray);
        return u;
    }

    @Override
    public GradientUpdater instantiate(Map<String, INDArray> updaterState, boolean initializeStateArrays) {
        AdaGradUpdater u = new AdaGradUpdater(this);
        u.setState(updaterState, initializeStateArrays);
        return u;
    }

    @Override
    public AdaGrad clone() {
        return new AdaGrad(this.learningRate, this.epsilon);
    }

    @Override
    public double getLearningRate(int iteration, int epoch) {
        if (this.learningRateSchedule != null) {
            return this.learningRateSchedule.valueAt(iteration, epoch);
        }
        return this.learningRate;
    }

    @Override
    public boolean hasLearningRate() {
        return true;
    }

    @Override
    public void setLrAndSchedule(double lr, ISchedule lrSchedule) {
        this.learningRate = lr;
        this.learningRateSchedule = lrSchedule;
    }

    private static double $default$learningRate() {
        return 0.1;
    }

    private static double $default$epsilon() {
        return 1.0E-6;
    }

    public static Builder builder() {
        return new Builder();
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public ISchedule getLearningRateSchedule() {
        return this.learningRateSchedule;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setLearningRateSchedule(ISchedule learningRateSchedule) {
        this.learningRateSchedule = learningRateSchedule;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdaGrad)) {
            return false;
        }
        AdaGrad other = (AdaGrad)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getEpsilon(), other.getEpsilon()) != 0) {
            return false;
        }
        ISchedule this$learningRateSchedule = this.getLearningRateSchedule();
        ISchedule other$learningRateSchedule = other.getLearningRateSchedule();
        return !(this$learningRateSchedule == null ? other$learningRateSchedule != null : !this$learningRateSchedule.equals(other$learningRateSchedule));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdaGrad;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        ISchedule $learningRateSchedule = this.getLearningRateSchedule();
        result = result * 59 + ($learningRateSchedule == null ? 43 : $learningRateSchedule.hashCode());
        return result;
    }

    public String toString() {
        return "AdaGrad(learningRate=" + this.getLearningRate() + ", learningRateSchedule=" + this.getLearningRateSchedule() + ", epsilon=" + this.getEpsilon() + ")";
    }

    public static class Builder {
        private boolean learningRate$set;
        private double learningRate$value;
        private ISchedule learningRateSchedule;
        private boolean epsilon$set;
        private double epsilon$value;

        public Builder learningRate(double learningRate) {
            this.learningRate$value = learningRate;
            this.learningRate$set = true;
            return this;
        }

        public Builder learningRateSchedule(ISchedule learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
            return this;
        }

        public Builder epsilon(double epsilon) {
            this.epsilon$value = epsilon;
            this.epsilon$set = true;
            return this;
        }

        public AdaGrad build() {
            double learningRate$value = this.learningRate$value;
            if (!this.learningRate$set) {
                learningRate$value = AdaGrad.$default$learningRate();
            }
            double epsilon$value = this.epsilon$value;
            if (!this.epsilon$set) {
                epsilon$value = AdaGrad.$default$epsilon();
            }
            return new AdaGrad(learningRate$value, this.learningRateSchedule, epsilon$value);
        }

        public String toString() {
            return "AdaGrad.Builder(learningRate$value=" + this.learningRate$value + ", learningRateSchedule=" + this.learningRateSchedule + ", epsilon$value=" + this.epsilon$value + ")";
        }
    }
}

