/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.custom;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomExponential
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(RandomExponential.class);
    private double lambda = 0.0;
    private DataType dataType = DataType.DOUBLE;

    public RandomExponential() {
    }

    public RandomExponential(SameDiff sd, SDVariable shape, double lambda) {
        super(null, sd, new SDVariable[]{shape});
        Preconditions.checkState((lambda >= 0.0 ? 1 : 0) != 0, (String)"Lambda parameter must be > 0 - got %s", (double)lambda);
        this.lambda = lambda;
        this.addTArgument(lambda);
    }

    public RandomExponential(SameDiff sd, double lambda, DataType dataType, long ... shape) {
        super(null, sd, new SDVariable[]{sd.constant(Nd4j.createFromArray(shape))});
        this.lambda = lambda;
        this.addTArgument(lambda);
        this.dataType = dataType;
        this.addDArgument(dataType);
        this.addIArgument(shape);
    }

    public RandomExponential(double lambda, DataType datatype, long ... shape) {
        this(Nd4j.createFromArray(shape), Nd4j.createUninitialized(datatype, shape), lambda);
    }

    public RandomExponential(INDArray shape, INDArray out, double lambda) {
        super(null, new INDArray[]{shape}, new INDArray[]{out}, Collections.singletonList(lambda), (List<Integer>)null);
        this.lambda = lambda;
    }

    @Override
    public String opName() {
        return "random_exponential";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradients) {
        return Collections.singletonList(this.sameDiff.zerosLike(this.arg()));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(DataType.FLOAT);
    }
}

