/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.shape.Transpose;
import org.nd4j.shade.guava.primitives.Ints;

public class Permute
extends Transpose {
    private int[] reverseDims;

    public Permute(SameDiff sameDiff, SDVariable i_v, int ... permuteDims) {
        super(sameDiff, i_v);
        this.permuteDims = permuteDims;
        this.reverseDims = new int[permuteDims.length];
        for (int i = 0; i < this.reverseDims.length; ++i) {
            this.reverseDims[i] = ArrayUtils.indexOf((int[])permuteDims, (int)i);
        }
        this.addIArgument(permuteDims);
    }

    public Permute(INDArray input, INDArray result, int ... permuteDims) {
        super(input, result);
        this.permuteDims = permuteDims;
        this.reverseDims = new int[permuteDims.length];
        for (int i = 0; i < this.reverseDims.length; ++i) {
            this.reverseDims[i] = ArrayUtils.indexOf((int[])permuteDims, (int)i);
        }
        this.addIArgument(permuteDims);
    }

    public Permute(SameDiff sd, SDVariable input, SDVariable permuteDims) {
        super(sd, input, permuteDims);
    }

    public Permute(INDArray input, int ... permuteDims) {
        super(input, null);
        this.permuteDims = permuteDims;
        this.addIArgument(permuteDims);
    }

    public Permute() {
    }

    @Override
    public String opName() {
        return "permute";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable ret = this.args().length == 1 ? this.sameDiff.permute(i_v.get(0), this.reverseDims) : this.sameDiff.permute(i_v.get(0), this.sameDiff.invertPermutation(this.arg(1)));
        return Collections.singletonList(ret);
    }

    @Override
    public void configureFromArguments() {
        super.configureFromArguments();
        if (!this.iArguments.isEmpty()) {
            this.reverseDims = Ints.toArray((Collection)this.iArguments);
            this.permuteDims = Ints.toArray((Collection)this.iArguments);
            for (int i = 0; i < this.reverseDims.length; ++i) {
                this.reverseDims[i] = ArrayUtils.indexOf((int[])this.permuteDims, (int)i);
            }
        }
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        return super.calculateOutputDataTypes(dataTypes);
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }
}

