/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.validation;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.validation.functions.EqualityFn;
import org.nd4j.autodiff.validation.functions.RelErrorFn;
import org.nd4j.common.function.Function;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;

public class OpTestCase {
    private final DynamicCustomOp op;
    private Map<Integer, Function<INDArray, String>> testFns = new LinkedHashMap<Integer, Function<INDArray, String>>();
    private Map<Integer, LongShapeDescriptor> expShapes = new HashMap<Integer, LongShapeDescriptor>();

    public OpTestCase(@NonNull DynamicCustomOp op) {
        if (op == null) {
            throw new NullPointerException("op is marked non-null but is null");
        }
        this.op = op;
    }

    public OpTestCase expectedOutput(int outputNum, INDArray expected) {
        return this.expectedOutput(outputNum, expected, 0.001);
    }

    public OpTestCase expectedOutput(int outputNum, INDArray expected, double eps) {
        this.testFns.put(outputNum, new EqualityFn(expected, eps));
        this.expShapes.put(outputNum, expected.shapeDescriptor());
        return this;
    }

    public OpTestCase expectedOutputRelError(int outputNum, @NonNull INDArray expected, double maxRelError, double minAbsError) {
        if (expected == null) {
            throw new NullPointerException("expected is marked non-null but is null");
        }
        this.testFns.put(outputNum, new RelErrorFn(expected, maxRelError, minAbsError));
        this.expShapes.put(outputNum, expected.shapeDescriptor());
        return this;
    }

    public OpTestCase expectedOutput(int outputNum, @NonNull LongShapeDescriptor expShape, @NonNull Function<INDArray, String> validationFn) {
        if (expShape == null) {
            throw new NullPointerException("expShape is marked non-null but is null");
        }
        if (validationFn == null) {
            throw new NullPointerException("validationFn is marked non-null but is null");
        }
        this.testFns.put(outputNum, validationFn);
        this.expShapes.put(outputNum, expShape);
        return this;
    }

    public DynamicCustomOp op() {
        return this.op;
    }

    public Map<Integer, Function<INDArray, String>> testFns() {
        return this.testFns;
    }

    public Map<Integer, LongShapeDescriptor> expShapes() {
        return this.expShapes;
    }

    public OpTestCase testFns(Map<Integer, Function<INDArray, String>> testFns) {
        this.testFns = testFns;
        return this;
    }

    public OpTestCase expShapes(Map<Integer, LongShapeDescriptor> expShapes) {
        this.expShapes = expShapes;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpTestCase)) {
            return false;
        }
        OpTestCase other = (OpTestCase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DynamicCustomOp this$op = this.op();
        DynamicCustomOp other$op = other.op();
        if (this$op == null ? other$op != null : !((Object)this$op).equals(other$op)) {
            return false;
        }
        Map<Integer, Function<INDArray, String>> this$testFns = this.testFns();
        Map<Integer, Function<INDArray, String>> other$testFns = other.testFns();
        if (this$testFns == null ? other$testFns != null : !((Object)this$testFns).equals(other$testFns)) {
            return false;
        }
        Map<Integer, LongShapeDescriptor> this$expShapes = this.expShapes();
        Map<Integer, LongShapeDescriptor> other$expShapes = other.expShapes();
        return !(this$expShapes == null ? other$expShapes != null : !((Object)this$expShapes).equals(other$expShapes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpTestCase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DynamicCustomOp $op = this.op();
        result = result * 59 + ($op == null ? 43 : ((Object)$op).hashCode());
        Map<Integer, Function<INDArray, String>> $testFns = this.testFns();
        result = result * 59 + ($testFns == null ? 43 : ((Object)$testFns).hashCode());
        Map<Integer, LongShapeDescriptor> $expShapes = this.expShapes();
        result = result * 59 + ($expShapes == null ? 43 : ((Object)$expShapes).hashCode());
        return result;
    }

    public String toString() {
        return "OpTestCase(op=" + this.op() + ", testFns=" + this.testFns() + ", expShapes=" + this.expShapes() + ")";
    }
}

