/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class VarScalingNormalFanOutInitScheme
extends BaseWeightInitScheme {
    private double fanOut;

    public VarScalingNormalFanOutInitScheme(char order, double fanOut) {
        super(order);
        this.fanOut = fanOut;
    }

    @Override
    public INDArray doCreate(DataType dataType, long[] shape, INDArray paramsView) {
        return Nd4j.randn(dataType, this.order(), shape).divi(FastMath.sqrt((double)this.fanOut));
    }

    @Override
    public WeightInit type() {
        return WeightInit.VAR_SCALING_NORMAL_FAN_OUT;
    }

    public static VarScalingNormalFanOutInitSchemeBuilder builder() {
        return new VarScalingNormalFanOutInitSchemeBuilder();
    }

    public static class VarScalingNormalFanOutInitSchemeBuilder {
        private char order;
        private double fanOut;

        VarScalingNormalFanOutInitSchemeBuilder() {
        }

        public VarScalingNormalFanOutInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public VarScalingNormalFanOutInitSchemeBuilder fanOut(double fanOut) {
            this.fanOut = fanOut;
            return this;
        }

        public VarScalingNormalFanOutInitScheme build() {
            return new VarScalingNormalFanOutInitScheme(this.order, this.fanOut);
        }

        public String toString() {
            return "VarScalingNormalFanOutInitScheme.VarScalingNormalFanOutInitSchemeBuilder(order=" + this.order + ", fanOut=" + this.fanOut + ")";
        }
    }
}

