/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor.serializer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import lombok.NonNull;
import org.nd4j.linalg.dataset.api.preprocessor.MultiNormalizerStandardize;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerSerializerStrategy;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerType;
import org.nd4j.linalg.dataset.api.preprocessor.stats.DistributionStats;
import org.nd4j.linalg.factory.Nd4j;

public class MultiStandardizeSerializerStrategy
implements NormalizerSerializerStrategy<MultiNormalizerStandardize> {
    @Override
    public void write(@NonNull MultiNormalizerStandardize normalizer, @NonNull OutputStream stream) throws IOException {
        if (normalizer == null) {
            throw new NullPointerException("normalizer is marked non-null but is null");
        }
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        try (DataOutputStream dos = new DataOutputStream(stream);){
            int i;
            dos.writeBoolean(normalizer.isFitLabel());
            dos.writeInt(normalizer.numInputs());
            dos.writeInt(normalizer.isFitLabel() ? normalizer.numOutputs() : -1);
            for (i = 0; i < normalizer.numInputs(); ++i) {
                Nd4j.write(normalizer.getFeatureMean(i), dos);
                Nd4j.write(normalizer.getFeatureStd(i), dos);
            }
            if (normalizer.isFitLabel()) {
                for (i = 0; i < normalizer.numOutputs(); ++i) {
                    Nd4j.write(normalizer.getLabelMean(i), dos);
                    Nd4j.write(normalizer.getLabelStd(i), dos);
                }
            }
            dos.flush();
        }
    }

    @Override
    public MultiNormalizerStandardize restore(@NonNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        DataInputStream dis = new DataInputStream(stream);
        boolean fitLabels = dis.readBoolean();
        int numInputs = dis.readInt();
        int numOutputs = dis.readInt();
        MultiNormalizerStandardize result = new MultiNormalizerStandardize();
        result.fitLabel(fitLabels);
        ArrayList<DistributionStats> featureStats = new ArrayList<DistributionStats>();
        for (int i = 0; i < numInputs; ++i) {
            featureStats.add(new DistributionStats(Nd4j.read(dis), Nd4j.read(dis)));
        }
        result.setFeatureStats(featureStats);
        if (fitLabels) {
            ArrayList<DistributionStats> labelStats = new ArrayList<DistributionStats>();
            for (int i = 0; i < numOutputs; ++i) {
                labelStats.add(new DistributionStats(Nd4j.read(dis), Nd4j.read(dis)));
            }
            result.setLabelStats(labelStats);
        }
        return result;
    }

    @Override
    public NormalizerType getSupportedType() {
        return NormalizerType.MULTI_STANDARDIZE;
    }
}

