/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.compression;

import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class EncodeThreshold
extends DynamicCustomOp {
    protected float threshold = 0.001f;
    protected int boundary = Integer.MAX_VALUE;

    public EncodeThreshold() {
    }

    public EncodeThreshold(@NonNull INDArray updates, float threshold) {
        this(updates, threshold, Integer.MAX_VALUE);
        if (updates == null) {
            throw new NullPointerException("updates is marked non-null but is null");
        }
    }

    public EncodeThreshold(@NonNull INDArray updates, @NonNull INDArray encoded, float threshold, @NonNull Integer boundary) {
        this(updates, threshold, boundary);
        if (updates == null) {
            throw new NullPointerException("updates is marked non-null but is null");
        }
        if (encoded == null) {
            throw new NullPointerException("encoded is marked non-null but is null");
        }
        if (boundary == null) {
            throw new NullPointerException("boundary is marked non-null but is null");
        }
        this.addOutputArgument(updates, encoded);
    }

    public EncodeThreshold(@NonNull INDArray updates, float threshold, @NonNull Integer boundary) {
        if (updates == null) {
            throw new NullPointerException("updates is marked non-null but is null");
        }
        if (boundary == null) {
            throw new NullPointerException("boundary is marked non-null but is null");
        }
        this.addInputArgument(updates);
        this.addTArgument(threshold);
        this.addIArgument(boundary);
        this.threshold = threshold;
        this.boundary = boundary;
    }

    @Override
    public String opName() {
        return "encode_threshold";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        return Arrays.asList(((INDArray)this.inputArguments.get(0)).dataType(), DataType.INT32);
    }
}

