/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ndarray;

import lombok.NonNull;
import org.nd4j.linalg.api.shape.Shape;

public class JvmShapeInfo {
    protected final long[] javaShapeInformation;
    protected final long[] shape;
    protected final long[] stride;
    protected final long length;
    protected final long ews;
    protected final long extras;
    protected final char order;
    protected final int rank;

    public JvmShapeInfo(@NonNull long[] javaShapeInformation) {
        if (javaShapeInformation == null) {
            throw new NullPointerException("javaShapeInformation is marked non-null but is null");
        }
        this.javaShapeInformation = javaShapeInformation;
        this.shape = Shape.shape(javaShapeInformation);
        this.stride = Shape.stride(javaShapeInformation);
        this.length = Shape.isEmpty(javaShapeInformation) ? 0L : Shape.length(javaShapeInformation);
        this.ews = Shape.elementWiseStride(javaShapeInformation);
        this.extras = Shape.extras(javaShapeInformation);
        this.order = Shape.order(javaShapeInformation);
        this.rank = Shape.rank(javaShapeInformation);
    }

    public long[] getJavaShapeInformation() {
        return this.javaShapeInformation;
    }

    public long[] getShape() {
        return this.shape;
    }

    public long[] getStride() {
        return this.stride;
    }

    public long getLength() {
        return this.length;
    }

    public long getEws() {
        return this.ews;
    }

    public long getExtras() {
        return this.extras;
    }

    public char getOrder() {
        return this.order;
    }

    public int getRank() {
        return this.rank;
    }
}

