/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.profiler.data;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.profiler.data.primitives.ComparableAtomicLong;
import org.nd4j.linalg.profiler.data.primitives.TimeSet;
import org.nd4j.linalg.util.ArrayUtil;

public class StringAggregator {
    private Map<String, TimeSet> times = new ConcurrentHashMap<String, TimeSet>();
    private Map<String, ComparableAtomicLong> longCalls = new ConcurrentHashMap<String, ComparableAtomicLong>();
    private static final long THRESHOLD = 100000L;

    public void reset() {
        for (String key : this.times.keySet()) {
            this.times.put(key, new TimeSet());
        }
        for (String key : this.longCalls.keySet()) {
            this.longCalls.put(key, new ComparableAtomicLong(0L));
        }
    }

    public void putTime(String key, Op op, long timeSpent) {
        if (!this.times.containsKey(key)) {
            this.times.put(key, new TimeSet());
        }
        this.times.get(key).addTime(timeSpent);
        if (timeSpent > 100000L) {
            String keyExt = key + " " + op.name() + " (" + op.opNum() + ")";
            if (!this.longCalls.containsKey(keyExt)) {
                this.longCalls.put(keyExt, new ComparableAtomicLong(0L));
            }
            this.longCalls.get(keyExt).incrementAndGet();
        }
    }

    public void putTime(String key, long timeSpent) {
        if (!this.times.containsKey(key)) {
            this.times.put(key, new TimeSet());
        }
        this.times.get(key).addTime(timeSpent);
    }

    protected long getMedian(String key) {
        return this.times.get(key).getMedian();
    }

    protected long getAverage(String key) {
        return this.times.get(key).getAverage();
    }

    protected long getMaximum(String key) {
        return this.times.get(key).getMaximum();
    }

    protected long getMinimum(String key) {
        return this.times.get(key).getMinimum();
    }

    protected long getSum(String key) {
        return this.times.get(key).getSum();
    }

    public String asPercentageString() {
        StringBuilder builder = new StringBuilder();
        Map sortedTimes = ArrayUtil.sortMapByValue(this.times);
        AtomicLong sum = new AtomicLong(0L);
        for (String key : sortedTimes.keySet()) {
            sum.addAndGet(this.getSum(key));
        }
        long lSum = sum.get();
        builder.append("Total time spent: ").append(lSum / 1000000L).append(" ms.").append("\n");
        for (String key : sortedTimes.keySet()) {
            long currentSum = this.getSum(key);
            float perc = lSum == 0L ? 0.0f : (float)currentSum * 100.0f / (float)sum.get();
            long sumMs = currentSum / 1000000L;
            builder.append(key).append("  >>> ").append(" perc: ").append(perc).append(" ").append("Time spent: ").append(sumMs).append(" ms");
            builder.append("\n");
        }
        return builder.toString();
    }

    public String asString() {
        StringBuilder builder = new StringBuilder();
        Map sortedTimes = ArrayUtil.sortMapByValue(this.times);
        for (String key : sortedTimes.keySet()) {
            long currentMax = this.getMaximum(key);
            long currentMin = this.getMinimum(key);
            long currentAvg = this.getAverage(key);
            long currentMed = this.getMedian(key);
            builder.append(key).append("  >>> ");
            if (this.longCalls.size() == 0) {
                builder.append(" ").append(((TimeSet)sortedTimes.get(key)).size()).append(" calls; ");
            }
            builder.append("Min: ").append(currentMin).append(" ns; ").append("Max: ").append(currentMax).append(" ns; ").append("Average: ").append(currentAvg).append(" ns; ").append("Median: ").append(currentMed).append(" ns; ");
            builder.append("\n");
        }
        builder.append("\n");
        Map sortedCalls = ArrayUtil.sortMapByValue(this.longCalls);
        for (String key : sortedCalls.keySet()) {
            long numCalls = ((ComparableAtomicLong)sortedCalls.get(key)).get();
            builder.append(key).append("  >>> ").append(numCalls);
            builder.append("\n");
        }
        builder.append("\n");
        return builder.toString();
    }
}

