/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.GradientUpdaterAggregator;
import org.nd4j.linalg.ops.transforms.Transforms;

public class RmsProp
implements GradientUpdater {
    public static final double DEFAULT_RMSPROP_EPSILON = 1.0E-8;
    public static final double DEFAULT_RMSPROP_RMSDECAY = 0.95;
    private INDArray lastGradient;
    private double rmsDecay = 0.95;
    private double learningRate = 0.1;
    private double epsilon = 1.0E-8;

    public RmsProp(double learningRate, double rmsDecay) {
        this(learningRate, rmsDecay, 1.0E-8);
    }

    public RmsProp(double learningRate, double rmsDecay, double epsilon) {
        this.learningRate = learningRate;
        this.rmsDecay = rmsDecay;
        this.epsilon = epsilon;
    }

    @Override
    public int stateSizeForInputSize(int inputSize) {
        return inputSize;
    }

    @Override
    public void setStateViewArray(INDArray viewArray, int[] gradientShape, char gradientOrder, boolean initialize) {
        if (!viewArray.isRowVector()) {
            throw new IllegalArgumentException("Invalid input: expect row vector input");
        }
        if (initialize) {
            viewArray.assign(this.epsilon);
        }
        this.lastGradient = viewArray;
        this.lastGradient = Shape.newShapeNoCopy(this.lastGradient, gradientShape, gradientOrder == 'f');
        if (this.lastGradient == null) {
            throw new IllegalStateException("Could not correctly reshape gradient view array");
        }
    }

    @Override
    public void update(Object ... args) {
        if (args.length > 0) {
            this.learningRate = (Double)args[0];
        }
    }

    @Override
    public INDArray getGradient(INDArray gradient, int iteration) {
        if (this.lastGradient == null) {
            throw new IllegalStateException("Updater has not been initialized with view state");
        }
        this.lastGradient.muli(this.rmsDecay).addi(gradient.mul(gradient).muli(1.0 - this.rmsDecay));
        return gradient.muli(this.learningRate).divi(Transforms.sqrt(this.lastGradient, true).addi(this.epsilon));
    }

    @Override
    public GradientUpdaterAggregator getAggregator(boolean addThis) {
        RmsPropAggregator ag = new RmsPropAggregator();
        if (addThis) {
            ag.aggregate(this);
        }
        return ag;
    }

    public INDArray getLastGradient() {
        return this.lastGradient;
    }

    public double getRmsDecay() {
        return this.rmsDecay;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setLastGradient(INDArray lastGradient) {
        this.lastGradient = lastGradient;
    }

    public void setRmsDecay(double rmsDecay) {
        this.rmsDecay = rmsDecay;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RmsProp)) {
            return false;
        }
        RmsProp other = (RmsProp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        INDArray this$lastGradient = this.getLastGradient();
        INDArray other$lastGradient = other.getLastGradient();
        if (this$lastGradient == null ? other$lastGradient != null : !this$lastGradient.equals(other$lastGradient)) {
            return false;
        }
        if (Double.compare(this.getRmsDecay(), other.getRmsDecay()) != 0) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        return Double.compare(this.getEpsilon(), other.getEpsilon()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof RmsProp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INDArray $lastGradient = this.getLastGradient();
        result = result * 59 + ($lastGradient == null ? 43 : $lastGradient.hashCode());
        long $rmsDecay = Double.doubleToLongBits(this.getRmsDecay());
        result = result * 59 + (int)($rmsDecay >>> 32 ^ $rmsDecay);
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        return result;
    }

    public String toString() {
        return "RmsProp(lastGradient=" + this.getLastGradient() + ", rmsDecay=" + this.getRmsDecay() + ", learningRate=" + this.getLearningRate() + ", epsilon=" + this.getEpsilon() + ")";
    }

    public RmsProp() {
    }

    public static class RmsPropAggregator
    implements GradientUpdaterAggregator {
        private INDArray lastGradientSum;
        private double rmsDecaySum;
        private double lrSum;
        private int count = 0;

        @Override
        public GradientUpdater getUpdater() {
            RmsProp rmsProp = new RmsProp(this.lrSum / (double)this.count, this.rmsDecaySum / (double)this.count);
            rmsProp.setLastGradient(this.lastGradientSum.div(this.count));
            return rmsProp;
        }

        @Override
        public void aggregate(GradientUpdater updater) {
            if (!(updater instanceof RmsProp)) {
                throw new UnsupportedOperationException();
            }
            RmsProp rmsProp = (RmsProp)updater;
            if (this.lastGradientSum == null) {
                this.lastGradientSum = rmsProp.lastGradient.dup();
                this.rmsDecaySum = rmsProp.rmsDecay;
                this.lrSum = rmsProp.learningRate;
            } else {
                this.lastGradientSum.addi(rmsProp.lastGradient);
                this.rmsDecaySum += rmsProp.rmsDecay;
                this.lrSum += rmsProp.learningRate;
            }
            ++this.count;
        }

        @Override
        public GradientUpdaterAggregator combine(GradientUpdaterAggregator other) {
            if (!(other instanceof RmsPropAggregator)) {
                throw new IllegalArgumentException("Cannot combine RmsPropAggregator with aggregator: " + other);
            }
            RmsPropAggregator aggregator = (RmsPropAggregator)other;
            this.lastGradientSum.addi(aggregator.lastGradientSum);
            this.rmsDecaySum += aggregator.rmsDecaySum;
            this.lrSum += aggregator.lrSum;
            this.count += aggregator.count;
            return this;
        }
    }
}

