/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import java.io.Serializable;
import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.GradientUpdaterAggregator;
import org.nd4j.linalg.ops.transforms.Transforms;

public class Adam
implements Serializable,
GradientUpdater {
    public static final double DEFAULT_ADAM_EPSILON = 1.0E-8;
    public static final double DEFAULT_ADAM_BETA1_MEAN_DECAY = 0.9;
    public static final double DEFAULT_ADAM_BETA2_VAR_DECAY = 0.999;
    private double learningRate = 0.001;
    private double beta1 = 0.9;
    private double beta2 = 0.999;
    private double epsilon = 1.0E-8;
    private INDArray m;
    private INDArray v;

    @Override
    public int stateSizeForInputSize(int inputSize) {
        return 2 * inputSize;
    }

    @Override
    public void setStateViewArray(INDArray viewArray, int[] gradientShape, char gradientOrder, boolean initialize) {
        if (!viewArray.isRowVector()) {
            throw new IllegalArgumentException("Invalid input: expect row vector input");
        }
        if (initialize) {
            viewArray.assign(0);
        }
        int length = viewArray.length();
        this.m = viewArray.get(NDArrayIndex.point(0), NDArrayIndex.interval(0, length / 2));
        this.v = viewArray.get(NDArrayIndex.point(0), NDArrayIndex.interval(length / 2, length));
        this.m = Shape.newShapeNoCopy(this.m, gradientShape, gradientOrder == 'f');
        this.v = Shape.newShapeNoCopy(this.v, gradientShape, gradientOrder == 'f');
        if (this.m == null || this.v == null) {
            throw new IllegalStateException("Could not correctly reshape gradient view arrays");
        }
    }

    public Adam(double alpha, double beta1, double beta2, double epsilon) {
        this.learningRate = alpha;
        this.beta1 = beta1;
        this.beta2 = beta2;
        this.epsilon = epsilon;
    }

    public Adam(double alpha, double beta1, double beta2) {
        this.learningRate = alpha;
        this.beta1 = beta1;
        this.beta2 = beta2;
    }

    public Adam(double alpha) {
        this.learningRate = alpha;
    }

    @Override
    public void update(Object ... args) {
        if (args.length > 0) {
            this.learningRate = (Double)args[0];
        }
    }

    @Override
    public INDArray getGradient(INDArray gradient, int iteration) {
        if (this.m == null || this.v == null) {
            throw new IllegalStateException("Updater has not been initialized with view state");
        }
        INDArray oneMinusBeta1Grad = gradient.mul(1.0 - this.beta1);
        this.m.muli(this.beta1).addi(oneMinusBeta1Grad);
        INDArray oneMinusBeta2GradSquared = gradient.mul(gradient).muli(1.0 - this.beta2);
        this.v.muli(this.beta2).addi(oneMinusBeta2GradSquared);
        double beta1t = FastMath.pow((double)this.beta1, (int)(iteration + 1));
        double beta2t = FastMath.pow((double)this.beta2, (int)(iteration + 1));
        double alphat = this.learningRate * FastMath.sqrt((double)(1.0 - beta2t)) / (1.0 - beta1t);
        if (Double.isNaN(alphat) || alphat == 0.0) {
            alphat = this.epsilon;
        }
        INDArray sqrtV = Transforms.sqrt(this.v, true).addi(this.epsilon);
        INDArray ret = this.m.mul(alphat).divi(sqrtV);
        gradient.assign(ret);
        return gradient;
    }

    @Override
    public GradientUpdaterAggregator getAggregator(boolean addThis) {
        AdamAggregator ag = new AdamAggregator();
        if (addThis) {
            ag.aggregate(this);
        }
        return ag;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getBeta1() {
        return this.beta1;
    }

    public double getBeta2() {
        return this.beta2;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public INDArray getM() {
        return this.m;
    }

    public INDArray getV() {
        return this.v;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setBeta1(double beta1) {
        this.beta1 = beta1;
    }

    public void setBeta2(double beta2) {
        this.beta2 = beta2;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public void setM(INDArray m) {
        this.m = m;
    }

    public void setV(INDArray v) {
        this.v = v;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Adam)) {
            return false;
        }
        Adam other = (Adam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeta1(), other.getBeta1()) != 0) {
            return false;
        }
        if (Double.compare(this.getBeta2(), other.getBeta2()) != 0) {
            return false;
        }
        if (Double.compare(this.getEpsilon(), other.getEpsilon()) != 0) {
            return false;
        }
        INDArray this$m = this.getM();
        INDArray other$m = other.getM();
        if (this$m == null ? other$m != null : !this$m.equals(other$m)) {
            return false;
        }
        INDArray this$v = this.getV();
        INDArray other$v = other.getV();
        return !(this$v == null ? other$v != null : !this$v.equals(other$v));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Adam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        long $beta1 = Double.doubleToLongBits(this.getBeta1());
        result = result * 59 + (int)($beta1 >>> 32 ^ $beta1);
        long $beta2 = Double.doubleToLongBits(this.getBeta2());
        result = result * 59 + (int)($beta2 >>> 32 ^ $beta2);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        INDArray $m = this.getM();
        result = result * 59 + ($m == null ? 43 : $m.hashCode());
        INDArray $v = this.getV();
        result = result * 59 + ($v == null ? 43 : $v.hashCode());
        return result;
    }

    public String toString() {
        return "Adam(learningRate=" + this.getLearningRate() + ", beta1=" + this.getBeta1() + ", beta2=" + this.getBeta2() + ", epsilon=" + this.getEpsilon() + ", m=" + this.getM() + ", v=" + this.getV() + ")";
    }

    public Adam() {
    }

    public static class AdamAggregator
    implements GradientUpdaterAggregator {
        private INDArray mSum;
        private INDArray vSum;
        private double lrSum;
        private double beta1Sum;
        private double beta2Sum;
        private double epsilonSum;
        private int count = 0;

        @Override
        public GradientUpdater getUpdater() {
            Adam adam = new Adam(this.lrSum / (double)this.count, this.beta1Sum / (double)this.count, this.beta2Sum / (double)this.count, this.epsilonSum / (double)this.count);
            adam.setM(this.mSum.div(this.count));
            adam.setV(this.vSum.div(this.count));
            return adam;
        }

        @Override
        public void aggregate(GradientUpdater updater) {
            if (!(updater instanceof Adam)) {
                throw new UnsupportedOperationException("Cannot aggregate Adam with updater: " + updater);
            }
            Adam adam = (Adam)updater;
            if (this.mSum == null) {
                this.mSum = adam.m.dup();
                this.vSum = adam.v.dup();
                this.lrSum = adam.learningRate;
                this.beta1Sum = adam.beta1;
                this.beta2Sum = adam.beta2;
                this.epsilonSum = adam.epsilon;
            } else {
                this.mSum.addi(adam.m);
                this.vSum.addi(adam.v);
                this.lrSum += adam.learningRate;
                this.beta1Sum += adam.beta1;
                this.beta2Sum += adam.beta2;
                this.epsilonSum += adam.epsilon;
            }
            ++this.count;
        }

        @Override
        public GradientUpdaterAggregator combine(GradientUpdaterAggregator other) {
            if (!(other instanceof AdamAggregator)) {
                throw new IllegalArgumentException("Cannot combine AdamAggregator with aggregator: " + other);
            }
            AdamAggregator aggregator = (AdamAggregator)other;
            this.mSum.addi(aggregator.mSum);
            this.vSum.addi(aggregator.vSum);
            this.lrSum += aggregator.lrSum;
            this.beta1Sum += aggregator.beta1Sum;
            this.beta2Sum += aggregator.beta2Sum;
            this.epsilonSum += aggregator.epsilonSum;
            this.count += aggregator.count;
            return this;
        }
    }
}

