/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import com.google.common.base.Function;
import com.google.common.primitives.Ints;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.nd4j.context.Nd4jContext;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.factory.DataBufferFactory;
import org.nd4j.linalg.api.buffer.factory.DefaultDataBufferFactory;
import org.nd4j.linalg.api.buffer.util.DataTypeUtil;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.concurrency.AffinityManager;
import org.nd4j.linalg.api.concurrency.BasicAffinityManager;
import org.nd4j.linalg.api.instrumentation.InMemoryInstrumentation;
import org.nd4j.linalg.api.instrumentation.Instrumentation;
import org.nd4j.linalg.api.ndarray.BaseShapeInfoProvider;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ndarray.ShapeInfoProvider;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.factory.DefaultOpFactory;
import org.nd4j.linalg.api.ops.factory.OpFactory;
import org.nd4j.linalg.api.ops.impl.indexaccum.IMax;
import org.nd4j.linalg.api.ops.impl.transforms.ReplaceNans;
import org.nd4j.linalg.api.ops.random.impl.Choice;
import org.nd4j.linalg.api.ops.random.impl.GaussianDistribution;
import org.nd4j.linalg.api.ops.random.impl.Linspace;
import org.nd4j.linalg.api.ops.random.impl.UniformDistribution;
import org.nd4j.linalg.api.rng.DefaultRandom;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.api.rng.distribution.factory.DefaultDistributionFactory;
import org.nd4j.linalg.api.rng.distribution.factory.DistributionFactory;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.cache.BasicConstantHandler;
import org.nd4j.linalg.cache.ConstantHandler;
import org.nd4j.linalg.compression.BasicNDArrayCompressor;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.convolution.ConvolutionInstance;
import org.nd4j.linalg.convolution.DefaultConvolutionInstance;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.BlasWrapper;
import org.nd4j.linalg.factory.NDArrayFactory;
import org.nd4j.linalg.factory.Nd4jBackend;
import org.nd4j.linalg.factory.RandomFactory;
import org.nd4j.linalg.fft.DefaultFFTInstance;
import org.nd4j.linalg.fft.FFTInstance;
import org.nd4j.linalg.memory.BasicMemoryManager;
import org.nd4j.linalg.memory.MemoryManager;
import org.nd4j.linalg.string.NDArrayStrings;
import org.nd4j.linalg.util.ArrayUtil;

public class Nd4j {
    public static final String NUMERICAL_STABILITY = "force.stability";
    public static final String FFT_OPS = "fft";
    public static final String DATA_BUFFER_OPS = "databufferfactory";
    public static final String CONVOLUTION_OPS = "convops";
    public static final String DTYPE = "dtype";
    public static final String BLAS_OPS = "blas.ops";
    public static final String NATIVE_OPS = "native.ops";
    public static final String ORDER_KEY = "ndarray.order";
    public static final String NDARRAY_FACTORY_CLASS = "ndarrayfactory.class";
    public static final String COPY_OPS = "ndarray.copyops";
    public static final String OP_EXECUTIONER = "opexec";
    public static final String OP_FACTORY = "opfactory";
    public static final String DISTRIBUTION = "dist";
    public static final String INSTRUMENTATION = "instrumentation";
    public static final String RESOURCE_MANGER_ON = "resourcemanager_state";
    public static final String EXECUTION_MODE = "opexec.mode";
    public static final String SHAPEINFO_PROVIDER = "shapeinfoprovider";
    public static final String CONSTANT_PROVIDER = "constantsprovider";
    public static final String AFFINITY_MANAGER = "affinitymanager";
    public static final String COMPRESSION_DEBUG = "compressiondebug";
    public static final String MEMORY_MANAGER = "memorymanager";
    public static final String RANDOM_PROVIDER = "random";
    public static OpExecutioner.ExecutionMode executionMode = OpExecutioner.ExecutionMode.JAVA;
    protected static DataBuffer.Type dtype = DataBuffer.Type.FLOAT;
    public static DataBuffer.AllocationMode alloc = DataBuffer.AllocationMode.HEAP;
    public static char ORDER = (char)99;
    public static IComplexNumber UNIT;
    public static IComplexNumber ZERO;
    public static IComplexNumber NEG_UNIT;
    public static double EPS_THRESHOLD;
    public static int MAX_ELEMENTS_PER_SLICE;
    public static int MAX_SLICES_TO_PRINT;
    public static boolean ENFORCE_NUMERICAL_STABILITY;
    public static boolean copyOnOps;
    public static boolean shouldInstrument;
    public static boolean resourceManagerOn;
    private static boolean allowsOrder;
    public static boolean compressDebug;
    public static boolean preventUnpack;
    public static Nd4jBackend backend;
    public static RandomFactory randomFactory;
    protected static Class<? extends BlasWrapper> blasWrapperClazz;
    protected static Class<? extends NDArrayFactory> ndArrayFactoryClazz;
    protected static Class<? extends FFTInstance> fftInstanceClazz;
    protected static Class<? extends ConvolutionInstance> convolutionInstanceClazz;
    protected static Class<? extends DataBufferFactory> dataBufferFactoryClazz;
    protected static Class<? extends OpExecutioner> opExecutionerClazz;
    protected static Class<? extends OpFactory> opFactoryClazz;
    protected static Class<? extends org.nd4j.linalg.api.rng.Random> randomClazz;
    protected static Class<? extends DistributionFactory> distributionFactoryClazz;
    protected static Class<? extends Instrumentation> instrumentationClazz;
    protected static Class<? extends BaseShapeInfoProvider> shapeInfoProviderClazz;
    protected static Class<? extends BasicConstantHandler> constantProviderClazz;
    protected static Class<? extends BasicAffinityManager> affinityManagerClazz;
    protected static Class<? extends BasicMemoryManager> memoryManagerClazz;
    protected static DataBufferFactory DATA_BUFFER_FACTORY_INSTANCE;
    protected static BlasWrapper BLAS_WRAPPER_INSTANCE;
    protected static NDArrayFactory INSTANCE;
    protected static FFTInstance FFT_INSTANCE;
    protected static ConvolutionInstance CONVOLUTION_INSTANCE;
    protected static OpExecutioner OP_EXECUTIONER_INSTANCE;
    protected static DistributionFactory DISTRIBUTION_FACTORY;
    protected static OpFactory OP_FACTORY_INSTANCE;
    protected static Instrumentation instrumentation;
    protected static ShapeInfoProvider shapeInfoProvider;
    protected static ConstantHandler constantHandler;
    protected static AffinityManager affinityManager;
    protected static MemoryManager memoryManager;
    protected static AtomicBoolean fallbackMode;
    protected static Properties props;
    protected static ReferenceQueue<INDArray> referenceQueue;
    protected static ReferenceQueue<DataBuffer> bufferQueue;
    private static final Logger logger;

    public static INDArray pad(INDArray toPad, int[][] padWidth, PadMode padMode) {
        return Nd4j.pad(toPad, padWidth, (List<double[]>)ArrayUtil.zerosMatrix((int[])toPad.shape()), padMode);
    }

    public static INDArray pad(INDArray toPad, int[][] padWidth, List<double[]> constantValues, PadMode padMode) {
        switch (padMode) {
            case CONSTANT: {
                if (padWidth.length < toPad.rank()) {
                    throw new IllegalArgumentException("Please specify a pad width for each dimension");
                }
                ArrayList<int[]> sizes = new ArrayList<int[]>();
                for (int i = 0; i < toPad.rank(); ++i) {
                    sizes.add(padWidth[i]);
                }
                INDArray ret = toPad;
                for (int i = 0; i < toPad.rank(); ++i) {
                    int[] pad = (int[])sizes.get(i);
                    double[] constant = constantValues.get(i);
                    int padBefore = pad[0];
                    int padAfter = pad[1];
                    if (constant.length < 2) {
                        double val = constant[0];
                        constant = new double[]{val, val};
                    }
                    double beforeVal = constant[0];
                    double afterVal = constant[1];
                    ret = Nd4j.prepend(ret, padBefore, beforeVal, i);
                    ret = Nd4j.append(ret, padAfter, afterVal, i);
                }
                return ret;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static INDArray pad(INDArray toPad, int[] padWidth, List<double[]> constantValues, PadMode padMode) {
        switch (padMode) {
            case CONSTANT: {
                if (padWidth.length < toPad.rank()) {
                    throw new IllegalArgumentException("Please specify a pad width for each dimension");
                }
                toPad = Nd4j.stripOnes(toPad);
                ArrayList<int[]> sizes = new ArrayList<int[]>();
                for (int i = 0; i < toPad.rank(); ++i) {
                    sizes.add(padWidth);
                }
                INDArray ret = toPad;
                for (int i = 0; i < toPad.rank(); ++i) {
                    int[] pad = (int[])sizes.get(i);
                    double[] constant = constantValues.get(i);
                    int padBefore = pad[0];
                    int padAfter = pad[1];
                    if (constant.length < 2) {
                        double val = constant[0];
                        constant = new double[]{val, val};
                    }
                    double beforeVal = constant[0];
                    double afterVal = constant[1];
                    ret = Nd4j.prepend(ret, padBefore, beforeVal, i);
                    ret = Nd4j.append(ret, padAfter, afterVal, i);
                }
                return ret;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static INDArray pad(INDArray toPad, int[] padWidth, PadMode padMode) {
        return Nd4j.pad(toPad, padWidth, (List<double[]>)ArrayUtil.zerosMatrix((int[])padWidth), padMode);
    }

    public static INDArray append(INDArray arr, int padAmount, double val, int axis) {
        if (padAmount == 0) {
            return arr;
        }
        int[] paShape = ArrayUtil.copy((int[])arr.shape());
        if (axis < 0) {
            axis += arr.shape().length;
        }
        paShape[axis] = padAmount;
        INDArray concatArray = Nd4j.valueArrayOf(paShape, val);
        return Nd4j.concat(axis, arr, concatArray);
    }

    public static INDArray prepend(INDArray arr, int padAmount, double val, int axis) {
        if (padAmount == 0) {
            return arr;
        }
        int[] paShape = ArrayUtil.copy((int[])arr.shape());
        if (axis < 0) {
            axis += arr.shape().length;
        }
        paShape[axis] = padAmount;
        INDArray concatArr = Nd4j.valueArrayOf(paShape, val);
        return Nd4j.concat(axis, concatArr, arr);
    }

    public static boolean allowsSpecifyOrdering() {
        return allowsOrder;
    }

    public static void shuffle(INDArray toShuffle, Random random, int ... dimension) {
        INSTANCE.shuffle(toShuffle, random, dimension);
    }

    public static void shuffle(INDArray toShuffle, int ... dimension) {
        INSTANCE.shuffle(toShuffle, new Random(), dimension);
    }

    public static void shuffle(Collection<INDArray> toShuffle, int ... dimension) {
        INSTANCE.shuffle(toShuffle, new Random(), dimension);
    }

    public static void shuffle(Collection<INDArray> toShuffle, Random rnd, int ... dimension) {
        INSTANCE.shuffle(toShuffle, rnd, dimension);
    }

    public static void shuffle(List<INDArray> toShuffle, Random rnd, List<int[]> dimensions) {
        INSTANCE.shuffle(toShuffle, rnd, dimensions);
    }

    public static ReferenceQueue<INDArray> refQueue() {
        return referenceQueue;
    }

    public static ReferenceQueue<DataBuffer> bufferRefQueue() {
        return bufferQueue;
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public static DistributionFactory getDistributions() {
        return DISTRIBUTION_FACTORY;
    }

    public static void setNdArrayFactoryClazz(Class<? extends NDArrayFactory> clazz) {
        ndArrayFactoryClazz = clazz;
    }

    public static org.nd4j.linalg.api.rng.Random getRandom() {
        return randomFactory.getRandom();
    }

    public static RandomFactory getRandomFactory() {
        return randomFactory;
    }

    public static ConvolutionInstance getConvolution() {
        return CONVOLUTION_INSTANCE;
    }

    public static void setConvolution(ConvolutionInstance convolutionInstance) {
        if (convolutionInstance == null) {
            throw new IllegalArgumentException("No null instances allowed");
        }
        CONVOLUTION_INSTANCE = convolutionInstance;
    }

    public static int[] shape(INDArray arr) {
        return arr.shape();
    }

    public static INDArray create(int[] sliceShape, float[] ... arrays) {
        int slices = arrays.length;
        INDArray ret = Nd4j.create(ArrayUtil.combine((int[][])new int[][]{{slices}, sliceShape}));
        for (int i = 0; i < ret.slices(); ++i) {
            ret.putSlice(i, Nd4j.create(arrays[i]).reshape(sliceShape));
        }
        return ret;
    }

    public static INDArray create(int[] sliceShape, double[] ... arrays) {
        int slices = arrays.length;
        INDArray ret = Nd4j.create(ArrayUtil.combine((int[][])new int[][]{{slices}, sliceShape}));
        for (int i = 0; i < ret.slices(); ++i) {
            ret.putSlice(i, Nd4j.create(arrays[i]).reshape(sliceShape));
        }
        return ret;
    }

    public static OpExecutioner getExecutioner() {
        return OP_EXECUTIONER_INSTANCE;
    }

    public static OpFactory getOpFactory() {
        return OP_FACTORY_INSTANCE;
    }

    public static DataBufferFactory getDataBufferFactory() {
        return DATA_BUFFER_FACTORY_INSTANCE;
    }

    public static FFTInstance getFFt() {
        return FFT_INSTANCE;
    }

    public static void setFft(FFTInstance fftInstance) {
        if (fftInstance == null) {
            throw new IllegalArgumentException("No null instances allowed");
        }
        FFT_INSTANCE = fftInstance;
    }

    public static void setParams(INDArray theta, Collection<INDArray> ... matrices) {
        int index = 0;
        for (Collection<INDArray> matrixCollection : matrices) {
            for (INDArray matrix : matrixCollection) {
                INDArray linear = matrix.linearView();
                for (int i = 0; i < matrix.length(); ++i) {
                    linear.putScalar(i, theta.getDouble(index));
                    ++index;
                }
            }
        }
        if (index != theta.length()) {
            throw new AssertionError((Object)"Did not entirely use the theta vector");
        }
    }

    public static INDArray rollAxis(INDArray a, int axis) {
        return Nd4j.rollAxis(a, axis, 0);
    }

    public static INDArray argMax(INDArray arr, int ... dimension) {
        return Nd4j.getExecutioner().exec(new IMax(arr), dimension);
    }

    public static INDArray rollAxis(INDArray a, int axis, int start) {
        if (axis < 0) {
            axis += a.rank();
        }
        if (start < 0) {
            start += a.rank();
        }
        if (axis == start) {
            return a;
        }
        if (axis < start) {
            --start;
        }
        if (axis < 0 || axis >= a.rank()) {
            throw new IllegalArgumentException("Axis must be >= 0 && < start");
        }
        if (start < 0 || axis >= a.rank() + 1) {
            throw new IllegalArgumentException("Axis must be >= 0 && < start");
        }
        ArrayList<Integer> range = new ArrayList<Integer>(Ints.asList((int[])ArrayUtil.range((int)0, (int)a.rank())));
        range.remove(axis);
        range.add(start, axis);
        int[] newRange = Ints.toArray(range);
        return a.permute(newRange);
    }

    public static INDArray tensorMmul(INDArray a, INDArray b, int[][] axes) {
        int[] oldShapeB;
        int[] oldShapeA;
        int validationLength = Math.min(axes[0].length, axes[1].length);
        for (int i = 0; i < validationLength; ++i) {
            if (a.size(axes[0][i]) != b.size(axes[1][i])) {
                throw new IllegalArgumentException("Size of the given axes at each dimension must be the same size.");
            }
            if (axes[0][i] < 0) {
                int[] nArray = axes[0];
                int n = i;
                nArray[n] = nArray[n] + a.rank();
            }
            if (axes[1][i] >= 0) continue;
            int[] nArray = axes[1];
            int n = i;
            nArray[n] = nArray[n] + b.rank();
        }
        ArrayList<Integer> listA = new ArrayList<Integer>();
        for (int i = 0; i < a.rank(); ++i) {
            if (Ints.contains((int[])axes[0], (int)i)) continue;
            listA.add(i);
        }
        int[] newAxesA = Ints.concat((int[][])new int[][]{Ints.toArray(listA), axes[0]});
        ArrayList<Integer> listB = new ArrayList<Integer>();
        for (int i = 0; i < b.rank(); ++i) {
            if (Ints.contains((int[])axes[1], (int)i)) continue;
            listB.add(i);
        }
        int[] newAxesB = Ints.concat((int[][])new int[][]{axes[1], Ints.toArray(listB)});
        int n2 = 1;
        int aLength = Math.min(a.rank(), axes[0].length);
        for (int i = 0; i < aLength; ++i) {
            n2 *= a.size(axes[0][i]);
        }
        int[] newShapeA = new int[]{-1, n2};
        if (listA.size() == 0) {
            oldShapeA = new int[]{1};
        } else {
            oldShapeA = Ints.toArray(listA);
            for (int i = 0; i < oldShapeA.length; ++i) {
                oldShapeA[i] = a.size(oldShapeA[i]);
            }
        }
        int n3 = 1;
        int bNax = Math.min(b.rank(), axes[1].length);
        for (int i = 0; i < bNax; ++i) {
            n3 *= b.size(axes[1][i]);
        }
        int[] newShapeB = new int[]{n3, -1};
        if (listB.size() == 0) {
            oldShapeB = new int[]{1};
        } else {
            oldShapeB = Ints.toArray(listB);
            for (int i = 0; i < oldShapeB.length; ++i) {
                oldShapeB[i] = b.size(oldShapeB[i]);
            }
        }
        INDArray at = a.permute(newAxesA).reshape(newShapeA);
        INDArray bt = b.permute(newAxesB).reshape(newShapeB);
        INDArray ret = at.mmul(bt);
        int[] aPlusB = Ints.concat((int[][])new int[][]{oldShapeA, oldShapeB});
        return ret.reshape(aPlusB);
    }

    public static INDArray gemm(INDArray a, INDArray b, boolean transposeA, boolean transposeB) {
        int cRows = transposeA ? a.columns() : a.rows();
        int cCols = transposeB ? b.rows() : b.columns();
        INDArray c = Nd4j.createUninitialized(new int[]{cRows, cCols}, 'f');
        return Nd4j.gemm(a, b, c, transposeA, transposeB, 1.0, 0.0);
    }

    public static INDArray gemm(INDArray a, INDArray b, INDArray c, boolean transposeA, boolean transposeB, double alpha, double beta) {
        Nd4j.getBlasWrapper().level3().gemm(a, b, c, transposeA, transposeB, alpha, beta);
        return c;
    }

    public static void setParams(INDArray theta, Iterator<? extends INDArray> ... matrices) {
        int index = 0;
        for (Iterator<? extends INDArray> matrixIterator : matrices) {
            while (matrixIterator.hasNext()) {
                INDArray matrix = matrixIterator.next().linearView();
                for (int i = 0; i < matrix.length(); ++i) {
                    matrix.putScalar(i, theta.getDouble(index));
                    ++index;
                }
            }
        }
        if (index != theta.length()) {
            throw new AssertionError((Object)"Did not entirely use the theta vector");
        }
    }

    private static void logCreationIfNecessary(DataBuffer log) {
        if (shouldInstrument) {
            Nd4j.getInstrumentation().log(log);
        }
    }

    private static void logCreationIfNecessary(INDArray log) {
        if (shouldInstrument) {
            Nd4j.getInstrumentation().log(log);
        }
    }

    public static NDArrayFactory factory() {
        return INSTANCE;
    }

    public static INDArray cumsum(INDArray compute) {
        return compute.cumsum(Integer.MAX_VALUE);
    }

    public static INDArray max(INDArray compute) {
        return compute.max(Integer.MAX_VALUE);
    }

    public static INDArray min(INDArray compute) {
        return compute.min(Integer.MAX_VALUE);
    }

    public static INDArray prod(INDArray compute) {
        return compute.prod(Integer.MAX_VALUE);
    }

    public static INDArray normmax(INDArray compute) {
        return compute.normmax(Integer.MAX_VALUE);
    }

    public static INDArray norm2(INDArray compute) {
        return compute.norm2(Integer.MAX_VALUE);
    }

    public static INDArray norm1(INDArray compute) {
        return compute.norm1(Integer.MAX_VALUE);
    }

    public static INDArray std(INDArray compute) {
        return compute.std(Integer.MAX_VALUE);
    }

    public static INDArray var(INDArray compute) {
        return compute.var(Integer.MAX_VALUE);
    }

    public static INDArray sum(INDArray compute) {
        return compute.sum(Integer.MAX_VALUE);
    }

    public static INDArray mean(INDArray compute) {
        return compute.mean(Integer.MAX_VALUE);
    }

    public static IComplexNDArray cumsum(IComplexNDArray compute) {
        return compute.cumsum(Integer.MAX_VALUE);
    }

    public static IComplexNDArray max(IComplexNDArray compute) {
        return compute.max(Integer.MAX_VALUE);
    }

    public static IComplexNDArray min(IComplexNDArray compute) {
        return compute.min(Integer.MAX_VALUE);
    }

    public static IComplexNDArray prod(IComplexNDArray compute) {
        return compute.prod(Integer.MAX_VALUE);
    }

    public static IComplexNDArray normmax(IComplexNDArray compute) {
        return compute.normmax(Integer.MAX_VALUE);
    }

    public static IComplexNDArray norm2(IComplexNDArray compute) {
        return compute.norm2(Integer.MAX_VALUE);
    }

    public static IComplexNDArray norm1(IComplexNDArray compute) {
        return compute.norm1(Integer.MAX_VALUE);
    }

    public static IComplexNDArray std(IComplexNDArray compute) {
        return compute.std(Integer.MAX_VALUE);
    }

    public static IComplexNDArray var(IComplexNDArray compute) {
        return compute.var(Integer.MAX_VALUE);
    }

    public static IComplexNDArray sum(IComplexNDArray compute) {
        return compute.sum(Integer.MAX_VALUE);
    }

    public static IComplexNDArray mean(IComplexNDArray compute) {
        return compute.mean(Integer.MAX_VALUE);
    }

    public static INDArray cumsum(INDArray compute, int dimension) {
        return compute.cumsum(dimension);
    }

    public static INDArray max(INDArray compute, int dimension) {
        return compute.max(dimension);
    }

    public static INDArray min(INDArray compute, int dimension) {
        return compute.min(dimension);
    }

    public static INDArray prod(INDArray compute, int dimension) {
        return compute.prod(dimension);
    }

    public static INDArray normmax(INDArray compute, int dimension) {
        return compute.normmax(dimension);
    }

    public static INDArray norm2(INDArray compute, int dimension) {
        return compute.norm2(dimension);
    }

    public static INDArray norm1(INDArray compute, int dimension) {
        return compute.norm1(dimension);
    }

    public static INDArray std(INDArray compute, int dimension) {
        return compute.std(dimension);
    }

    public static INDArray var(INDArray compute, int dimension) {
        return compute.var(dimension);
    }

    public static INDArray sum(INDArray compute, int dimension) {
        return compute.sum(dimension);
    }

    public static INDArray mean(INDArray compute, int dimension) {
        return compute.mean(dimension);
    }

    public static IComplexNDArray cumsum(IComplexNDArray compute, int dimension) {
        return compute.cumsum(dimension);
    }

    public static IComplexNDArray max(IComplexNDArray compute, int dimension) {
        return compute.max(dimension);
    }

    public static IComplexNDArray min(IComplexNDArray compute, int dimension) {
        return compute.min(dimension);
    }

    public static IComplexNDArray prod(IComplexNDArray compute, int dimension) {
        return compute.prod(dimension);
    }

    public static IComplexNDArray normmax(IComplexNDArray compute, int dimension) {
        return compute.normmax(dimension);
    }

    public static IComplexNDArray norm2(IComplexNDArray compute, int dimension) {
        return compute.norm2(dimension);
    }

    public static IComplexNDArray norm1(IComplexNDArray compute, int dimension) {
        return compute.norm1(dimension);
    }

    public static IComplexNDArray std(IComplexNDArray compute, int dimension) {
        return compute.std(dimension);
    }

    public static IComplexNDArray var(IComplexNDArray compute, int dimension) {
        return compute.var(dimension);
    }

    public static IComplexNDArray sum(IComplexNDArray compute, int dimension) {
        return compute.sum(dimension);
    }

    public static IComplexNDArray mean(IComplexNDArray compute, int dimension) {
        return compute.mean(dimension);
    }

    public static DataBuffer createBuffer(DataBuffer underlyingBuffer, long offset, long length) {
        return DATA_BUFFER_FACTORY_INSTANCE.create(underlyingBuffer, offset, length);
    }

    public static DataBuffer createBuffer(int[] shape, DataBuffer.Type type, int offset) {
        int length = ArrayUtil.prod((int[])shape);
        return type == DataBuffer.Type.DOUBLE ? Nd4j.createBuffer(new double[length], offset) : Nd4j.createBuffer(new float[length], offset);
    }

    public static DataBuffer createBuffer(ByteBuffer buffer, DataBuffer.Type type, int length, int offset) {
        switch (type) {
            case INT: {
                return DATA_BUFFER_FACTORY_INSTANCE.createInt(offset, buffer, length);
            }
            case DOUBLE: {
                return DATA_BUFFER_FACTORY_INSTANCE.createDouble(offset, buffer, length);
            }
            case FLOAT: {
                return DATA_BUFFER_FACTORY_INSTANCE.createFloat(offset, buffer, length);
            }
        }
        throw new IllegalArgumentException("Illegal type " + type);
    }

    public static DataBuffer createBuffer(byte[] data, int length, int offset) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.DOUBLE ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(offset, data, length) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(offset, data, length);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(int[] data, int offset) {
        DataBuffer ret = DATA_BUFFER_FACTORY_INSTANCE.createInt(offset, data);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(int length, int offset) {
        Object ret = Nd4j.dataType() == DataBuffer.Type.FLOAT ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(offset, length) : (Nd4j.dataType() == DataBuffer.Type.INT ? DATA_BUFFER_FACTORY_INSTANCE.createInt(offset, length) : (Nd4j.dataType() == DataBuffer.Type.DOUBLE ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(offset, length) : (Nd4j.dataType() == DataBuffer.Type.HALF ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(offset, length) : null)));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(float[] data, int offset) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.FLOAT ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(offset, data) : (Nd4j.dataType() == DataBuffer.Type.HALF ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(offset, data) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(offset, ArrayUtil.toDoubles((float[])data)));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(double[] data, int offset) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.DOUBLE ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(offset, data) : (Nd4j.dataType() == DataBuffer.Type.HALF ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(offset, data) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(offset, ArrayUtil.toFloats((double[])data)));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(int[] shape, DataBuffer.Type type) {
        int length = ArrayUtil.prod((int[])shape);
        if (type == DataBuffer.Type.INT) {
            return Nd4j.createBuffer(new int[length]);
        }
        if (type == DataBuffer.Type.HALF) {
            return Nd4j.createBuffer(new float[length]);
        }
        return type == DataBuffer.Type.DOUBLE ? Nd4j.createBuffer(new double[length]) : Nd4j.createBuffer(new float[length]);
    }

    public static DataBuffer createBuffer(ByteBuffer buffer, DataBuffer.Type type, int length) {
        switch (type) {
            case INT: {
                return DATA_BUFFER_FACTORY_INSTANCE.createInt(buffer, length);
            }
            case DOUBLE: {
                return DATA_BUFFER_FACTORY_INSTANCE.createDouble(buffer, length);
            }
            case FLOAT: {
                return DATA_BUFFER_FACTORY_INSTANCE.createFloat(buffer, length);
            }
            case HALF: {
                return DATA_BUFFER_FACTORY_INSTANCE.createHalf(buffer, length);
            }
        }
        throw new IllegalArgumentException("Illegal type " + type);
    }

    public static DataBuffer createBuffer(byte[] data, int length) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.DOUBLE ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(data, length) : (Nd4j.dataType() == DataBuffer.Type.HALF ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(data, length) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(data, length));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(int[] data) {
        DataBuffer ret = DATA_BUFFER_FACTORY_INSTANCE.createInt(data);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(long length) {
        return Nd4j.createBuffer(length, true);
    }

    public static DataBuffer createBuffer(Pointer pointer, DataBuffer.Type type, long length, Indexer indexer) {
        return DATA_BUFFER_FACTORY_INSTANCE.create(pointer, type, length, indexer);
    }

    public static DataBuffer createBuffer(long length, boolean initialize) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.FLOAT ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(length, initialize) : (Nd4j.dataType() == DataBuffer.Type.INT ? DATA_BUFFER_FACTORY_INSTANCE.createInt(length, initialize) : (Nd4j.dataType() == DataBuffer.Type.HALF ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(length, initialize) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(length, initialize)));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(float[] data) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.FLOAT ? DATA_BUFFER_FACTORY_INSTANCE.createFloat(data) : (Nd4j.dataType() == DataBuffer.Type.HALF ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(data) : DATA_BUFFER_FACTORY_INSTANCE.createDouble(ArrayUtil.toDoubles((float[])data)));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static DataBuffer createBuffer(double[] data) {
        DataBuffer ret = Nd4j.dataType() == DataBuffer.Type.DOUBLE ? DATA_BUFFER_FACTORY_INSTANCE.createDouble(data) : (Nd4j.dataType() == DataBuffer.Type.HALF ? DATA_BUFFER_FACTORY_INSTANCE.createHalf(ArrayUtil.toFloats((double[])data)) : DATA_BUFFER_FACTORY_INSTANCE.createFloat(ArrayUtil.toFloats((double[])data)));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static void setFactory(NDArrayFactory factory) {
        INSTANCE = factory;
    }

    public static Character order() {
        return Character.valueOf(Nd4j.factory().order());
    }

    public static DataBuffer.Type dataType() {
        return DataTypeUtil.getDtypeFromContext();
    }

    public static void setDataType(@NonNull DataBuffer.Type dType) {
        if (dType == null) {
            throw new NullPointerException("dType");
        }
        DataTypeUtil.setDTypeForContext((DataBuffer.Type)dType);
    }

    public static Nd4jBackend getBackend() {
        return backend;
    }

    public static BlasWrapper getBlasWrapper() {
        return BLAS_WRAPPER_INSTANCE;
    }

    public static void setBlasWrapper(BlasWrapper factory) {
        BLAS_WRAPPER_INSTANCE = factory;
    }

    public static IComplexNDArray repeat(IComplexNDArray n, int num) {
        ArrayList<IComplexNDArray> list = new ArrayList<IComplexNDArray>();
        for (int i = 0; i < num; ++i) {
            list.add(n.dup());
        }
        IComplexNDArray ret = Nd4j.createComplex(list, Ints.concat((int[][])new int[][]{{num}, n.shape()}));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray[] sortWithIndices(IComplexNDArray ndarray, int dimension, boolean ascending) {
        INDArray indices = Nd4j.create(ndarray.shape());
        INDArray[] ret = new INDArray[2];
        for (int i = 0; i < ndarray.vectorsAlongDimension(dimension); ++i) {
            int j;
            IComplexNDArray vec = ndarray.vectorAlongDimension(i, dimension);
            INDArray indexVector = indices.vectorAlongDimension(i, dimension);
            final IComplexNumber[] data = new IComplexNumber[vec.length()];
            Double[] index = new Double[vec.length()];
            for (j = 0; j < vec.length(); ++j) {
                data[j] = vec.getComplex(j);
                index[j] = j;
            }
            if (ascending) {
                Arrays.sort(index, new Comparator<Double>(){

                    @Override
                    public int compare(Double o1, Double o2) {
                        int idx1 = (int)o1.doubleValue();
                        int idx2 = (int)o2.doubleValue();
                        return Double.compare(data[idx1].absoluteValue().doubleValue(), data[idx2].absoluteValue().doubleValue());
                    }
                });
            } else {
                Arrays.sort(index, new Comparator<Double>(){

                    @Override
                    public int compare(Double o1, Double o2) {
                        int idx1 = (int)o1.doubleValue();
                        int idx2 = (int)o2.doubleValue();
                        return -Double.compare(data[idx1].absoluteValue().doubleValue(), data[idx2].absoluteValue().doubleValue());
                    }
                });
            }
            for (j = 0; j < vec.length(); ++j) {
                vec.putScalar(j, data[(int)index[j].doubleValue()]);
                indexVector.putScalar(j, (double)index[j]);
            }
        }
        ret[0] = indices;
        ret[1] = ndarray;
        return ret;
    }

    public static INDArray[] sortWithIndices(INDArray ndarray, int dimension, boolean ascending) {
        INDArray indices = Nd4j.create(ndarray.shape());
        INDArray[] ret = new INDArray[2];
        for (int i = 0; i < ndarray.vectorsAlongDimension(dimension); ++i) {
            int j;
            INDArray vec = ndarray.vectorAlongDimension(i, dimension);
            INDArray indexVector = indices.vectorAlongDimension(i, dimension);
            final Double[] data = new Double[vec.length()];
            Double[] index = new Double[vec.length()];
            for (j = 0; j < vec.length(); ++j) {
                data[j] = vec.getDouble(j);
                index[j] = j;
            }
            Arrays.sort(index, new Comparator<Double>(){

                @Override
                public int compare(Double o1, Double o2) {
                    int o = (int)o1.doubleValue();
                    int oo2 = (int)o2.doubleValue();
                    return Double.compare(data[o], data[oo2]);
                }
            });
            if (ascending) {
                for (j = 0; j < vec.length(); ++j) {
                    vec.putScalar(j, (double)data[(int)index[j].doubleValue()]);
                    indexVector.putScalar(j, (double)index[j]);
                }
                continue;
            }
            int count = data.length - 1;
            for (int j2 = 0; j2 < vec.length(); ++j2) {
                int currCount2 = count--;
                vec.putScalar(j2, (double)data[(int)index[currCount2].doubleValue()]);
                indexVector.putScalar(j2, (double)index[currCount2]);
            }
        }
        ret[0] = indices;
        ret[1] = ndarray;
        return ret;
    }

    public static IComplexNDArray sort(IComplexNDArray ndarray, int dimension, boolean ascending) {
        for (int i = 0; i < ndarray.vectorsAlongDimension(dimension); ++i) {
            int j;
            IComplexNDArray vec = ndarray.vectorAlongDimension(i, dimension);
            IComplexNumber[] data = new IComplexNumber[vec.length()];
            for (j = 0; j < vec.length(); ++j) {
                data[j] = vec.getComplex(j);
            }
            if (ascending) {
                Arrays.sort(data, new Comparator<IComplexNumber>(){

                    @Override
                    public int compare(IComplexNumber o1, IComplexNumber o2) {
                        return Double.compare(o1.asDouble().absoluteValue().doubleValue(), o2.asDouble().absoluteValue().doubleValue());
                    }
                });
            } else {
                Arrays.sort(data, new Comparator<IComplexNumber>(){

                    @Override
                    public int compare(IComplexNumber o1, IComplexNumber o2) {
                        return -Double.compare(o1.asDouble().absoluteValue().doubleValue(), o2.asDouble().absoluteValue().doubleValue());
                    }
                });
            }
            for (j = 0; j < vec.length(); ++j) {
                vec.putScalar(j, data[j]);
            }
        }
        return ndarray;
    }

    public static INDArray sort(INDArray ndarray, int dimension, boolean ascending) {
        for (int i = 0; i < ndarray.vectorsAlongDimension(dimension); ++i) {
            int j;
            INDArray vec = ndarray.vectorAlongDimension(i, dimension);
            double[] data = new double[vec.length()];
            for (j = 0; j < vec.length(); ++j) {
                data[j] = vec.getDouble(j);
            }
            Arrays.sort(data);
            if (ascending) {
                for (j = 0; j < vec.length(); ++j) {
                    vec.putScalar(j, data[j]);
                }
                continue;
            }
            int count = data.length - 1;
            for (int j2 = 0; j2 < vec.length(); ++j2) {
                vec.putScalar(j2, data[count--]);
            }
        }
        return ndarray;
    }

    public static INDArray sortRows(final INDArray in, final int colIdx, final boolean ascending) {
        int i;
        if (in.rank() != 2) {
            throw new IllegalArgumentException("Cannot sort rows on non-2d matrix");
        }
        if (colIdx < 0 || colIdx >= in.columns()) {
            throw new IllegalArgumentException("Cannot sort on values in column " + colIdx + ", nCols=" + in.columns());
        }
        INDArray out = Nd4j.create(in.shape());
        int nRows = in.rows();
        ArrayList<Integer> list = new ArrayList<Integer>(nRows);
        for (i = 0; i < nRows; ++i) {
            list.add(i);
        }
        Collections.sort(list, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (ascending) {
                    return Double.compare(in.getDouble((int)o1, colIdx), in.getDouble((int)o2, colIdx));
                }
                return -Double.compare(in.getDouble((int)o1, colIdx), in.getDouble((int)o2, colIdx));
            }
        });
        for (i = 0; i < nRows; ++i) {
            out.putRow(i, in.getRow((Integer)list.get(i)));
        }
        return out;
    }

    public static INDArray sortColumns(final INDArray in, final int rowIdx, final boolean ascending) {
        int i;
        if (in.rank() != 2) {
            throw new IllegalArgumentException("Cannot sort columns on non-2d matrix");
        }
        if (rowIdx < 0 || rowIdx >= in.rows()) {
            throw new IllegalArgumentException("Cannot sort on values in row " + rowIdx + ", nRows=" + in.rows());
        }
        INDArray out = Nd4j.create(in.shape());
        int nCols = in.columns();
        ArrayList<Integer> list = new ArrayList<Integer>(nCols);
        for (i = 0; i < nCols; ++i) {
            list.add(i);
        }
        Collections.sort(list, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                if (ascending) {
                    return Double.compare(in.getDouble(rowIdx, (int)o1), in.getDouble(rowIdx, (int)o2));
                }
                return -Double.compare(in.getDouble(rowIdx, (int)o1), in.getDouble(rowIdx, (int)o2));
            }
        });
        for (i = 0; i < nCols; ++i) {
            out.putColumn(i, in.getColumn((Integer)list.get(i)));
        }
        return out;
    }

    public static INDArray repeat(INDArray n, int num) {
        int[] nArray;
        ArrayList<INDArray> list = new ArrayList<INDArray>();
        for (int i = 0; i < num; ++i) {
            list.add(n.dup());
        }
        int[] nShape = n.shape();
        if (n.isColumnVector()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = n.shape()[0];
        } else {
            nArray = nShape;
        }
        int[] shape = nArray;
        int[] retShape = Ints.concat((int[][])new int[][]{{num}, shape});
        return Nd4j.create(list, retShape);
    }

    public static INDArray linspace(int lower, int upper, int num) {
        double approx = (double)num / ((double)(upper - lower) + 1.0);
        if (approx % 1.0 <= EPS_THRESHOLD) {
            return INSTANCE.linspace(lower, upper, num);
        }
        return Nd4j.linspace((double)lower, (double)upper, num);
    }

    public static INDArray linspace(double lower, double upper, int num) {
        return Nd4j.getExecutioner().exec(new Linspace(lower, upper, num));
    }

    public static INDArray linspace(float lower, float upper, int num) {
        return Nd4j.linspace((double)lower, (double)upper, num);
    }

    public static INDArray toFlattened(Collection<INDArray> matrices) {
        INDArray ret = INSTANCE.toFlattened(matrices);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray toFlattened(char order, Collection<INDArray> matrices) {
        INDArray ret = INSTANCE.toFlattened(order, matrices);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray complexFlatten(List<IComplexNDArray> flatten) {
        IComplexNDArray ret = INSTANCE.complexFlatten(flatten);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray complexFlatten(IComplexNDArray ... flatten) {
        IComplexNDArray ret = INSTANCE.complexFlatten(flatten);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray toFlattened(int length, Iterator<? extends INDArray> ... matrices) {
        INDArray ret = INSTANCE.toFlattened(length, matrices);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray bilinearProducts(INDArray curr, INDArray in) {
        return INSTANCE.bilinearProducts(curr, in);
    }

    public static INDArray toFlattened(INDArray ... matrices) {
        return INSTANCE.toFlattened(matrices);
    }

    public static INDArray toFlattened(char order, INDArray ... matrices) {
        return INSTANCE.toFlattened(order, matrices);
    }

    public static INDArray eye(int n) {
        INDArray ret = INSTANCE.eye(n);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static void rot90(INDArray toRotate) {
        INSTANCE.rot90(toRotate);
    }

    public static void writeTxt(INDArray write, String filePath, String split, int precision) {
        String lineOne = "{\n";
        String lineTwo = "\"filefrom:\" \"dl4j\",\n";
        String lineThree = "\"ordering:\" \"" + write.ordering() + "\",\n";
        String lineFour = "\"shape\":\t" + Arrays.toString(write.shape()) + ",\n";
        String lineFive = "\"data\":\n";
        String fileData = new NDArrayStrings(" " + split + " ", precision).format(write);
        String fileEnd = "\n}\n";
        String fileBegin = lineOne + lineTwo + lineThree + lineFour + lineFive;
        try {
            FileUtils.writeStringToFile((File)new File(filePath), (String)(fileBegin + fileData + fileEnd));
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing output", e);
        }
    }

    public static void writeTxt(INDArray write, String filePath, int precision) {
        Nd4j.writeTxt(write, filePath, ", ", precision);
    }

    public static void writeTxt(INDArray write, String filePath, String split) {
        Nd4j.writeTxt(write, filePath, " " + split + "", 2);
    }

    public static void writeTxt(INDArray write, String filePath) {
        Nd4j.writeTxt(write, filePath, ", ", 2);
    }

    public static void writeTxtString(INDArray write, OutputStream os, String split, int precision) {
        String lineOne = "{\n";
        String lineTwo = "\"filefrom\":\"dl4j\",\n";
        String lineThree = "\"ordering\":\"" + write.ordering() + "\",\n";
        String lineFour = "\"shape\":" + Arrays.toString(write.shape()) + ",\n";
        String lineFive = "\"data\":\n";
        String fileData = new NDArrayStrings(" " + split + " ", precision).format(write);
        String fileEnd = "\n}\n";
        String fileBegin = lineOne + lineTwo + lineThree + lineFour + lineFive;
        try {
            String toWrite = fileBegin + fileData + fileEnd;
            os.write(toWrite.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing output", e);
        }
    }

    public static void writeTxtString(INDArray write, OutputStream os, int precision) {
        Nd4j.writeTxtString(write, os, ", ", precision);
    }

    public static void writeTxtString(INDArray write, OutputStream os, String split) {
        Nd4j.writeTxtString(write, os, " " + split + "", 2);
    }

    public static void writeTxtString(INDArray write, OutputStream os) {
        Nd4j.writeTxtString(write, os, ", ", 2);
    }

    public static void write(OutputStream writer, INDArray write) throws IOException {
        DataOutputStream stream = new DataOutputStream(writer);
        Nd4j.write(write, stream);
        stream.close();
    }

    public static byte[] toByteArray(INDArray arr) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(arr.length() * arr.data().getElementSize());
        DataOutputStream dos = new DataOutputStream(bos);
        Nd4j.write(arr, dos);
        byte[] ret = bos.toByteArray();
        return ret;
    }

    public static INDArray fromByteArray(byte[] arr) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(arr);
        INDArray ret = Nd4j.read(bis);
        return ret;
    }

    public static INDArray readNumpy(InputStream filePath, String split) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(filePath));
        ArrayList<float[]> data2 = new ArrayList<float[]>();
        int numColumns = -1;
        while ((line = reader.readLine()) != null) {
            String[] data = line.trim().split(split);
            if (numColumns < 0) {
                numColumns = data.length;
            } else assert (data.length == numColumns) : "Data has inconsistent number of columns";
            data2.add(Nd4j.readSplit(data));
        }
        INDArray ret = Nd4j.create(data2.size(), numColumns);
        for (int i = 0; i < data2.size(); ++i) {
            ret.putRow(i, Nd4j.create(Nd4j.createBuffer((float[])data2.get(i))));
        }
        return ret;
    }

    private static float[] readSplit(String[] split) {
        float[] ret = new float[split.length];
        for (int i = 0; i < split.length; ++i) {
            ret[i] = Float.parseFloat(split[i]);
        }
        return ret;
    }

    public static void writeNumpy(INDArray write, String filePath, String split) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));
        for (int i = 0; i < write.rows(); ++i) {
            StringBuilder sb = new StringBuilder();
            INDArray row = write.getRow(i);
            for (int j = 0; j < row.columns(); ++j) {
                sb.append(row.getDouble(j));
                sb.append(split);
            }
            sb.append("\n");
            writer.write(sb.toString());
        }
        writer.flush();
        writer.close();
    }

    public static INDArray readNumpy(String filePath, String split) throws IOException {
        return Nd4j.readNumpy(new FileInputStream(filePath), split);
    }

    public static INDArray readNumpy(String filePath) throws IOException {
        return Nd4j.readNumpy(filePath, "\t");
    }

    public static INDArray read(InputStream reader) throws IOException {
        return Nd4j.read(new DataInputStream(reader));
    }

    public static IComplexNumber parseComplexNumber(String val) {
        String[] split = val.split(" ");
        double real = Double.valueOf(split[0]);
        char op = split[1].charAt(0);
        double imag = Double.valueOf(split[2].substring(0, split[2].length() - 1));
        return Nd4j.createComplexNumber(real, op == '-' ? -imag : imag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static INDArray readTxtString(InputStream ndarray, String sep) {
        int lineNum = 0;
        int rowNum = 0;
        int tensorNum = 0;
        char theOrder = 'c';
        int[] theShape = new int[]{1, 1};
        int rank = 0;
        Object subsetArr = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
        INDArray newArr = Nd4j.zeros(2, 2);
        BufferedReader reader = new BufferedReader(new InputStreamReader(ndarray));
        LineIterator it = IOUtils.lineIterator((Reader)reader);
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        format.setParseBigDecimal(true);
        try {
            while (it.hasNext()) {
                String[] lineArr;
                String fileSource;
                String line = it.nextLine();
                ++lineNum;
                if ((line = line.replaceAll("\\s", "")).equals("") || line.equals("}")) continue;
                if (lineNum == 2 && !(fileSource = (lineArr = line.split(":"))[1].replaceAll("\\W", "")).equals("dl4j")) {
                    INDArray iNDArray = null;
                    return iNDArray;
                }
                if (lineNum == 3) {
                    lineArr = line.split(":");
                    theOrder = lineArr[1].replaceAll("\\W", "").charAt(0);
                    continue;
                }
                if (lineNum == 4) {
                    lineArr = line.split(":");
                    String dropJsonComma = lineArr[1].split("]")[0];
                    String[] shapeString = dropJsonComma.replace("[", "").split(",");
                    rank = shapeString.length;
                    theShape = new int[rank];
                    for (int i = 0; i < rank; ++i) {
                        try {
                            theShape[i] = Integer.parseInt(shapeString[i]);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    subsetArr = new double[theShape[rank - 2]][theShape[rank - 1]];
                    newArr = Nd4j.zeros(theShape, theOrder);
                    continue;
                }
                if (lineNum <= 5) continue;
                String[] entries = line.replace("\\],", "").replaceAll("\\[", "").replaceAll("\\],", "").replaceAll("\\]", "").split(sep);
                for (int i = 0; i < theShape[rank - 1]; ++i) {
                    try {
                        BigDecimal number = (BigDecimal)format.parse(entries[i]);
                        subsetArr[rowNum][i] = number.doubleValue();
                        continue;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if (++rowNum != theShape[rank - 2]) continue;
                INDArray subTensor = Nd4j.create(subsetArr);
                newArr.tensorAlongDimension(tensorNum, rank - 1, rank - 2).addi(subTensor);
                rowNum = 0;
                ++tensorNum;
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)it);
        }
        return newArr;
    }

    public static INDArray readTxtString(InputStream ndarray) {
        return Nd4j.readTxtString(ndarray, ",");
    }

    public static INDArray readTxt(String filePath, String sep) {
        File file = new File(filePath);
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            INDArray iNDArray = Nd4j.readTxtString(is, sep);
            return iNDArray;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static INDArray readTxt(String filePath) {
        return Nd4j.readTxt(filePath, ",");
    }

    private static int[] toIntArray(int length, DataBuffer buffer) {
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = buffer.getInt((long)i);
        }
        return ret;
    }

    public static INDArray createArrayFromShapeBuffer(DataBuffer data, DataBuffer shapeInfo) {
        int rank = Shape.rank(shapeInfo);
        int offset = Shape.offset(shapeInfo);
        INDArray result = Nd4j.create(data, Nd4j.toIntArray(rank, Shape.shapeOf(shapeInfo)), Nd4j.toIntArray(rank, Shape.stride(shapeInfo)), offset, Shape.order(shapeInfo));
        if (data instanceof CompressedDataBuffer) {
            result.markAsCompressed(true);
        }
        return result;
    }

    public static INDArray read(DataInputStream dis) throws IOException {
        DataBuffer shapeInformation = Nd4j.createBuffer(new int[1], DataBuffer.Type.INT);
        shapeInformation.read(dis);
        int length = Shape.length(shapeInformation);
        DataBuffer data = CompressedDataBuffer.readUnknown(dis, length);
        return Nd4j.createArrayFromShapeBuffer(data, shapeInformation);
    }

    public static void write(INDArray arr, DataOutputStream dataOutputStream) throws IOException {
        if (arr.isView()) {
            arr = arr.dup();
        }
        arr.shapeInfoDataBuffer().write(dataOutputStream);
        arr.data().write(dataOutputStream);
    }

    public static void saveBinary(INDArray arr, File saveTo) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(saveTo));
        DataOutputStream dos = new DataOutputStream(bos);
        Nd4j.write(arr, dos);
        dos.flush();
        dos.close();
        bos.close();
    }

    public static INDArray readBinary(File read) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(read));
        DataInputStream dis = new DataInputStream(bis);
        INDArray ret = Nd4j.read(dis);
        dis.close();
        return ret;
    }

    public static void clearNans(INDArray arr) {
        Nd4j.getExecutioner().exec(new ReplaceNans(arr, EPS_THRESHOLD));
    }

    public static IComplexNDArray readComplex(DataInputStream dis) throws IOException {
        int i;
        int dimensions = dis.readInt();
        int[] shape = new int[dimensions];
        int[] stride = new int[dimensions];
        for (i = 0; i < dimensions; ++i) {
            shape[i] = dis.readInt();
        }
        for (i = 0; i < dimensions; ++i) {
            stride[i] = dis.readInt();
        }
        String dataType = dis.readUTF();
        String type = dis.readUTF();
        if (!type.equals("complex")) {
            throw new IllegalArgumentException("Trying to read in a real ndarray");
        }
        if (dataType.equals("double")) {
            double[] data = ArrayUtil.readDouble((int)ArrayUtil.prod((int[])shape), (DataInputStream)dis);
            return Nd4j.createComplex(data, shape, stride, 0);
        }
        double[] data = ArrayUtil.read((int)ArrayUtil.prod((int[])shape), (DataInputStream)dis);
        return Nd4j.createComplex(data, shape, stride, 0);
    }

    public static void writeComplex(IComplexNDArray arr, DataOutputStream dataOutputStream) throws IOException {
        int i;
        dataOutputStream.writeInt(arr.shape().length);
        for (i = 0; i < arr.shape().length; ++i) {
            dataOutputStream.writeInt(arr.size(i));
        }
        for (i = 0; i < arr.stride().length; ++i) {
            dataOutputStream.writeInt(arr.stride()[i]);
        }
        dataOutputStream.writeUTF(Nd4j.dataType() == DataBuffer.Type.FLOAT ? "float" : "double");
        dataOutputStream.writeUTF("complex");
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            ArrayUtil.write((double[])arr.data().asDouble(), (DataOutputStream)dataOutputStream);
        } else {
            ArrayUtil.write((float[])arr.data().asFloat(), (DataOutputStream)dataOutputStream);
        }
    }

    public static INDArray rot(INDArray reverse) {
        INDArray ret = INSTANCE.rot(reverse);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray reverse(INDArray reverse) {
        INDArray ret = INSTANCE.reverse(reverse);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray arange(double begin, double end) {
        INDArray ret = INSTANCE.arange(begin, end);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray arange(double end) {
        return Nd4j.arange(0.0, end);
    }

    public static IComplexFloat createFloat(float real, float imag) {
        return INSTANCE.createFloat(real, imag);
    }

    public static IComplexDouble createDouble(double real, double imag) {
        return INSTANCE.createDouble(real, imag);
    }

    public static void copy(INDArray a, INDArray b) {
        INSTANCE.copy(a, b);
    }

    public static IComplexNDArray diag(IComplexNDArray x, int k) {
        if (x.isScalar()) {
            return x.dup();
        }
        if (x.isVector()) {
            IComplexNDArray m = Nd4j.createComplex(x.length(), x.length());
            IComplexNDArray xLinear = x.linearView();
            for (int i = 0; i < x.length(); ++i) {
                m.putScalar(i, i, xLinear.getComplex(i));
            }
            return m;
        }
        if (x.isMatrix()) {
            int vectorLength = x.rows() - k;
            IComplexNDArray ret = Nd4j.createComplex(new int[]{vectorLength, 1});
            for (int i = 0; i < vectorLength; ++i) {
                ret.putScalar(i, x.getComplex(i, i));
            }
            return ret;
        }
        throw new IllegalArgumentException("Illegal input for diagonal of shape " + x.shape().length);
    }

    public static INDArray diag(INDArray x, int k) {
        if (x.isScalar()) {
            return x.dup();
        }
        if (x.isVector()) {
            INDArray m = Nd4j.create(x.length(), x.length());
            INDArray xLinear = x.linearView();
            for (int i = 0; i < x.length(); ++i) {
                m.put(i, i, xLinear.getDouble(i));
            }
            return m;
        }
        if (x.isMatrix()) {
            int vectorLength = x.rows() - k;
            INDArray ret = Nd4j.create(new int[]{vectorLength, 1});
            for (int i = 0; i < vectorLength; ++i) {
                ret.putScalar(i, x.getDouble(i, i));
            }
            return ret;
        }
        throw new IllegalArgumentException("Illegal input for diagonal of shape " + x.shape().length);
    }

    public static IComplexNDArray diag(IComplexNDArray x) {
        return Nd4j.diag(x, 0);
    }

    public static INDArray diag(INDArray x) {
        return Nd4j.diag(x, 0);
    }

    public static INDArray choice(@NonNull INDArray source, @NonNull INDArray probs, @NonNull INDArray target, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (probs == null) {
            throw new NullPointerException("probs");
        }
        if (target == null) {
            throw new NullPointerException("target");
        }
        if (rng == null) {
            throw new NullPointerException("rng");
        }
        if (source.length() != probs.length()) {
            throw new ND4JIllegalStateException("Nd4j.choice() requires lengths of Source and Probs to be equal");
        }
        return Nd4j.getExecutioner().exec(new Choice(source, probs, target), rng);
    }

    public static INDArray choice(INDArray source, INDArray probs, INDArray target) {
        return Nd4j.choice(source, probs, target, Nd4j.getRandom());
    }

    public static INDArray choice(INDArray source, INDArray probs, int numSamples, @NonNull org.nd4j.linalg.api.rng.Random rng) {
        if (rng == null) {
            throw new NullPointerException("rng");
        }
        if (numSamples < 1) {
            throw new ND4JIllegalStateException("Nd4j.choice() numSamples must be positive value");
        }
        return Nd4j.choice(source, probs, Nd4j.createUninitialized(numSamples), rng);
    }

    public static INDArray choice(INDArray source, INDArray probs, int numSamples) {
        return Nd4j.choice(source, probs, numSamples, Nd4j.getRandom());
    }

    public static INDArray appendBias(INDArray ... vectors) {
        INDArray ret = INSTANCE.appendBias(vectors);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static void doAlongDiagonal(INDArray x, Function<Number, Number> func) {
        if (x.isMatrix()) {
            for (int i = 0; i < x.rows(); ++i) {
                x.put(i, i, (Number)func.apply((Object)x.getDouble(i, i)));
            }
        }
    }

    public static void doAlongDiagonal(IComplexNDArray x, Function<IComplexNumber, IComplexNumber> func) {
        if (x.isMatrix()) {
            for (int i = 0; i < x.rows(); ++i) {
                x.putScalar(i, i, (IComplexNumber)func.apply((Object)x.getComplex(i, i)));
            }
        }
    }

    public static INDArray rand(int[] shape) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.getExecutioner().exec(new UniformDistribution(ret), Nd4j.getRandom());
    }

    public static INDArray rand(char order, int[] shape) {
        INDArray ret = Nd4j.createUninitialized(shape, order);
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.getExecutioner().exec(new UniformDistribution(ret), Nd4j.getRandom());
    }

    public static IComplexNDArray complexRand(int ... shape) {
        INDArray based = Nd4j.rand(new int[]{1, ArrayUtil.prod((int[])shape) * 2});
        IComplexNDArray ret = Nd4j.createComplex(based.data(), shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray rand(int rows, int columns) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        INDArray ret = Nd4j.createUninitialized(new int[]{rows, columns}, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.getExecutioner().exec(new UniformDistribution(ret), Nd4j.getRandom());
    }

    public static INDArray rand(char order, int rows, int columns) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        INDArray ret = Nd4j.createUninitialized(new int[]{rows, columns}, order);
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.getExecutioner().exec(new UniformDistribution(ret), Nd4j.getRandom());
    }

    public static INDArray rand(int[] shape, long seed) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        Nd4j.getRandom().setSeed(seed);
        return Nd4j.getExecutioner().exec(new UniformDistribution(ret), Nd4j.getRandom());
    }

    public static INDArray rand(long seed, int ... shape) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        Nd4j.getRandom().setSeed(seed);
        return Nd4j.getExecutioner().exec(new UniformDistribution(ret), Nd4j.getRandom());
    }

    public static INDArray rand(int rows, int columns, long seed) {
        INDArray ret = Nd4j.createUninitialized(new int[]{rows, columns}, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        Nd4j.getRandom().setSeed(seed);
        return Nd4j.getExecutioner().exec(new UniformDistribution(ret), Nd4j.getRandom());
    }

    public static INDArray rand(int[] shape, org.nd4j.linalg.api.rng.Random rng) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.getExecutioner().exec(new UniformDistribution(ret), rng);
    }

    public static INDArray rand(int[] shape, Distribution dist) {
        return dist.sample(shape);
    }

    public static INDArray rand(int rows, int columns, org.nd4j.linalg.api.rng.Random rng) {
        INDArray ret = Nd4j.createUninitialized(new int[]{rows, columns}, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.getExecutioner().exec(new UniformDistribution(ret), rng);
    }

    public static INDArray rand(int[] shape, double min, double max, org.nd4j.linalg.api.rng.Random rng) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.getExecutioner().exec(new UniformDistribution(ret, min, max), rng);
    }

    public static INDArray rand(int rows, int columns, double min, double max, org.nd4j.linalg.api.rng.Random rng) {
        if (min > max) {
            throw new IllegalArgumentException("the maximum value supplied is smaller than the minimum");
        }
        INDArray ret = Nd4j.createUninitialized(rows, columns);
        Nd4j.logCreationIfNecessary(ret);
        return Nd4j.getExecutioner().exec(new UniformDistribution(ret, min, max), rng);
    }

    public static INDArray createUninitialized(int rows, int columns) {
        return Nd4j.createUninitialized(new int[]{rows, columns});
    }

    public static INDArray randn(int[] shape) {
        INDArray ret = Nd4j.getExecutioner().exec(new GaussianDistribution(Nd4j.createUninitialized(shape, Nd4j.order().charValue())), Nd4j.getRandom());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray randn(char order, int[] shape) {
        INDArray ret = Nd4j.getExecutioner().exec(new GaussianDistribution(Nd4j.createUninitialized(shape, order)), Nd4j.getRandom());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray randn(int[] shape, long seed) {
        Nd4j.getRandom().setSeed(seed);
        Nd4j.getExecutioner().exec(new GaussianDistribution(Nd4j.createUninitialized(shape, Nd4j.order().charValue())), Nd4j.getRandom());
        return Nd4j.randn(shape, Nd4j.getRandom());
    }

    public static INDArray randn(int rows, int columns) {
        INDArray ret = Nd4j.getExecutioner().exec(new GaussianDistribution(Nd4j.createUninitialized(new int[]{rows, columns}, Nd4j.order().charValue())), Nd4j.getRandom());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray randn(char order, int rows, int columns) {
        INDArray ret = Nd4j.getExecutioner().exec(new GaussianDistribution(Nd4j.createUninitialized(new int[]{rows, columns}, order)), Nd4j.getRandom());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray randn(int rows, int columns, long seed) {
        Nd4j.getRandom().setSeed(seed);
        INDArray ret = Nd4j.getExecutioner().exec(new GaussianDistribution(Nd4j.createUninitialized(new int[]{rows, columns}, Nd4j.order().charValue())), Nd4j.getRandom());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray randn(int rows, int columns, org.nd4j.linalg.api.rng.Random r) {
        INDArray ret = Nd4j.getExecutioner().exec(new GaussianDistribution(Nd4j.createUninitialized(new int[]{rows, columns}, Nd4j.order().charValue())), r);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray randn(int[] shape, org.nd4j.linalg.api.rng.Random r) {
        INDArray ret = Nd4j.getExecutioner().exec(new GaussianDistribution(Nd4j.createUninitialized(shape, Nd4j.order().charValue())), r);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data) {
        return Nd4j.create(data, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(float[] data) {
        return Nd4j.createComplex(data, Nd4j.order().charValue());
    }

    public static INDArray create(double[] data) {
        return Nd4j.create(data, Nd4j.order().charValue());
    }

    public static INDArray create(float[][] data) {
        return INSTANCE.create(data);
    }

    public static INDArray create(float[][] data, char ordering) {
        return INSTANCE.create(data, ordering);
    }

    public static INDArray create(double[][] data) {
        return INSTANCE.create(data);
    }

    public static INDArray create(double[][] data, char ordering) {
        return INSTANCE.create(data, ordering);
    }

    public static IComplexNDArray createComplex(INDArray arr) {
        if (arr instanceof IComplexNDArray) {
            return (IComplexNDArray)arr;
        }
        IComplexNDArray ret = INSTANCE.createComplex(arr);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int columns) {
        return Nd4j.create(columns, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int columns) {
        return Nd4j.createComplex(columns, Nd4j.order().charValue());
    }

    public static IComplexNumber createComplexNumber(Number real, Number imag) {
        if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            return INSTANCE.createFloat(real.floatValue(), imag.floatValue());
        }
        return INSTANCE.createDouble(real.doubleValue(), imag.doubleValue());
    }

    public static IComplexNDArray createComplex(INDArray real, INDArray imag) {
        assert (Shape.shapeEquals(real.shape(), imag.shape()));
        IComplexNDArray ret = Nd4j.createComplex(real.shape());
        INDArray realLinear = real.linearView();
        INDArray imagLinear = imag.linearView();
        IComplexNDArray retLinear = ret.linearView();
        for (int i = 0; i < ret.length(); ++i) {
            retLinear.putScalar(i, Nd4j.createComplexNumber(realLinear.getDouble(i), imagLinear.getDouble(i)));
        }
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(IComplexNumber[] data, int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        IComplexNDArray ret = INSTANCE.createComplex(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(List<IComplexNDArray> arrs, int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        IComplexNDArray ret = INSTANCE.createComplex(arrs, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, char order) {
        INDArray ret = INSTANCE.create(data, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    private static IComplexNDArray createComplex(float[] data, char order) {
        IComplexNDArray ret = INSTANCE.createComplex(data, Character.valueOf(order));
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, char order) {
        INDArray ret = INSTANCE.create(data, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, char order) {
        IComplexNDArray ret = INSTANCE.createComplex(data, Nd4j.getComplexStrides(new int[]{1, data.length}, order), 0, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int columns, char order) {
        if (columns < 1) {
            throw new ND4JIllegalStateException("Number of columns should be positive for new INDArray");
        }
        INDArray ret = INSTANCE.create(new int[]{1, columns}, Nd4j.getStrides(new int[]{1, columns}, order), 0, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int columns, char order) {
        return Nd4j.create(columns, order);
    }

    public static IComplexNDArray createComplex(int columns, char order) {
        int[] shape = new int[]{1, columns};
        IComplexNDArray ret = INSTANCE.createComplex(new int[]{1, columns}, Nd4j.getComplexStrides(shape, order), 0, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int offset, char order) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, offset, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array doesn't match data length");
            }
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array doesn't match data length");
            }
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape, int[] stride, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, int offset) {
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int rows, int columns, int[] stride, int offset) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        INDArray ret = INSTANCE.create(data, rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int rows, int columns, int[] stride, int offset) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        IComplexNDArray ret = INSTANCE.createComplex(data, rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int rows, int columns, int[] stride, int offset) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        INDArray ret = INSTANCE.create(data, rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int rows, int columns, int[] stride, int offset) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        IComplexNDArray ret = INSTANCE.createComplex(data, rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, offset, Nd4j.order());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape, int offset, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(List<INDArray> list, int[] shape) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(list, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride, int offset) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        IComplexNDArray ret = INSTANCE.createComplex(rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int rows, int columns, int[] stride, int offset) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        INDArray ret = INSTANCE.create(rows, columns, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int rows, int columns, int[] stride, int offset) {
        return Nd4j.create(rows, columns, stride, offset);
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride, int offset) {
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int[] shape, int[] stride, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, stride, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int[] shape, int[] stride, int offset) {
        return Nd4j.create(shape, stride, offset);
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride) {
        return Nd4j.createComplex(rows, columns, stride, Nd4j.order().charValue());
    }

    public static INDArray create(int rows, int columns, int[] stride) {
        return Nd4j.create(rows, columns, stride, Nd4j.order().charValue());
    }

    public static INDArray zeros(int rows, int columns, int[] stride) {
        return Nd4j.create(rows, columns, stride, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride) {
        return Nd4j.createComplex(shape, stride, Nd4j.order().charValue());
    }

    public static INDArray create(int[] shape, int[] stride) {
        return Nd4j.create(shape, stride, Nd4j.order().charValue());
    }

    public static INDArray zeros(int[] shape, int[] stride) {
        return Nd4j.create(shape, stride);
    }

    public static IComplexNDArray createComplex(int rows, int columns) {
        return Nd4j.createComplex(rows, columns, Nd4j.order().charValue());
    }

    public static INDArray create(int rows, int columns) {
        return Nd4j.create(rows, columns, Nd4j.order().charValue());
    }

    public static IComplexNDArray createComplex(int ... shape) {
        return Nd4j.createComplex(shape, Nd4j.order().charValue());
    }

    public static INDArray create(int ... shape) {
        return Nd4j.create(shape, Nd4j.order().charValue());
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, char ordering, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, char ordering, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, Nd4j.getStrides(shape, ordering), offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, int[] shape, int[] strides, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, strides, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, int[] shape, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, Nd4j.getStrides(shape), offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, int[] newShape, int[] newStride, int offset, char ordering) {
        Nd4j.checkShapeValues(newShape);
        INDArray ret = INSTANCE.create(data, newShape, newStride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] shape, int[] newStrides, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, newStrides, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] shape, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] shape, int[] newStrides, int offset, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, newStrides, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] shape, int offset, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer data, int[] shape) {
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(DataBuffer data, int[] shape) {
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(DataBuffer buffer) {
        INDArray ret = INSTANCE.create(buffer);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(IComplexNumber[] iComplexNumbers) {
        if (iComplexNumbers == null || iComplexNumbers.length < 1) {
            throw new ND4JIllegalStateException("Number of complex numbers can't be < 1 for new INDArray");
        }
        return Nd4j.createComplex(iComplexNumbers, new int[]{1, iComplexNumbers.length});
    }

    public static IComplexNDArray createComplex(IComplexNumber[][] iComplexNumbers) {
        IComplexNDArray shape = Nd4j.createComplex(iComplexNumbers.length, iComplexNumbers[0].length);
        for (int i = 0; i < iComplexNumbers.length; ++i) {
            for (int j = 0; j < iComplexNumbers[i].length; ++j) {
                shape.putScalar(i, j, iComplexNumbers[i][j]);
            }
        }
        return shape;
    }

    public static IComplexNDArray createComplex(float[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        int[] shape = new int[]{rows, columns};
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        int[] shape = new int[]{rows, columns};
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int[] shape, DataBuffer.Type dataType) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, dataType);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int[] shape, DataBuffer.Type dataType) {
        return Nd4j.create(shape, dataType);
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape, int[] stride, int offset, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int[] shape, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, (int)ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, (int)ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride, (int)ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride, (int)ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        int[] shape = new int[]{rows, columns};
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(double[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        int[] shape = new int[]{rows, columns};
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(Nd4j.createBuffer(data), shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, int offset, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(List<INDArray> list, int[] shape, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(list, shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride, int offset, char ordering) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        IComplexNDArray ret = INSTANCE.createComplex(new int[]{rows, columns}, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int rows, int columns, int[] stride, int offset, char ordering) {
        int[] shape = new int[]{rows, columns};
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int rows, int columns, int[] stride, int offset, char ordering) {
        return Nd4j.create(rows, columns, stride, offset, ordering);
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride, int offset, char ordering) {
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int[] shape, int[] stride, int offset, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, stride, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int[] shape, int[] stride, int offset, char ordering) {
        return Nd4j.create(shape, stride, offset, ordering);
    }

    public static IComplexNDArray createComplex(int rows, int columns, int[] stride, char ordering) {
        int[] shape = new int[]{rows, columns};
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(shape, stride, (int)ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int rows, int columns, int[] stride, char ordering) {
        int[] shape = new int[]{rows, columns};
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, stride, 0, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int rows, int columns, int[] stride, char ordering) {
        return Nd4j.create(rows, columns, stride, ordering);
    }

    public static IComplexNDArray createComplex(int[] shape, int[] stride, char ordering) {
        return Nd4j.createComplex(shape, stride, 0, ordering);
    }

    public static INDArray create(int[] shape, int[] stride, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, stride, 0, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int[] shape, int[] stride, char ordering) {
        return Nd4j.create(shape, stride, ordering);
    }

    public static IComplexNDArray createComplex(int rows, int columns, char ordering) {
        int[] shape = new int[]{rows, columns};
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(shape, Nd4j.getComplexStrides(shape, ordering), 0, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int rows, int columns, char ordering) {
        return Nd4j.create(new int[]{rows, columns}, ordering);
    }

    public static INDArray zeros(int rows, int columns, char ordering) {
        return Nd4j.create(new int[]{rows, columns}, ordering);
    }

    public static IComplexNDArray createComplex(int[] shape, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape) * 2L), shape, 0, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray create(int[] shape, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        } else if (shape.length == 1) {
            shape = new int[]{1, shape[0]};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    protected static void checkShapeValues(int[] shape) {
        for (int e = 0; e < shape.length; ++e) {
            if (shape[e] >= 1) continue;
            throw new ND4JIllegalStateException("Invalid shape: Requested INDArray shape " + Arrays.toString(shape) + " contains dimension size values < 1 (all dimensions must be 1 or more)");
        }
    }

    protected static void checkShapeValues(int length, int[] shape) {
        Nd4j.checkShapeValues(shape);
        if (ArrayUtil.prodLong((int[])shape) > (long)length) {
            throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + length);
        }
    }

    public static INDArray createUninitialized(int[] shape, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        } else if (shape.length == 1) {
            shape = new int[]{1, shape[0]};
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.createUninitialized(shape, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray createUninitialized(int[] shape) {
        Nd4j.checkShapeValues(shape);
        return Nd4j.createUninitialized(shape, Nd4j.order().charValue());
    }

    public static INDArray createUninitialized(int length) {
        if (length < 1) {
            throw new IllegalStateException("INDArray length should be positive value");
        }
        int[] shape = new int[]{1, length};
        INDArray ret = INSTANCE.createUninitialized(shape, Nd4j.order().charValue());
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int offset, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, Nd4j.getComplexStrides(shape, ordering), offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int offset) {
        return Nd4j.createComplex(data, shape, offset, Nd4j.order().charValue());
    }

    public static INDArray create(double[] data, int[] shape, int offset) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        if (shape.length == 1) {
            if (shape[0] == data.length) {
                shape = new int[]{1, data.length};
            } else {
                throw new ND4JIllegalStateException("Shape of the new array " + Arrays.toString(shape) + " doesn't match data length: " + data.length);
            }
        }
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(data, shape, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] data, int[] shape, int offset, char ordering) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, offset, ordering);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(double[] dim) {
        IComplexNDArray ret = INSTANCE.createComplex(dim, new int[]{1, dim.length / 2});
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray createComplex(float[] data, int[] shape, int offset) {
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.createComplex(data, shape, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int rows, int columns) {
        INDArray ret = INSTANCE.zeros(rows, columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray complexZeros(int rows, int columns) {
        IComplexNDArray ret = INSTANCE.complexZeros(rows, columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int columns) {
        return INSTANCE.zeros(columns);
    }

    public static IComplexNDArray complexZeros(int columns) {
        return INSTANCE.complexZeros(columns);
    }

    public static IComplexNDArray complexValueOf(int num, IComplexNumber value) {
        IComplexNDArray ret = INSTANCE.complexValueOf(num, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray complexValueOf(int[] shape, IComplexNumber value) {
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.complexValueOf(shape, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray complexValueOf(int num, double value) {
        return INSTANCE.complexValueOf(num, value);
    }

    public static IComplexNDArray complexValueOf(int[] shape, double value) {
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.complexValueOf(shape, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray valueArrayOf(int[] shape, double value) {
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.valueArrayOf(shape, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray valueArrayOf(int num, double value) {
        INDArray ret = INSTANCE.valueArrayOf(new int[]{1, num}, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray valueArrayOf(int rows, int columns, double value) {
        if (rows < 1 || columns < 1) {
            throw new ND4JIllegalStateException("Number of rows and columns should be positive for new INDArray");
        }
        INDArray ret = INSTANCE.valueArrayOf(rows, columns, value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray ones(int rows, int columns) {
        INDArray ret = INSTANCE.ones(rows, columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zerosLike(INDArray arr) {
        return Nd4j.create(arr.shape());
    }

    public static INDArray emptyLike(INDArray arr) {
        return Nd4j.create(arr.shape());
    }

    public static INDArray onesLike(INDArray arr) {
        return Nd4j.ones(arr.shape());
    }

    public static IComplexNDArray complexOnes(int rows, int columns) {
        IComplexNDArray ret = INSTANCE.complexOnes(rows, columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray ones(int columns) {
        INDArray ret = INSTANCE.ones(columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray complexOnes(int columns) {
        IComplexNDArray ret = INSTANCE.complexOnes(columns);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray hstack(INDArray ... arrs) {
        INDArray ret = INSTANCE.hstack(arrs);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray hstack(Collection<INDArray> arrs) {
        INDArray[] arrays = arrs.toArray(new INDArray[0]);
        INDArray ret = INSTANCE.hstack(arrays);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray vstack(INDArray ... arrs) {
        INDArray ret = INSTANCE.vstack(arrs);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray vstack(Collection<INDArray> arrs) {
        INDArray[] arrays = arrs.toArray(new INDArray[0]);
        INDArray ret = INSTANCE.vstack(arrays);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray averageAndPropagate(INDArray target, INDArray[] arrays) {
        INDArray ret = INSTANCE.average(target, arrays);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray averageAndPropagate(INDArray[] arrays) {
        INDArray ret = INSTANCE.average(arrays);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray averageAndPropagate(Collection<INDArray> arrays) {
        INDArray ret = INSTANCE.average(arrays);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray averageAndPropagate(INDArray target, Collection<INDArray> arrays) {
        INDArray ret = INSTANCE.average(target, arrays);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray stripOnes(INDArray toStrip) {
        if (toStrip.isVector()) {
            return toStrip;
        }
        int[] shape = Shape.squeeze(toStrip.shape());
        return toStrip.reshape(shape);
    }

    public static INDArray pullRows(INDArray source, int sourceDimension, int[] indexes) {
        return Nd4j.pullRows(source, sourceDimension, indexes, Nd4j.order().charValue());
    }

    public static INDArray pullRows(INDArray source, int sourceDimension, int[] indexes, char order) {
        if (sourceDimension >= source.rank()) {
            throw new IllegalStateException("Source dimension can't be higher the rank of source tensor");
        }
        if (indexes == null || indexes.length == 0) {
            throw new IllegalStateException("Indexes shouldn't be empty");
        }
        if (order != 'c' && order != 'f' && order != 'a') {
            throw new IllegalStateException("Unknown order being passed in [" + order + "]");
        }
        for (int idx : indexes) {
            if (idx >= 0 && idx < source.shape()[source.rank() - sourceDimension - 1]) continue;
            throw new IllegalStateException("Index can't be < 0 and >= " + source.shape()[source.rank() - sourceDimension - 1]);
        }
        INDArray ret = INSTANCE.pullRows(source, sourceDimension, indexes, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray concat(int dimension, INDArray ... toConcat) {
        INDArray ret = INSTANCE.concat(dimension, toConcat);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray concat(int dimension, IComplexNDArray ... toConcat) {
        IComplexNDArray ret = INSTANCE.concat(dimension, toConcat);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int[] shape, char order) {
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.create(shape, order);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray zeros(int ... shape) {
        return Nd4j.create(shape);
    }

    public static IComplexNDArray complexZeros(int ... shape) {
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.complexZeros(shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray ones(int ... shape) {
        Nd4j.checkShapeValues(shape);
        INDArray ret = INSTANCE.ones(shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray complexOnes(int ... shape) {
        Nd4j.checkShapeValues(shape);
        IComplexNDArray ret = INSTANCE.complexOnes(shape);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray scalar(Number value, int offset) {
        return INSTANCE.scalar(value, offset);
    }

    public static IComplexNDArray complexScalar(Number value, int offset) {
        IComplexNDArray arr = INSTANCE.complexScalar(value, offset);
        Nd4j.logCreationIfNecessary(arr);
        return arr;
    }

    public static IComplexNDArray complexScalar(Number value) {
        return INSTANCE.complexScalar(value);
    }

    public static INDArray scalar(double value, int offset) {
        INDArray ret = INSTANCE.scalar(value, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray scalar(float value, int offset) {
        INDArray ret = INSTANCE.scalar(value, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray scalar(Number value) {
        INDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray scalar(double value) {
        INDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static INDArray scalar(float value) {
        INDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray scalar(IComplexNumber value, int offset) {
        IComplexNDArray ret = INSTANCE.scalar(value, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray scalar(IComplexFloat value) {
        IComplexNDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray scalar(IComplexDouble value) {
        IComplexNDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray scalar(IComplexNumber value) {
        IComplexNDArray ret = INSTANCE.scalar(value);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray scalar(IComplexFloat value, int offset) {
        IComplexNDArray ret = INSTANCE.scalar(value, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static IComplexNDArray scalar(IComplexDouble value, int offset) {
        IComplexNDArray ret = INSTANCE.scalar(value, offset);
        Nd4j.logCreationIfNecessary(ret);
        return ret;
    }

    public static int[] getStrides(int[] shape, char order) {
        if (order == 'f') {
            return ArrayUtil.calcStridesFortran((int[])shape);
        }
        return ArrayUtil.calcStrides((int[])shape);
    }

    public static int[] getStrides(int[] shape) {
        return Nd4j.getStrides(shape, Nd4j.order().charValue());
    }

    public static INDArray tile(INDArray tile, int ... repeat) {
        int d = repeat.length;
        int[] shape = ArrayUtil.copy((int[])tile.shape());
        int n = Math.max(tile.length(), 1);
        if (d < tile.rank()) {
            repeat = Ints.concat((int[][])new int[][]{ArrayUtil.nTimes((int)(tile.rank() - d), (int)1), repeat});
        }
        for (int i = 0; i < shape.length; ++i) {
            int nOut;
            if (repeat[i] != 1) {
                tile = tile.reshape(-1, n).repeat(0, repeat[i]);
            }
            int in = shape[i];
            shape[i] = nOut = in * repeat[i];
            n /= Math.max(in, 1);
        }
        return tile.reshape(shape);
    }

    public static int[] getComplexStrides(int[] shape, char order) {
        if (order == 'f') {
            return ArrayUtil.calcStridesFortran((int[])shape, (int)2);
        }
        return ArrayUtil.calcStrides((int[])shape, (int)2);
    }

    public static int[] getComplexStrides(int[] shape) {
        return Nd4j.getComplexStrides(shape, Nd4j.order().charValue());
    }

    public static IComplexNDArray complexLinSpace(int i, int i1, int i2) {
        return Nd4j.createComplex(Nd4j.linspace(i, i1, i2));
    }

    public synchronized void initContext() {
        try {
            Nd4jBackend backend = Nd4jBackend.load();
            this.initWithBackend(backend);
        }
        catch (Nd4jBackend.NoAvailableBackendException e) {
            throw new RuntimeException(e);
        }
    }

    public void initWithBackend(Nd4jBackend backend) {
        try {
            if (System.getProperties().getProperty("backends") != null && !System.getProperties().getProperty("backends").contains(backend.getClass().getName())) {
                return;
            }
            if (!Nd4j.isSupportedPlatform()) {
                Nd4j.showAttractiveMessage(Nd4j.getMessageForUnsupportedPlatform());
                return;
            }
            Nd4j.backend = backend;
            props = Nd4jContext.getInstance().getConf();
            InputStream is = backend.getConfigurationResource().getInputStream();
            Nd4jContext.getInstance().updateProperties(is);
            is.close();
            String otherDtype = System.getProperty(DTYPE, props.get(DTYPE).toString());
            DataBuffer.Type type = otherDtype.equals("float") ? DataBuffer.Type.FLOAT : (dtype = otherDtype.equals("half") ? DataBuffer.Type.HALF : DataBuffer.Type.DOUBLE);
            if (dtype == DataBuffer.Type.HALF && backend.getClass().getName().equals("CpuBackend")) {
                Nd4j.showAttractiveMessage(this.getMessageForNativeHalfPrecision());
            }
            compressDebug = Boolean.parseBoolean(props.getProperty(COMPRESSION_DEBUG, "false"));
            copyOnOps = Boolean.parseBoolean(props.getProperty(COPY_OPS, "true"));
            shouldInstrument = Boolean.parseBoolean(props.getProperty(INSTRUMENTATION, "false"));
            resourceManagerOn = Boolean.parseBoolean(props.getProperty(RESOURCE_MANGER_ON, "false"));
            executionMode = props.getProperty(EXECUTION_MODE, "java").equals("java") ? OpExecutioner.ExecutionMode.JAVA : OpExecutioner.ExecutionMode.NATIVE;
            ORDER = System.getProperty(ORDER_KEY, props.getProperty(ORDER_KEY, "c").toString()).charAt(0);
            affinityManagerClazz = Class.forName(System.getProperty(AFFINITY_MANAGER, props.get(AFFINITY_MANAGER).toString()));
            affinityManager = affinityManagerClazz.newInstance();
            fftInstanceClazz = Class.forName(System.getProperty(FFT_OPS, DefaultFFTInstance.class.getName()));
            ndArrayFactoryClazz = Class.forName(System.getProperty(NDARRAY_FACTORY_CLASS, props.get(NDARRAY_FACTORY_CLASS).toString()));
            convolutionInstanceClazz = Class.forName(System.getProperty(CONVOLUTION_OPS, DefaultConvolutionInstance.class.getName()));
            String defaultName = props.getProperty(DATA_BUFFER_OPS, DefaultDataBufferFactory.class.getName());
            dataBufferFactoryClazz = Class.forName(System.getProperty(DATA_BUFFER_OPS, defaultName));
            shapeInfoProviderClazz = Class.forName(System.getProperty(SHAPEINFO_PROVIDER, props.get(SHAPEINFO_PROVIDER).toString()));
            constantProviderClazz = Class.forName(System.getProperty(CONSTANT_PROVIDER, props.get(CONSTANT_PROVIDER).toString()));
            memoryManagerClazz = Class.forName(System.getProperty(MEMORY_MANAGER, props.get(MEMORY_MANAGER).toString()));
            allowsOrder = backend.allowsOrder();
            String rand = props.getProperty(RANDOM_PROVIDER, DefaultRandom.class.getName());
            randomClazz = Class.forName(rand);
            randomFactory = new RandomFactory(randomClazz);
            instrumentationClazz = Class.forName(props.getProperty(INSTRUMENTATION, InMemoryInstrumentation.class.getName()));
            opFactoryClazz = Class.forName(System.getProperty(OP_FACTORY, DefaultOpFactory.class.getName()));
            blasWrapperClazz = Class.forName(System.getProperty(BLAS_OPS, props.get(BLAS_OPS).toString()));
            String clazzName = props.getProperty(DISTRIBUTION, DefaultDistributionFactory.class.getName());
            distributionFactoryClazz = Class.forName(clazzName);
            memoryManager = memoryManagerClazz.newInstance();
            constantHandler = constantProviderClazz.newInstance();
            shapeInfoProvider = shapeInfoProviderClazz.newInstance();
            opExecutionerClazz = Class.forName(props.getProperty(OP_EXECUTIONER, DefaultOpExecutioner.class.getName()));
            instrumentation = instrumentationClazz.newInstance();
            OP_EXECUTIONER_INSTANCE = opExecutionerClazz.newInstance();
            FFT_INSTANCE = fftInstanceClazz.newInstance();
            Constructor<? extends NDArrayFactory> c2 = ndArrayFactoryClazz.getConstructor(DataBuffer.Type.class, Character.TYPE);
            INSTANCE = c2.newInstance(dtype, Character.valueOf(ORDER));
            CONVOLUTION_INSTANCE = convolutionInstanceClazz.newInstance();
            BLAS_WRAPPER_INSTANCE = blasWrapperClazz.newInstance();
            DATA_BUFFER_FACTORY_INSTANCE = dataBufferFactoryClazz.newInstance();
            OP_FACTORY_INSTANCE = opFactoryClazz.newInstance();
            UNIT = Nd4j.createFloat(1.0f, 0.0f);
            ZERO = Nd4j.createFloat(0.0f, 0.0f);
            NEG_UNIT = Nd4j.createFloat(-1.0f, 0.0f);
            ENFORCE_NUMERICAL_STABILITY = Boolean.parseBoolean(System.getProperty(NUMERICAL_STABILITY, String.valueOf(false)));
            DISTRIBUTION_FACTORY = distributionFactoryClazz.newInstance();
            Nd4j.getExecutioner().setExecutionMode(executionMode);
            String fallback = System.getenv("ND4J_FALLBACK");
            if (fallback != null && !fallback.isEmpty()) {
                if (fallback.equalsIgnoreCase("true") || fallback.equalsIgnoreCase("1")) {
                    fallbackMode.set(true);
                    Nd4j.showAttractiveMessage(Nd4j.getMessageForFallback());
                } else {
                    fallbackMode.set(false);
                }
            } else {
                fallbackMode.set(false);
            }
            OP_EXECUTIONER_INSTANCE.printEnvironmentInformation();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isSupportedPlatform() {
        return System.getProperty("java.vm.name").equalsIgnoreCase("Dalvik") || System.getProperty("os.arch").toLowerCase().startsWith("arm") || System.getProperty("sun.arch.data.model").equals("64");
    }

    private static void showAttractiveMessage(String ... strings) {
        System.out.println(Nd4j.attract(strings));
    }

    private static String attract(String ... strings) {
        String delimiter = "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!";
        String shift = "                 ";
        StringBuilder sb = new StringBuilder().append(delimiter).append("\n").append("\n");
        for (String s : strings) {
            sb.append(shift).append(s).append("\n");
        }
        sb.append("\n").append(delimiter).append("\n");
        return sb.toString();
    }

    private static String[] getMessageForUnsupportedPlatform() {
        return new String[]{"Unfortunately you can't use DL4j/ND4j on 32-bit x86 JVM", "Please, consider running this on 64-bit JVM instead"};
    }

    private static String[] getMessageForFallback() {
        return new String[]{"ND4J_FALLBACK environment variable is detected!", "Performance will be slightly reduced"};
    }

    private String[] getMessageForNativeHalfPrecision() {
        return new String[]{"Half-precision data type isn't support for nd4j-native", "Please, consider using FLOAT or DOUBLE data type instead"};
    }

    public static ShapeInfoProvider getShapeInfoProvider() {
        return shapeInfoProvider;
    }

    public static ConstantHandler getConstantHandler() {
        return constantHandler;
    }

    public static AffinityManager getAffinityManager() {
        return affinityManager;
    }

    public static NDArrayFactory getNDArrayFactory() {
        return INSTANCE;
    }

    public static BasicNDArrayCompressor getCompressor() {
        return BasicNDArrayCompressor.getInstance();
    }

    public static MemoryManager getMemoryManager() {
        return memoryManager;
    }

    public static INDArray typeConversion(INDArray array, DataBuffer.TypeEx targetType) {
        return null;
    }

    public static int sizeOfDataType() {
        return Nd4j.sizeOfDataType(Nd4j.dataType());
    }

    public static int sizeOfDataType(DataBuffer.Type dtype) {
        switch (dtype) {
            case FLOAT: {
                return 4;
            }
            case HALF: {
                return 2;
            }
        }
        return 8;
    }

    public static void enableFallbackMode(boolean reallyEnable) {
        fallbackMode.set(reallyEnable);
    }

    public static boolean isFallbackModeEnabled() {
        return fallbackMode.get();
    }

    static {
        EPS_THRESHOLD = 1.0E-5;
        MAX_ELEMENTS_PER_SLICE = 3;
        MAX_SLICES_TO_PRINT = 3;
        ENFORCE_NUMERICAL_STABILITY = false;
        copyOnOps = true;
        shouldInstrument = false;
        resourceManagerOn = false;
        allowsOrder = false;
        compressDebug = false;
        preventUnpack = System.getenv("ND4J_PREVENT_UNPACK") != null;
        props = new Properties();
        referenceQueue = new ReferenceQueue();
        bufferQueue = new ReferenceQueue();
        logger = Logger.getLogger(Nd4j.class.getName());
        fallbackMode = new AtomicBoolean(false);
        Nd4j nd4j = new Nd4j();
        nd4j.initContext();
    }

    public static enum PadMode {
        CONSTANT,
        EDGE,
        LINEAR_RAMP,
        MAXIMUM,
        MEAN,
        MEDIAN,
        MINIMUM,
        REFLECT,
        SYMMETRIC,
        WRAP;

    }
}

