/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.scalar;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseScalarOp;
import org.nd4j.linalg.api.ops.Op;

public class ScalarFMod
extends BaseScalarOp {
    public ScalarFMod() {
    }

    public ScalarFMod(INDArray x, INDArray y, INDArray z, long n, Number num) {
        super(x, y, z, n, num);
    }

    public ScalarFMod(INDArray x, Number num) {
        super(x, num);
    }

    public ScalarFMod(INDArray x, INDArray y, INDArray z, long n, IComplexNumber num) {
        super(x, y, z, n, num);
    }

    public ScalarFMod(INDArray x, IComplexNumber num) {
        super(x, num);
    }

    @Override
    public int opNum() {
        return 18;
    }

    @Override
    public String name() {
        return "fmod_scalar";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        if (this.complexNumber != null) {
            return origin.div(this.complexNumber);
        }
        return this.complexNumber.div(this.num);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        if (this.complexNumber != null) {
            return origin.div(this.complexNumber);
        }
        return this.complexNumber.div(this.num);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        if (this.complexNumber != null) {
            return origin.div(this.complexNumber);
        }
        return this.complexNumber.div(this.num);
    }

    @Override
    public float op(float origin, float other) {
        return origin / this.num.floatValue();
    }

    @Override
    public double op(double origin, double other) {
        return origin / this.num.doubleValue();
    }

    @Override
    public double op(double origin) {
        return origin / this.num.doubleValue();
    }

    @Override
    public float op(float origin) {
        return origin / this.num.floatValue();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        if (this.complexNumber != null) {
            return origin.div(this.complexNumber);
        }
        return this.complexNumber.div(this.num);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        if (this.num != null) {
            return new ScalarFMod(this.x.vectorAlongDimension(index, dimension), this.num);
        }
        return new ScalarFMod(this.x.vectorAlongDimension(index, dimension), this.complexNumber);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        if (this.num != null) {
            return new ScalarFMod(this.x.tensorAlongDimension(index, dimension), this.num);
        }
        return new ScalarFMod(this.x.tensorAlongDimension(index, dimension), this.complexNumber);
    }
}

