/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.ops.transforms.Transforms;

public class Norm2
extends BaseAccumulation {
    public Norm2() {
    }

    public Norm2(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public Norm2(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public Norm2(INDArray x) {
        super(x);
    }

    public Norm2(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public INDArray noOp() {
        return Transforms.abs(this.x());
    }

    @Override
    public double op(double origin) {
        return origin * origin;
    }

    @Override
    public double op(double origin, double other) {
        return origin * origin;
    }

    @Override
    public float op(float origin) {
        return origin * origin;
    }

    @Override
    public float op(float origin, float other) {
        return origin * origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin.mul(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return origin.mul(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return origin.mul(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin.mul(origin);
    }

    @Override
    public double update(double accum, double x) {
        return accum + x;
    }

    @Override
    public double update(double accum, double x, double y) {
        return accum + x;
    }

    @Override
    public float update(float accum, float x) {
        return accum + x;
    }

    @Override
    public float update(float accum, float x, float y) {
        return accum + x;
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        return accum.add((Number)x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        return accum.add((Number)x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        return accum.add(x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        return accum.add(x);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        return accum.add(x);
    }

    @Override
    public double combineSubResults(double first, double second) {
        return first + second;
    }

    @Override
    public float combineSubResults(float first, float second) {
        return first + second;
    }

    @Override
    public IComplexNumber combineSubResults(IComplexNumber first, IComplexNumber second) {
        return first.add(second);
    }

    @Override
    public int opNum() {
        return 6;
    }

    @Override
    public String name() {
        return "norm2";
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        Norm2 ret = this.y() != null ? new Norm2(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length()) : new Norm2(this.x.vectorAlongDimension(index, dimension));
        ret.setApplyFinalTransform(this.applyFinalTransform());
        return ret;
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        Norm2 ret = this.y() != null ? new Norm2(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length()) : new Norm2(this.x.tensorAlongDimension(index, dimension));
        ret.setApplyFinalTransform(this.applyFinalTransform());
        return ret;
    }

    @Override
    public double getAndSetFinalResult(double accum) {
        if (this.applyFinalTransform()) {
            double d = FastMath.sqrt((double)accum);
            this.finalResult = d;
            return d;
        }
        return accum;
    }

    @Override
    public float getAndSetFinalResult(float accum) {
        if (this.applyFinalTransform()) {
            float f = (float)FastMath.sqrt((double)accum);
            this.finalResult = Float.valueOf(f);
            return f;
        }
        return accum;
    }

    @Override
    public IComplexNumber getAndSetFinalResult(IComplexNumber accum) {
        this.finalResultComplex = accum.sqrt();
        return this.finalResultComplex;
    }

    @Override
    public double calculateFinalResult(double accum, long n) {
        if (this.applyFinalTransform()) {
            return FastMath.sqrt((double)accum);
        }
        return accum;
    }

    @Override
    public float calculateFinalResult(float accum, long n) {
        if (this.applyFinalTransform()) {
            return (float)FastMath.sqrt((double)accum);
        }
        return accum;
    }
}

