/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.activations;

import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationCube;
import org.nd4j.linalg.activations.impl.ActivationELU;
import org.nd4j.linalg.activations.impl.ActivationHardSigmoid;
import org.nd4j.linalg.activations.impl.ActivationHardTanH;
import org.nd4j.linalg.activations.impl.ActivationIdentity;
import org.nd4j.linalg.activations.impl.ActivationLReLU;
import org.nd4j.linalg.activations.impl.ActivationRReLU;
import org.nd4j.linalg.activations.impl.ActivationRationalTanh;
import org.nd4j.linalg.activations.impl.ActivationReLU;
import org.nd4j.linalg.activations.impl.ActivationSigmoid;
import org.nd4j.linalg.activations.impl.ActivationSoftPlus;
import org.nd4j.linalg.activations.impl.ActivationSoftSign;
import org.nd4j.linalg.activations.impl.ActivationSoftmax;
import org.nd4j.linalg.activations.impl.ActivationTanH;

public enum Activation {
    CUBE,
    ELU,
    HARDSIGMOID,
    HARDTANH,
    IDENTITY,
    LEAKYRELU,
    RATIONALTANH,
    RELU,
    RRELU,
    SIGMOID,
    SOFTMAX,
    SOFTPLUS,
    SOFTSIGN,
    TANH;


    public IActivation getActivationFunction() {
        switch (this) {
            case CUBE: {
                return new ActivationCube();
            }
            case ELU: {
                return new ActivationELU();
            }
            case HARDSIGMOID: {
                return new ActivationHardSigmoid();
            }
            case HARDTANH: {
                return new ActivationHardTanH();
            }
            case IDENTITY: {
                return new ActivationIdentity();
            }
            case LEAKYRELU: {
                return new ActivationLReLU();
            }
            case RATIONALTANH: {
                return new ActivationRationalTanh();
            }
            case RELU: {
                return new ActivationReLU();
            }
            case RRELU: {
                return new ActivationRReLU();
            }
            case SIGMOID: {
                return new ActivationSigmoid();
            }
            case SOFTMAX: {
                return new ActivationSoftmax();
            }
            case SOFTPLUS: {
                return new ActivationSoftPlus();
            }
            case SOFTSIGN: {
                return new ActivationSoftSign();
            }
            case TANH: {
                return new ActivationTanH();
            }
        }
        throw new UnsupportedOperationException("Unknown or not supported activation function: " + (Object)((Object)this));
    }

    public static Activation fromString(String name) {
        return Activation.valueOf(name.toUpperCase());
    }
}

