/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public class LongRef {
    private long value;

    public LongRef() {
        this(0L);
    }

    public LongRef(long value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public final long get() {
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final void await(long desired) {
        if (desired != this.value) {
            StmUtils.retry();
        }
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final long awaitLargerThan(long than) {
        if (this.value <= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final long awaitLargerOrEqualThan(long than) {
        if (this.value < than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final long awaitSmallerThan(long than) {
        if (this.value >= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final long awaitSmallerOrEqualThan(long than) {
        if (this.value > than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final long awaitNotEqualThan(long than) {
        if (this.value == than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final long set(long newValue) {
        long oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final long inc() {
        ++this.value;
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final long inc(long amount) {
        this.value += amount;
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final long dec() {
        --this.value;
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final long dec(long amount) {
        this.value -= amount;
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public final String toString() {
        return String.format("LongRef(value=%s)", this.value);
    }

    @TransactionalMethod(readonly=true)
    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @TransactionalMethod(readonly=true)
    public final boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof LongRef)) {
            return false;
        }
        LongRef that = (LongRef)thatObj;
        return that.value == this.value;
    }
}

