/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public class DoubleRef {
    private double value;

    public DoubleRef() {
        this(0.0);
    }

    public DoubleRef(double value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public final double get() {
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final void await(double desired) {
        if (!DoubleRef.equals(this.value, desired)) {
            StmUtils.retry();
        }
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final double set(double newValue) {
        if (DoubleRef.equals(newValue, this.value)) {
            return newValue;
        }
        double oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final double inc() {
        this.value += 1.0;
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final double inc(double amount) {
        if (DoubleRef.equals(amount, 0.0)) {
            return this.value;
        }
        this.value += amount;
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final double dec() {
        this.value -= 1.0;
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final double dec(double amount) {
        if (DoubleRef.equals(amount, 0.0)) {
            return this.value;
        }
        this.value -= amount;
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public final String toString() {
        return String.format("DoubleRef(value=%s)", this.value);
    }

    @TransactionalMethod(readonly=true)
    public final int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    @TransactionalMethod(readonly=true)
    public final boolean equals(Object thatobj) {
        if (thatobj == this) {
            return true;
        }
        if (!(thatobj instanceof DoubleRef)) {
            return false;
        }
        DoubleRef that = (DoubleRef)thatobj;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value);
    }

    private static boolean equals(double d1, double d2) {
        return Double.doubleToLongBits(d1) == Double.doubleToLongBits(d2);
    }
}

