/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.refs;

import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.StmUtils;

@TransactionalObject
public class ByteRef {
    private byte value;

    public ByteRef() {
        this(0);
    }

    public ByteRef(byte value) {
        this.value = value;
    }

    @TransactionalMethod(readonly=true)
    public final byte get() {
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final void await(byte desired) {
        if (desired != this.value) {
            StmUtils.retry();
        }
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final byte awaitLargerThan(byte than) {
        if (this.value <= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final byte awaitLargerOrEqualThan(byte than) {
        if (this.value < than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final byte awaitSmallerThan(byte than) {
        if (this.value >= than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final byte awaitSmallerOrEqualThan(byte than) {
        if (this.value > than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=true, trackReads=true)
    public final byte awaitNotEqualTo(byte than) {
        if (this.value == than) {
            StmUtils.retry();
        }
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final byte set(byte newValue) {
        if (newValue == this.value) {
            return newValue;
        }
        byte oldValue = this.value;
        this.value = newValue;
        return oldValue;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final byte inc() {
        this.value = (byte)(this.value + 1);
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final byte inc(byte amount) {
        if (amount == 0) {
            return this.value;
        }
        this.value = (byte)(this.value + amount);
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final byte dec() {
        this.value = (byte)(this.value - 1);
        return this.value;
    }

    @TransactionalMethod(readonly=false, trackReads=true)
    public final byte dec(byte amount) {
        if (amount == 0) {
            return this.value;
        }
        this.value = (byte)(this.value - amount);
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public final String toString() {
        return String.format("ByteRef(value=%s)", this.value);
    }

    @TransactionalMethod(readonly=true)
    public final int hashCode() {
        return this.value;
    }

    @TransactionalMethod(readonly=true)
    public final boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof ByteRef)) {
            return false;
        }
        ByteRef that = (ByteRef)thatObj;
        return that.value == this.value;
    }
}

