/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.multiverse.annotations.NonTransactional;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.programmatic.ProgrammaticLongRef;
import org.multiverse.api.programmatic.ProgrammaticRefFactory;
import org.multiverse.transactional.arrays.TransactionalReferenceArray;
import org.multiverse.transactional.collections.TransactionalList;
import org.multiverse.utils.TodoException;

public final class TransactionalArrayList<E>
implements TransactionalList<E> {
    private static final ProgrammaticRefFactory sizeFactory = GlobalStmInstance.getGlobalStmInstance().getProgrammaticRefFactoryBuilder().build();
    private TransactionalReferenceArray<E> array;
    private final ProgrammaticLongRef size = sizeFactory.atomicCreateLongRef(0L);

    public TransactionalArrayList() {
        this(10);
    }

    public TransactionalArrayList(E ... items) {
        this(items.length);
        for (E item : items) {
            this.add(item);
        }
    }

    public TransactionalArrayList(Collection<? extends E> items) {
        this(items.size());
        for (E item : items) {
            this.add(item);
        }
    }

    public TransactionalArrayList(int capacity) {
        this.array = new TransactionalReferenceArray(capacity);
    }

    @Override
    public int size() {
        return (int)this.size.get();
    }

    @Override
    @NonTransactional
    public int atomicSize() {
        return (int)this.size.atomicGet();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0L;
    }

    @Override
    public boolean add(E e) {
        int s = this.size();
        this.ensureCapacity(s + 1);
        this.array.set(s, e);
        this.size.commutingInc(1L);
        return true;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.array.length()) {
            int oldCapacity = this.array.length();
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.array = this.array.copyToBiggerArray(newCapacity);
        }
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E get(int index) {
        if (index < 0 || (long)index >= this.size.get()) {
            throw new IndexOutOfBoundsException();
        }
        return this.array.get(index);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public int indexOf(Object o) {
        int copiedSize = this.size();
        for (int k = 0; k < copiedSize; ++k) {
            E element = this.array.get(k);
            if (!TransactionalArrayList.equals(element, o)) continue;
            return k;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int copiedSize = this.size();
        for (int k = copiedSize - 1; k >= 0; --k) {
            E element = this.array.get(k);
            if (!TransactionalArrayList.equals(element, o)) continue;
            return k;
        }
        return -1;
    }

    private static boolean equals(Object element, Object o) {
        return element == null ? o == null : element.equals(o);
    }

    @Override
    @TransactionalMethod(trackReads=false)
    public E set(int index, E element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.array.set(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        int newSize = oldSize + c.size();
        this.ensureCapacity(newSize);
        this.size.commutingInc(c.size());
        Iterator<E> it = c.iterator();
        for (int k = oldSize; k < newSize; ++k) {
            this.array.set(k, it.next());
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        int localSize = this.size();
        for (int k = 0; k < localSize; ++k) {
            this.array.set(0, null);
        }
        this.size.set(0L);
    }

    @Override
    public Object[] toArray() {
        return this.array.toArray(this.size());
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int k;
        int localSize = (int)this.size.get();
        T[] r = a.length >= localSize ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), localSize);
        for (k = 0; k < localSize; ++k) {
            r[k] = this.array.get(k);
        }
        for (k = localSize; k < a.length; ++k) {
            r[k] = null;
        }
        return r;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.isEmpty()) {
            return true;
        }
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int indexOf = this.indexOf(o);
        if (indexOf == -1) {
            return false;
        }
        this.remove(indexOf);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Object item : c) {
            while (this.remove(item)) {
                changed = true;
            }
        }
        return changed;
    }

    @Override
    public E remove(int index) {
        int localSize = this.size();
        if (index < 0 || index >= localSize) {
            throw new IndexOutOfBoundsException();
        }
        E item = this.array.get(index);
        if (index < localSize - 1) {
            this.array.shiftLeft(index + 1, localSize - 1);
        } else {
            this.array.set(index, null);
        }
        this.size.inc(ThreadLocalTransaction.getThreadLocalTransaction(), -1L);
        return item;
    }

    @Override
    public void add(int index, E element) {
        int localSize = this.size();
        if (index < 0 || index > localSize) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(localSize + 1);
        this.array.shiftRight(index, localSize - 1);
        this.size.inc(ThreadLocalTransaction.getThreadLocalTransaction(), 1L);
        this.array.set(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int localSize = this.size();
        if (index < 0 || index > localSize) {
            throw new IndexOutOfBoundsException();
        }
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.isEmpty()) {
            return false;
        }
        this.ensureCapacity(localSize + c.size());
        throw new TodoException();
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new TodoException();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new TodoException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new TodoException();
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        int localSize = this.size();
        if (localSize == 0) {
            return false;
        }
        if (c.isEmpty()) {
            this.clear();
            return true;
        }
        boolean changed = false;
        for (int k = 0; k < localSize; ++k) {
            E item = this.array.get(k);
            if (c.contains(item)) continue;
            this.remove(k);
            --k;
            --localSize;
            changed = true;
        }
        return changed;
    }

    @Override
    public int hashCode() {
        int localSize = this.size();
        int hashCode = 1;
        if (localSize == 0) {
            return hashCode;
        }
        for (int k = 0; k < localSize; ++k) {
            E item = this.array.get(k);
            hashCode = 31 * hashCode + (item == null ? 0 : item.hashCode());
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object thatObj) {
        if (thatObj == this) {
            return true;
        }
        if (!(thatObj instanceof List)) {
            return false;
        }
        List that = (List)thatObj;
        int localSize = this.size();
        if (that.size() != localSize) {
            return false;
        }
        if (localSize == 0) {
            return true;
        }
        Iterator thatIt = that.iterator();
        for (int k = 0; k < localSize; ++k) {
            if (TransactionalArrayList.equals(this.array.get(k), thatIt.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        int localSize = this.size();
        if (localSize == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer("[");
        for (int k = 0; k < localSize; ++k) {
            sb.append(this.array.get(k));
            if (k >= localSize - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @TransactionalObject
    private class IteratorImpl
    implements Iterator<E> {
        private int index;

        private IteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            return this.index < TransactionalArrayList.this.size();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object item = TransactionalArrayList.this.get(this.index);
            ++this.index;
            return item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

