/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.transactional.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.StmUtils;
import org.multiverse.transactional.collections.TransactionalDeque;
import org.multiverse.utils.TodoException;

public abstract class AbstractTransactionalDeque<E>
implements TransactionalDeque<E> {
    protected boolean hasNoStorageCapacity() {
        return this.remainingCapacity() == 0;
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public void addFirst(E e) {
        if (this.hasNoStorageCapacity()) {
            throw new IllegalStateException();
        }
        this.doAddFirst(e);
    }

    protected abstract void doAddFirst(E var1);

    @Override
    public void addLast(E e) {
        if (this.hasNoStorageCapacity()) {
            throw new IllegalStateException();
        }
        this.doAddLast(e);
    }

    @Override
    public boolean offerFirst(E e) {
        if (this.hasNoStorageCapacity()) {
            return false;
        }
        this.doAddFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        if (this.hasNoStorageCapacity()) {
            return false;
        }
        this.doAddLast(e);
        return true;
    }

    @Override
    public boolean offerFirst(E e, long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    public boolean offerLast(E e, long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    protected abstract void doAddLast(E var1);

    @Override
    public void putFirst(E e) throws InterruptedException {
        if (this.hasNoStorageCapacity()) {
            this.size();
            StmUtils.retry();
        }
        this.doAddFirst(e);
    }

    @Override
    public void putLast(E e) throws InterruptedException {
        if (this.hasNoStorageCapacity()) {
            this.size();
            StmUtils.retry();
        }
        this.doAddLast(e);
    }

    @Override
    public E takeFirst() throws InterruptedException {
        if (this.isEmpty()) {
            StmUtils.retry();
        }
        return this.doRemoveFirst();
    }

    protected abstract E doRemoveFirst();

    @Override
    public E takeLast() throws InterruptedException {
        if (this.isEmpty()) {
            StmUtils.retry();
        }
        return this.doRemoveLast();
    }

    protected abstract E doRemoveLast();

    @Override
    public E removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.doRemoveFirst();
    }

    @Override
    public E removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.doRemoveLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        throw new TodoException();
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        throw new TodoException();
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.putLast(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E pollFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.doRemoveFirst();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public E pollLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.doRemoveLast();
    }

    @Override
    public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    public E pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new TodoException();
    }

    @Override
    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    public E takeUninterruptible() {
        if (this.isEmpty()) {
            StmUtils.retry();
        }
        return this.doRemoveFirst();
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E element() {
        return this.getFirst();
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        if (this.isEmpty()) {
            return 0;
        }
        for (E item : this) {
            c.add(item);
        }
        int oldSize = this.size();
        this.clear();
        return oldSize;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new TodoException();
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E getFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.peekFirst();
    }

    @Override
    @TransactionalMethod(readonly=true)
    public E getLast() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.peekLast();
    }

    @Override
    public abstract Iterator<E> iterator();

    @Override
    public abstract int size();

    @Override
    public boolean contains(Object o) {
        Iterator<E> e = this.iterator();
        if (o == null) {
            while (e.hasNext()) {
                if (e.next() != null) continue;
                return true;
            }
        } else {
            while (e.hasNext()) {
                if (!o.equals(e.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] r = new Object[this.size()];
        Iterator<E> it = this.iterator();
        for (int i = 0; i < r.length; ++i) {
            if (!it.hasNext()) {
                return Arrays.copyOf(r, i);
            }
            r[i] = it.next();
        }
        return it.hasNext() ? AbstractTransactionalDeque.finishToArray(r, it) : r;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        T[] r = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        Iterator<E> it = this.iterator();
        for (int i = 0; i < r.length; ++i) {
            if (!it.hasNext()) {
                if (a != r) {
                    return Arrays.copyOf(r, i);
                }
                r[i] = null;
                return r;
            }
            r[i] = it.next();
        }
        return it.hasNext() ? AbstractTransactionalDeque.finishToArray(r, it) : r;
    }

    private static <T> T[] finishToArray(T[] r, Iterator<?> it) {
        int i = r.length;
        while (it.hasNext()) {
            int cap = r.length;
            if (i == cap) {
                int newCap = (cap / 2 + 1) * 3;
                if (newCap <= cap) {
                    if (cap == Integer.MAX_VALUE) {
                        throw new OutOfMemoryError("Required array size too large");
                    }
                    newCap = Integer.MAX_VALUE;
                }
                r = Arrays.copyOf(r, newCap);
            }
            r[i++] = it.next();
        }
        return i == r.length ? r : Arrays.copyOf(r, i);
    }

    @Override
    public boolean remove(Object o) {
        Iterator<E> e = this.iterator();
        if (o == null) {
            while (e.hasNext()) {
                if (e.next() != null) continue;
                e.remove();
                return true;
            }
        } else {
            while (e.hasNext()) {
                if (!o.equals(e.next())) continue;
                e.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> e = this.iterator();
        while (e.hasNext()) {
            if (!c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public String toString() {
        Iterator<E> i = this.iterator();
        if (!i.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            E e;
            sb.append((Object)((e = i.next()) == this ? "(this Collection)" : e));
            if (!i.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(", ");
        }
    }
}

