/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.Retry;
import org.multiverse.templates.EitherCallable;
import org.multiverse.templates.OrElseCallable;

public final class OrElseTransactionExecutor {
    private final Transaction tx;

    public OrElseTransactionExecutor() {
        this(ThreadLocalTransaction.getThreadLocalTransaction());
    }

    public OrElseTransactionExecutor(Transaction tx) {
        this.tx = tx;
    }

    public final <E> E execute(EitherCallable<E> either, OrElseCallable<E> orelse) throws Exception {
        this.failIfTheCallablesAreNull(either, orelse);
        try {
            return either.call(this.tx);
        }
        catch (Retry e) {
            return orelse.call(this.tx);
        }
    }

    private void failIfTheCallablesAreNull(EitherCallable either, OrElseCallable orelse) {
        if (either == null) {
            throw new NullPointerException("Either Callable cannot be Null");
        }
        if (orelse == null) {
            throw new NullPointerException("OrElse Callable cannot be Null");
        }
    }
}

