/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api.latches;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.multiverse.api.latches.Latch;

public final class StandardLatch
implements Latch {
    private volatile boolean isOpen;
    private final Lock lock;
    private final Condition isOpenCondition;

    public StandardLatch() {
        this(false);
    }

    public StandardLatch(boolean isOpen) {
        this.isOpen = isOpen;
        this.lock = new ReentrantLock();
        this.isOpenCondition = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() throws InterruptedException {
        if (this.isOpen) {
            return;
        }
        this.lock.lockInterruptibly();
        try {
            while (!this.isOpen) {
                this.isOpenCondition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitUninterruptible() {
        if (this.isOpen) {
            return;
        }
        this.lock.lock();
        try {
            while (!this.isOpen) {
                this.isOpenCondition.awaitUninterruptibly();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean tryAwait(long timeout, TimeUnit unit) throws InterruptedException {
        if (unit == null) {
            throw new NullPointerException();
        }
        return this.tryAwaitNs(unit.toNanos(timeout));
    }

    @Override
    public boolean tryAwaitNs(long timeoutNs) throws InterruptedException {
        return this.tryAwait(timeoutNs) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long tryAwait(long timeoutNs) throws InterruptedException {
        if (this.isOpen) {
            return timeoutNs;
        }
        long startTimeNs = System.nanoTime();
        if (!this.lock.tryLock(timeoutNs, TimeUnit.NANOSECONDS)) {
            return -1L;
        }
        timeoutNs -= System.nanoTime() - startTimeNs;
        try {
            while (!this.isOpen) {
                if ((timeoutNs = this.isOpenCondition.awaitNanos(timeoutNs)) > 0L) continue;
                long l = -1L;
                return l;
            }
            long l = timeoutNs;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean tryAwaitUninterruptibleNs(long timeoutNs) {
        if (this.isOpen) {
            return true;
        }
        boolean restoreInterrupt = Thread.interrupted();
        while (true) {
            long startNs = System.nanoTime();
            try {
                boolean bl = this.tryAwait(timeoutNs) > 0L;
                return bl;
            }
            catch (InterruptedException ex) {
                restoreInterrupt = true;
                timeoutNs -= System.nanoTime() - startNs;
            }
        }
        finally {
            if (restoreInterrupt) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public boolean tryAwaitUninterruptible(long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException();
        }
        return this.tryAwaitUninterruptibleNs(unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        if (this.isOpen) {
            return;
        }
        this.lock.lock();
        try {
            this.isOpen = true;
            this.isOpenCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    public String toString() {
        return this.isOpen ? "StandardLatch(open=true)" : "StandardLatch(open=false)";
    }
}

