/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.api;

import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.NoTransactionFoundException;

public final class ThreadLocalTransaction {
    public static final ThreadLocal<Transaction> threadlocal = new ThreadLocal();

    public static Transaction getThreadLocalTransaction() {
        return threadlocal.get();
    }

    public static Transaction getRequiredThreadLocalTransaction() {
        Transaction tx = threadlocal.get();
        if (tx == null) {
            throw new NoTransactionFoundException("No transaction is found on the ThreadLocalTransaction");
        }
        return tx;
    }

    public static void clearThreadLocalTransaction() {
        threadlocal.set(null);
    }

    public static void setThreadLocalTransaction(Transaction tx) {
        threadlocal.set(tx);
    }

    private ThreadLocalTransaction() {
    }
}

