/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.morphia.ext.guice;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.mongodb.DBObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mongodb.morphia.ObjectFactory;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.mapping.Mapper;
import org.mongodb.morphia.utils.Assert;

public class GuiceObjectFactory
implements ObjectFactory {
    private final ObjectFactory delegate;
    private final Injector injector;

    public GuiceObjectFactory(ObjectFactory delegate, Injector injector) {
        this.delegate = delegate;
        this.injector = injector;
    }

    public <T> T createInstance(Class<T> clazz) {
        Assert.parameterNotNull((String)"clazz", clazz);
        if (this.injectOnConstructor(clazz)) {
            return (T)this.injector.getInstance(clazz);
        }
        return (T)this.injectMembers(this.delegate.createInstance(clazz));
    }

    private boolean injectOnConstructor(Class clazz) {
        Constructor<?>[] cs;
        for (Constructor<?> constructor : cs = clazz.getDeclaredConstructors()) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            return true;
        }
        return false;
    }

    private <T> T injectMembers(T o) {
        if (o != null) {
            this.injector.injectMembers(o);
        }
        return o;
    }

    public <T> T createInstance(Class<T> clazz, DBObject dbObj) {
        if (this.injectOnConstructor(clazz)) {
            return (T)this.injector.getInstance(clazz);
        }
        return (T)this.injectMembers(this.delegate.createInstance(clazz, dbObj));
    }

    public Object createInstance(Mapper mapper, MappedField mf, DBObject dbObj) {
        Class clazz = mf.getType();
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            return this.injectMembers(this.delegate.createInstance(mapper, mf, dbObj));
        }
        if (this.injectOnConstructor(clazz)) {
            return this.injector.getInstance(clazz);
        }
        return this.injectMembers(this.delegate.createInstance(mapper, mf, dbObj));
    }

    public Map createMap(MappedField mf) {
        Class clazz = mf.getType();
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            return this.injectMembers(this.delegate.createMap(mf));
        }
        if (this.injectOnConstructor(clazz)) {
            return (Map)this.injector.getInstance(clazz);
        }
        return this.injectMembers(this.delegate.createMap(mf));
    }

    public List createList(MappedField mf) {
        Class clazz = mf.getType();
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            return this.injectMembers(this.delegate.createList(mf));
        }
        if (this.injectOnConstructor(clazz)) {
            return (List)this.injector.getInstance(clazz);
        }
        return this.injectMembers(this.delegate.createList(mf));
    }

    public Set createSet(MappedField mf) {
        Class clazz = mf.getType();
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            return this.injectMembers(this.delegate.createSet(mf));
        }
        if (this.injectOnConstructor(clazz)) {
            return (Set)this.injector.getInstance(clazz);
        }
        return this.injectMembers(this.delegate.createSet(mf));
    }
}

