/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoQueryException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.client.ClientSessionBinding;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.AsyncClusterBinding;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.AsyncReadWriteBinding;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.internal.ClientSessionHelper;
import com.mongodb.reactivestreams.client.internal.MongoClientImpl;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import com.mongodb.reactivestreams.client.internal.OperationExecutor;
import com.mongodb.reactivestreams.client.internal.crypt.Crypt;
import com.mongodb.reactivestreams.client.internal.crypt.CryptBinding;
import reactor.core.publisher.Mono;

public class OperationExecutorImpl
implements OperationExecutor {
    private final MongoClientImpl mongoClient;
    private final ClientSessionHelper clientSessionHelper;

    OperationExecutorImpl(MongoClientImpl mongoClient, ClientSessionHelper clientSessionHelper) {
        this.mongoClient = mongoClient;
        this.clientSessionHelper = clientSessionHelper;
    }

    @Override
    public <T> Mono<T> execute(AsyncReadOperation<T> operation, ReadPreference readPreference, ReadConcern readConcern, @Nullable ClientSession session) {
        Assertions.notNull((String)"operation", operation);
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        Assertions.notNull((String)"readConcern", (Object)readConcern);
        if (session != null) {
            session.notifyOperationInitiated(operation);
        }
        return this.clientSessionHelper.withClientSession(session, this).map(clientSession -> this.getReadWriteBinding(readPreference, readConcern, (ClientSession)clientSession, session == null && clientSession != null)).switchIfEmpty(Mono.fromCallable(() -> this.getReadWriteBinding(readPreference, readConcern, session, false))).flatMap(binding -> {
            if (session != null && session.hasActiveTransaction() && !binding.getReadPreference().equals(ReadPreference.primary())) {
                binding.release();
                return Mono.error((Throwable)new MongoClientException("Read preference in a transaction must be primary"));
            }
            return Mono.create(sink -> operation.executeAsync((AsyncReadBinding)binding, (result, t) -> {
                try {
                    binding.release();
                }
                finally {
                    MongoOperationPublisher.sinkToCallback(sink).onResult(result, t);
                }
            })).doOnError(t -> {
                this.labelException(session, (Throwable)t);
                this.unpinServerAddressOnTransientTransactionError(session, (Throwable)t);
            });
        });
    }

    @Override
    public <T> Mono<T> execute(AsyncWriteOperation<T> operation, ReadConcern readConcern, @Nullable ClientSession session) {
        Assertions.notNull((String)"operation", operation);
        Assertions.notNull((String)"readConcern", (Object)readConcern);
        if (session != null) {
            session.notifyOperationInitiated(operation);
        }
        return this.clientSessionHelper.withClientSession(session, this).map(clientSession -> this.getReadWriteBinding(ReadPreference.primary(), readConcern, (ClientSession)clientSession, session == null && clientSession != null)).switchIfEmpty(Mono.fromCallable(() -> this.getReadWriteBinding(ReadPreference.primary(), readConcern, session, false))).flatMap(binding -> Mono.create(sink -> operation.executeAsync((AsyncWriteBinding)binding, (result, t) -> {
            try {
                binding.release();
            }
            finally {
                MongoOperationPublisher.sinkToCallback(sink).onResult(result, t);
            }
        })).doOnError(t -> {
            this.labelException(session, (Throwable)t);
            this.unpinServerAddressOnTransientTransactionError(session, (Throwable)t);
        }));
    }

    private void labelException(@Nullable ClientSession session, @Nullable Throwable t) {
        if (session != null && session.hasActiveTransaction() && (t instanceof MongoSocketException || t instanceof MongoTimeoutException || t instanceof MongoQueryException && ((MongoQueryException)t).getErrorCode() == 91) && !((MongoException)t).hasErrorLabel("UnknownTransactionCommitResult")) {
            ((MongoException)t).addLabel("TransientTransactionError");
        }
    }

    private void unpinServerAddressOnTransientTransactionError(@Nullable ClientSession session, @Nullable Throwable throwable) {
        if (session != null && throwable instanceof MongoException && ((MongoException)throwable).hasErrorLabel("TransientTransactionError")) {
            session.clearTransactionContext();
        }
    }

    private AsyncReadWriteBinding getReadWriteBinding(ReadPreference readPreference, ReadConcern readConcern, @Nullable ClientSession session, boolean ownsSession) {
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        Object readWriteBinding = new AsyncClusterBinding(this.mongoClient.getCluster(), this.getReadPreferenceForBinding(readPreference, session), readConcern, this.mongoClient.getSettings().getServerApi());
        Crypt crypt = this.mongoClient.getCrypt();
        if (crypt != null) {
            readWriteBinding = new CryptBinding((AsyncClusterAwareReadWriteBinding)readWriteBinding, crypt);
        }
        AsyncClusterBinding asyncReadWriteBinding = readWriteBinding;
        if (session != null) {
            return new ClientSessionBinding(session.getWrapped(), ownsSession, (AsyncClusterAwareReadWriteBinding)asyncReadWriteBinding);
        }
        return asyncReadWriteBinding;
    }

    private ReadPreference getReadPreferenceForBinding(ReadPreference readPreference, @Nullable ClientSession session) {
        if (session == null) {
            return readPreference;
        }
        if (session.hasActiveTransaction()) {
            ReadPreference readPreferenceForBinding = session.getTransactionOptions().getReadPreference();
            if (readPreferenceForBinding == null) {
                throw new MongoInternalException("Invariant violated.  Transaction options read preference can not be null");
            }
            return readPreferenceForBinding;
        }
        return readPreference;
    }
}

