/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.ClientSessionOptions;
import com.mongodb.TransactionOptions;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.internal.ClientSessionPublisherImpl;
import com.mongodb.reactivestreams.client.internal.MongoClientImpl;
import com.mongodb.reactivestreams.client.internal.OperationExecutor;
import reactor.core.publisher.Mono;

public class ClientSessionHelper {
    private final MongoClientImpl mongoClient;
    private final ServerSessionPool serverSessionPool;

    public ClientSessionHelper(MongoClientImpl mongoClient, ServerSessionPool serverSessionPool) {
        this.mongoClient = mongoClient;
        this.serverSessionPool = serverSessionPool;
    }

    Mono<ClientSession> withClientSession(@Nullable ClientSession clientSessionFromOperation, OperationExecutor executor) {
        if (clientSessionFromOperation != null) {
            Assertions.isTrue((String)"ClientSession from same MongoClient", (clientSessionFromOperation.getOriginator() == this.mongoClient ? 1 : 0) != 0);
            return Mono.fromCallable(() -> clientSessionFromOperation);
        }
        return this.createClientSessionMono(ClientSessionOptions.builder().causallyConsistent(false).build(), executor);
    }

    Mono<ClientSession> createClientSessionMono(ClientSessionOptions options, OperationExecutor executor) {
        return Mono.fromCallable(() -> this.createClientSession(options, executor));
    }

    ClientSession createClientSession(ClientSessionOptions options, OperationExecutor executor) {
        ClientSessionOptions mergedOptions = ClientSessionOptions.builder((ClientSessionOptions)options).defaultTransactionOptions(TransactionOptions.merge((TransactionOptions)options.getDefaultTransactionOptions(), (TransactionOptions)TransactionOptions.builder().readConcern(this.mongoClient.getSettings().getReadConcern()).writeConcern(this.mongoClient.getSettings().getWriteConcern()).readPreference(this.mongoClient.getSettings().getReadPreference()).build())).build();
        return new ClientSessionPublisherImpl(this.serverSessionPool, this.mongoClient, mergedOptions, executor);
    }
}

