/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.operation.AsyncOperations;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.internal.BatchCursor;
import com.mongodb.reactivestreams.client.internal.BatchCursorFlux;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.function.Supplier;
import org.bson.codecs.configuration.CodecRegistry;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public abstract class BatchCursorPublisher<T>
implements Publisher<T> {
    private final ClientSession clientSession;
    private final MongoOperationPublisher<T> mongoOperationPublisher;
    private Integer batchSize;

    BatchCursorPublisher(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher) {
        this(clientSession, mongoOperationPublisher, null);
    }

    BatchCursorPublisher(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher, @Nullable Integer batchSize) {
        this.clientSession = clientSession;
        this.mongoOperationPublisher = (MongoOperationPublisher)Assertions.notNull((String)"mongoOperationPublisher", mongoOperationPublisher);
        this.batchSize = batchSize;
    }

    abstract AsyncReadOperation<AsyncBatchCursor<T>> asAsyncReadOperation(int var1);

    AsyncReadOperation<AsyncBatchCursor<T>> asAsyncFirstReadOperation() {
        return this.asAsyncReadOperation(1);
    }

    @Nullable
    ClientSession getClientSession() {
        return this.clientSession;
    }

    MongoOperationPublisher<T> getMongoOperationPublisher() {
        return this.mongoOperationPublisher;
    }

    AsyncOperations<T> getOperations() {
        return this.mongoOperationPublisher.getOperations();
    }

    MongoNamespace getNamespace() {
        return (MongoNamespace)Assertions.assertNotNull((Object)this.mongoOperationPublisher.getNamespace());
    }

    ReadPreference getReadPreference() {
        return this.mongoOperationPublisher.getReadPreference();
    }

    CodecRegistry getCodecRegistry() {
        return this.mongoOperationPublisher.getCodecRegistry();
    }

    boolean getRetryReads() {
        return this.mongoOperationPublisher.getRetryReads();
    }

    Class<T> getDocumentClass() {
        return this.mongoOperationPublisher.getDocumentClass();
    }

    @Nullable
    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Publisher<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Publisher<T> first() {
        return this.batchCursor(this::asAsyncFirstReadOperation).flatMap(batchCursor -> Mono.create(sink -> {
            batchCursor.setBatchSize(1);
            Mono.from(batchCursor.next()).doOnTerminate(batchCursor::close).doOnError(arg_0 -> ((MonoSink)sink).error(arg_0)).doOnSuccess(results -> {
                if (results == null || results.isEmpty()) {
                    sink.success();
                } else {
                    sink.success(results.get(0));
                }
            }).contextWrite(sink.contextView()).subscribe();
        }));
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        new BatchCursorFlux<T>(this).subscribe(subscriber);
    }

    public Mono<BatchCursor<T>> batchCursor(int initialBatchSize) {
        return this.batchCursor(() -> this.asAsyncReadOperation(initialBatchSize));
    }

    Mono<BatchCursor<T>> batchCursor(Supplier<AsyncReadOperation<AsyncBatchCursor<T>>> supplier) {
        return this.mongoOperationPublisher.createReadOperationMono(supplier, this.clientSession).map(BatchCursor::new);
    }
}

