/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoDriverInformation;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.internal.MongoClientImpl;
import org.bson.codecs.configuration.CodecRegistry;

public final class MongoClients {
    private static final MongoDriverInformation DEFAULT_DRIVER_INFORMATION = MongoDriverInformation.builder().driverName("mongo-java-driver-reactivestreams").driverVersion("1.13.1").build();

    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    @Deprecated
    public static MongoClient create(com.mongodb.async.client.MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(connectionString, null);
    }

    public static MongoClient create(ConnectionString connectionString, MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(com.mongodb.async.client.MongoClients.create((ConnectionString)connectionString, (MongoDriverInformation)MongoClients.getMongoDriverInformation(mongoDriverInformation)));
    }

    @Deprecated
    public static MongoClient create(com.mongodb.async.client.MongoClientSettings settings, MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(com.mongodb.async.client.MongoClients.create((com.mongodb.async.client.MongoClientSettings)settings, (MongoDriverInformation)MongoClients.getMongoDriverInformation(mongoDriverInformation)));
    }

    public static MongoClient create(MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(com.mongodb.async.client.MongoClients.create((MongoClientSettings)settings, (MongoDriverInformation)MongoClients.getMongoDriverInformation(mongoDriverInformation)));
    }

    @Deprecated
    public static MongoClient create(com.mongodb.async.client.MongoClient asyncMongoClient) {
        return new MongoClientImpl(asyncMongoClient);
    }

    public static CodecRegistry getDefaultCodecRegistry() {
        return com.mongodb.async.client.MongoClients.getDefaultCodecRegistry();
    }

    private static MongoDriverInformation getMongoDriverInformation(MongoDriverInformation mongoDriverInformation) {
        if (mongoDriverInformation == null) {
            return DEFAULT_DRIVER_INFORMATION;
        }
        return MongoDriverInformation.builder((MongoDriverInformation)mongoDriverInformation).driverName("mongo-java-driver-reactivestreams").driverVersion("1.13.1").build();
    }

    private MongoClients() {
    }
}

