/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.Block;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.Observables;
import com.mongodb.async.client.gridfs.AsyncOutputStream;
import com.mongodb.reactivestreams.client.Success;
import com.mongodb.reactivestreams.client.gridfs.AsyncInputStream;
import com.mongodb.reactivestreams.client.internal.ObservableToPublisher;
import com.mongodb.reactivestreams.client.internal.PublisherHelper;
import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class GridFSAsyncStreamHelper {
    public static AsyncInputStream toAsyncInputStream(final com.mongodb.async.client.gridfs.AsyncInputStream wrapper) {
        Assertions.notNull((String)"wrapper", (Object)wrapper);
        return new AsyncInputStream(){

            @Override
            public Publisher<Integer> read(final ByteBuffer dst) {
                return new ObservableToPublisher<Integer>(Observables.observe((Block)new Block<SingleResultCallback<Integer>>(){

                    public void apply(SingleResultCallback<Integer> callback) {
                        wrapper.read(dst, callback);
                    }
                }));
            }

            @Override
            public Publisher<Long> skip(final long bytesToSkip) {
                return new ObservableToPublisher<Long>(Observables.observe((Block)new Block<SingleResultCallback<Long>>(){

                    public void apply(SingleResultCallback<Long> callback) {
                        wrapper.skip(bytesToSkip, callback);
                    }
                }));
            }

            @Override
            public Publisher<Success> close() {
                return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

                    public void apply(SingleResultCallback<Success> callback) {
                        wrapper.close(PublisherHelper.voidToSuccessCallback(callback));
                    }
                }));
            }
        };
    }

    public static com.mongodb.reactivestreams.client.gridfs.AsyncOutputStream toAsyncOutputStream(final AsyncOutputStream wrapper) {
        Assertions.notNull((String)"wrapper", (Object)wrapper);
        return new com.mongodb.reactivestreams.client.gridfs.AsyncOutputStream(){

            @Override
            public Publisher<Integer> write(final ByteBuffer src) {
                return new ObservableToPublisher<Integer>(Observables.observe((Block)new Block<SingleResultCallback<Integer>>(){

                    public void apply(SingleResultCallback<Integer> callback) {
                        wrapper.write(src, callback);
                    }
                }));
            }

            @Override
            public Publisher<Success> close() {
                return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

                    public void apply(SingleResultCallback<Success> callback) {
                        wrapper.close(PublisherHelper.voidToSuccessCallback(callback));
                    }
                }));
            }
        };
    }

    static com.mongodb.async.client.gridfs.AsyncInputStream toCallbackAsyncInputStream(final AsyncInputStream wrapped) {
        Assertions.notNull((String)"wrapped", (Object)wrapped);
        return new com.mongodb.async.client.gridfs.AsyncInputStream(){

            public void read(ByteBuffer dst, final SingleResultCallback<Integer> callback) {
                wrapped.read(dst).subscribe((Subscriber)new Subscriber<Integer>(){
                    private Integer result = null;

                    public void onSubscribe(Subscription s) {
                        s.request(1L);
                    }

                    public void onNext(Integer integer) {
                        this.result = integer;
                    }

                    public void onError(Throwable t) {
                        callback.onResult(null, t);
                    }

                    public void onComplete() {
                        callback.onResult((Object)this.result, null);
                    }
                });
            }

            public void skip(long bytesToSkip, final SingleResultCallback<Long> callback) {
                wrapped.skip(bytesToSkip).subscribe((Subscriber)new Subscriber<Long>(){
                    private Long result = null;

                    public void onSubscribe(Subscription s) {
                        s.request(1L);
                    }

                    public void onNext(Long skipped) {
                        this.result = skipped;
                    }

                    public void onError(Throwable t) {
                        callback.onResult(null, t);
                    }

                    public void onComplete() {
                        callback.onResult((Object)this.result, null);
                    }
                });
            }

            public void close(final SingleResultCallback<Void> callback) {
                wrapped.close().subscribe((Subscriber)new Subscriber<Success>(){

                    public void onSubscribe(Subscription s) {
                        s.request(1L);
                    }

                    public void onNext(Success success) {
                    }

                    public void onError(Throwable t) {
                        callback.onResult(null, t);
                    }

                    public void onComplete() {
                        callback.onResult(null, null);
                    }
                });
            }
        };
    }

    static AsyncOutputStream toCallbackAsyncOutputStream(final com.mongodb.reactivestreams.client.gridfs.AsyncOutputStream wrapped) {
        Assertions.notNull((String)"wrapped", (Object)wrapped);
        return new AsyncOutputStream(){

            public void write(ByteBuffer src, final SingleResultCallback<Integer> callback) {
                wrapped.write(src).subscribe((Subscriber)new Subscriber<Integer>(){
                    private Integer result = null;

                    public void onSubscribe(Subscription s) {
                        s.request(1L);
                    }

                    public void onNext(Integer integer) {
                        this.result = integer;
                    }

                    public void onError(Throwable t) {
                        callback.onResult(null, t);
                    }

                    public void onComplete() {
                        callback.onResult((Object)this.result, null);
                    }
                });
            }

            public void close(final SingleResultCallback<Void> callback) {
                wrapped.close().subscribe((Subscriber)new Subscriber<Success>(){

                    public void onSubscribe(Subscription s) {
                        s.request(1L);
                    }

                    public void onNext(Success success) {
                    }

                    public void onError(Throwable t) {
                        callback.onResult(null, t);
                    }

                    public void onComplete() {
                        callback.onResult(null, null);
                    }
                });
            }
        };
    }

    private GridFSAsyncStreamHelper() {
    }
}

