/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ConnectionString;
import com.mongodb.DB;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoDriverInformation;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.WriteConcern;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.internal.MongoClientImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.connection.BufferProvider;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.SingleServerBinding;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.internal.connection.ServerAddressHelper;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.internal.thread.DaemonThreadFactory;
import com.mongodb.lang.Nullable;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class MongoClient
implements Closeable {
    private final ConcurrentMap<String, DB> dbCache = new ConcurrentHashMap<String, DB>();
    private final MongoClientOptions options;
    private final BufferProvider bufferProvider = new PowerOfTwoBufferPool();
    private final ConcurrentLinkedQueue<ServerCursorAndNamespace> orphanedCursors = new ConcurrentLinkedQueue();
    private final ExecutorService cursorCleaningService;
    private final MongoClientImpl delegate;

    public static CodecRegistry getDefaultCodecRegistry() {
        return MongoClientSettings.getDefaultCodecRegistry();
    }

    public MongoClient() {
        this(new ConnectionString("mongodb://127.0.0.1"));
    }

    public MongoClient(String connectionString) {
        this(connectionString.contains("://") ? new ConnectionString(connectionString) : new ConnectionString("mongodb://" + connectionString));
    }

    public MongoClient(ConnectionString connectionString) {
        this(connectionString, null);
    }

    public MongoClient(ConnectionString connectionString, @Nullable MongoDriverInformation mongoDriverInformation) {
        this(MongoClientSettings.builder().applyConnectionString(connectionString).build(), mongoDriverInformation);
    }

    public MongoClient(MongoClientSettings settings) {
        this(settings, null);
    }

    public MongoClient(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        this(settings, null, mongoDriverInformation);
    }

    private MongoClient(MongoClientSettings settings, @Nullable MongoClientOptions options, @Nullable MongoDriverInformation mongoDriverInformation) {
        this.delegate = new MongoClientImpl(settings, MongoClient.wrapMongoDriverInformation(mongoDriverInformation));
        this.options = options != null ? options : MongoClientOptions.builder(settings).build();
        this.cursorCleaningService = this.options.isCursorFinalizerEnabled() ? this.createCursorCleaningService() : null;
    }

    private static MongoDriverInformation wrapMongoDriverInformation(@Nullable MongoDriverInformation mongoDriverInformation) {
        return (mongoDriverInformation == null ? MongoDriverInformation.builder() : MongoDriverInformation.builder((MongoDriverInformation)mongoDriverInformation)).driverName("legacy").build();
    }

    public MongoClient(String host, MongoClientOptions options) {
        this(ServerAddressHelper.createServerAddress((String)host), options);
    }

    public MongoClient(String host, int port) {
        this(ServerAddressHelper.createServerAddress((String)host, (int)port));
    }

    public MongoClient(ServerAddress addr) {
        this(addr, MongoClientOptions.builder().build());
    }

    public MongoClient(ServerAddress addr, MongoClientOptions options) {
        this(addr, null, options);
    }

    public MongoClient(ServerAddress addr, @Nullable MongoCredential credential, MongoClientOptions options) {
        this(addr, credential, options, null);
    }

    public MongoClient(List<ServerAddress> seeds) {
        this(seeds, MongoClientOptions.builder().build());
    }

    public MongoClient(List<ServerAddress> seeds, MongoClientOptions options) {
        this(seeds, null, options);
    }

    public MongoClient(List<ServerAddress> seeds, @Nullable MongoCredential credential, MongoClientOptions options) {
        this(seeds, credential, options, null);
    }

    public MongoClient(MongoClientURI uri) {
        this(uri, null);
    }

    public MongoClient(MongoClientURI uri, @Nullable MongoDriverInformation mongoDriverInformation) {
        this(uri.getOptions().asMongoClientSettings(uri.getProxied().isSrvProtocol() ? null : uri.getProxied().getHosts().stream().map(ServerAddress::new).collect(Collectors.toList()), uri.getProxied().isSrvProtocol() ? (String)uri.getProxied().getHosts().get(0) : null, MongoClient.getClusterConnectionMode(uri.getProxied()), uri.getCredentials()), uri.getOptions(), mongoDriverInformation);
    }

    private static ClusterConnectionMode getClusterConnectionMode(ConnectionString connectionString) {
        return ClusterSettings.builder().applyConnectionString(connectionString).build().getMode();
    }

    public MongoClient(ServerAddress addr, @Nullable MongoCredential credential, MongoClientOptions options, @Nullable MongoDriverInformation mongoDriverInformation) {
        this(options.asMongoClientSettings(Collections.singletonList(addr), null, ClusterConnectionMode.SINGLE, credential), options, mongoDriverInformation);
    }

    public MongoClient(List<ServerAddress> seeds, @Nullable MongoCredential credential, MongoClientOptions options, @Nullable MongoDriverInformation mongoDriverInformation) {
        this(options.asMongoClientSettings(seeds, null, ClusterConnectionMode.MULTIPLE, credential), options, mongoDriverInformation);
    }

    public MongoClientOptions getMongoClientOptions() {
        return this.options;
    }

    @Nullable
    public MongoCredential getCredential() {
        return this.delegate.getSettings().getCredential();
    }

    public MongoIterable<String> listDatabaseNames() {
        return this.delegate.listDatabaseNames();
    }

    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        return this.delegate.listDatabaseNames(clientSession);
    }

    public ListDatabasesIterable<Document> listDatabases() {
        return this.delegate.listDatabases();
    }

    public <T> ListDatabasesIterable<T> listDatabases(Class<T> clazz) {
        return this.delegate.listDatabases(clazz);
    }

    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.delegate.listDatabases(clientSession);
    }

    public <T> ListDatabasesIterable<T> listDatabases(ClientSession clientSession, Class<T> clazz) {
        return this.delegate.listDatabases(clientSession, clazz);
    }

    public MongoDatabase getDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    public ClientSession startSession() {
        return this.delegate.startSession();
    }

    public ClientSession startSession(ClientSessionOptions options) {
        return this.delegate.startSession(options);
    }

    public ChangeStreamIterable<Document> watch() {
        return this.delegate.watch();
    }

    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.delegate.watch(resultClass);
    }

    public ChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
        return this.delegate.watch(pipeline);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.delegate.watch(pipeline, resultClass);
    }

    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.delegate.watch(clientSession);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.delegate.watch(clientSession, resultClass);
    }

    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.delegate.watch(clientSession, pipeline);
    }

    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.delegate.watch(clientSession, pipeline, resultClass);
    }

    public ClusterDescription getClusterDescription() {
        return this.delegate.getClusterDescription();
    }

    public WriteConcern getWriteConcern() {
        return this.options.getWriteConcern();
    }

    public ReadConcern getReadConcern() {
        return this.options.getReadConcern();
    }

    public ReadPreference getReadPreference() {
        return this.options.getReadPreference();
    }

    @Deprecated
    public DB getDB(String dbName) {
        DB db = (DB)this.dbCache.get(dbName);
        if (db != null) {
            return db;
        }
        db = new DB(this, dbName, this.getOperationExecutor());
        DB temp = this.dbCache.putIfAbsent(dbName, db);
        if (temp != null) {
            return temp;
        }
        return db;
    }

    public void dropDatabase(String dbName) {
        this.getDB(dbName).dropDatabase();
    }

    @Override
    public void close() {
        this.delegate.close();
        if (this.cursorCleaningService != null) {
            this.cursorCleaningService.shutdownNow();
        }
    }

    public String toString() {
        return "MongoClient{options=" + this.options + '}';
    }

    Cluster getCluster() {
        return this.delegate.getCluster();
    }

    CodecRegistry getCodecRegistry() {
        return this.delegate.getCodecRegistry();
    }

    ServerSessionPool getServerSessionPool() {
        return this.delegate.getServerSessionPool();
    }

    BufferProvider getBufferProvider() {
        return this.bufferProvider;
    }

    @Nullable
    ExecutorService getCursorCleaningService() {
        return this.cursorCleaningService;
    }

    void addOrphanedCursor(ServerCursor serverCursor, MongoNamespace namespace) {
        this.orphanedCursors.add(new ServerCursorAndNamespace(serverCursor, namespace));
    }

    OperationExecutor getOperationExecutor() {
        return this.delegate.getOperationExecutor();
    }

    MongoClientImpl getDelegate() {
        return this.delegate;
    }

    private ExecutorService createCursorCleaningService() {
        ScheduledExecutorService newTimer = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("CleanCursors"));
        newTimer.scheduleAtFixedRate(this::cleanCursors, 1L, 1L, TimeUnit.SECONDS);
        return newTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCursors() {
        ServerCursorAndNamespace cur;
        while ((cur = this.orphanedCursors.poll()) != null) {
            SingleServerBinding binding = new SingleServerBinding(this.delegate.getCluster(), cur.serverCursor.getAddress());
            try {
                ConnectionSource source = binding.getReadConnectionSource();
                try {
                    Connection connection = source.getConnection();
                    try {
                        connection.killCursor(cur.namespace, Collections.singletonList(cur.serverCursor.getId()));
                    }
                    finally {
                        connection.release();
                    }
                }
                finally {
                    source.release();
                }
            }
            finally {
                binding.release();
            }
        }
    }

    private static class ServerCursorAndNamespace {
        private final ServerCursor serverCursor;
        private final MongoNamespace namespace;

        ServerCursorAndNamespace(ServerCursor serverCursor, MongoNamespace namespace) {
            this.serverCursor = serverCursor;
            this.namespace = namespace;
        }
    }
}

