/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kotlin.client;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoDriverInformation;
import com.mongodb.client.MongoClients;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.kotlin.client.MongoCluster;
import java.io.Closeable;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/mongodb/kotlin/client/MongoClient;", "Lcom/mongodb/kotlin/client/MongoCluster;", "Ljava/io/Closeable;", "wrapped", "Lcom/mongodb/client/MongoClient;", "(Lcom/mongodb/client/MongoClient;)V", "clusterDescription", "Lcom/mongodb/connection/ClusterDescription;", "getClusterDescription", "()Lcom/mongodb/connection/ClusterDescription;", "close", "", "Factory", "mongodb-driver-kotlin-sync"})
public final class MongoClient
extends MongoCluster
implements Closeable {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final com.mongodb.client.MongoClient wrapped;

    public MongoClient(@NotNull com.mongodb.client.MongoClient wrapped) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        super((com.mongodb.client.MongoCluster)wrapped);
        this.wrapped = wrapped;
    }

    @Override
    public void close() {
        this.wrapped.close();
    }

    @NotNull
    public final ClusterDescription getClusterDescription() {
        ClusterDescription clusterDescription = this.wrapped.getClusterDescription();
        Intrinsics.checkNotNullExpressionValue((Object)clusterDescription, (String)"wrapped.clusterDescription");
        return clusterDescription;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/mongodb/kotlin/client/MongoClient$Factory;", "", "()V", "create", "Lcom/mongodb/kotlin/client/MongoClient;", "connectionString", "Lcom/mongodb/ConnectionString;", "mongoDriverInformation", "Lcom/mongodb/MongoDriverInformation;", "settings", "Lcom/mongodb/MongoClientSettings;", "", "mongodb-driver-kotlin-sync"})
    public static final class Factory {
        private Factory() {
        }

        @NotNull
        public final MongoClient create(@NotNull String connectionString) {
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            return com.mongodb.kotlin.client.MongoClient$Factory.create$default(this, new ConnectionString(connectionString), null, 2, null);
        }

        @NotNull
        public final MongoClient create(@NotNull ConnectionString connectionString, @Nullable MongoDriverInformation mongoDriverInformation) {
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
            Intrinsics.checkNotNullExpressionValue((Object)mongoClientSettings, (String)"builder().applyConnectio\u2026connectionString).build()");
            return this.create(mongoClientSettings, mongoDriverInformation);
        }

        public static /* synthetic */ MongoClient create$default(Factory factory, ConnectionString connectionString, MongoDriverInformation mongoDriverInformation, int n, Object object) {
            if ((n & 1) != 0) {
                connectionString = new ConnectionString("mongodb://localhost");
            }
            if ((n & 2) != 0) {
                mongoDriverInformation = null;
            }
            return factory.create(connectionString, mongoDriverInformation);
        }

        @NotNull
        public final MongoClient create(@NotNull MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            MongoDriverInformation.Builder builder = mongoDriverInformation == null ? MongoDriverInformation.builder() : MongoDriverInformation.builder((MongoDriverInformation)mongoDriverInformation);
            com.mongodb.client.MongoClient mongoClient = MongoClients.create((MongoClientSettings)settings, (MongoDriverInformation)builder.driverName("kotlin").driverPlatform("kotlin/" + KotlinVersion.CURRENT).build());
            Intrinsics.checkNotNullExpressionValue((Object)mongoClient, (String)"create(\n                \u2026rsion.CURRENT}\").build())");
            return new MongoClient(mongoClient);
        }

        public static /* synthetic */ MongoClient create$default(Factory factory, MongoClientSettings mongoClientSettings, MongoDriverInformation mongoDriverInformation, int n, Object object) {
            if ((n & 2) != 0) {
                mongoDriverInformation = null;
            }
            return factory.create(mongoClientSettings, mongoDriverInformation);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

