/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.time;

import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.function.CheckedFunction;
import com.mongodb.internal.function.CheckedSupplier;
import com.mongodb.internal.time.StartTime;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Immutable
class TimePoint
implements Comparable<TimePoint>,
StartTime,
Timeout {
    @Nullable
    private final Long nanos;

    TimePoint(@Nullable Long nanos) {
        this.nanos = nanos;
    }

    static TimePoint at(@Nullable Long nanos) {
        return new TimePoint(nanos);
    }

    long currentNanos() {
        return System.nanoTime();
    }

    static TimePoint now() {
        return TimePoint.at(System.nanoTime());
    }

    static TimePoint infinite() {
        return TimePoint.at(null);
    }

    @Override
    public Timeout shortenBy(long amount, TimeUnit timeUnit) {
        if (this.isInfinite()) {
            return this;
        }
        long durationNanos = TimeUnit.NANOSECONDS.convert(amount, timeUnit);
        return TimePoint.at(Assertions.assertNotNull(this.nanos) - durationNanos);
    }

    @Override
    public <T, E extends Exception> T checkedCall(TimeUnit timeUnit, CheckedSupplier<T, E> onInfinite, CheckedFunction<Long, T, E> onHasRemaining, CheckedSupplier<T, E> onExpired) throws E {
        if (this.isInfinite()) {
            return onInfinite.get();
        }
        long remaining = this.remaining(timeUnit);
        if (remaining <= 0L) {
            return onExpired.get();
        }
        return onHasRemaining.apply(remaining);
    }

    private boolean isInfinite() {
        return this.nanos == null;
    }

    @Override
    public Timeout asTimeout() {
        return this;
    }

    private long remaining(TimeUnit unit) {
        if (this.isInfinite()) {
            throw new AssertionError((Object)"Infinite TimePoints have infinite remaining time");
        }
        long remaining = Assertions.assertNotNull(this.nanos) - this.currentNanos();
        return (remaining = unit.convert(remaining, TimeUnit.NANOSECONDS)) <= 0L ? 0L : remaining;
    }

    @Override
    public Duration elapsed() {
        if (this.isInfinite()) {
            throw new AssertionError((Object)"No time can elapse since an infinite TimePoint");
        }
        return Duration.ofNanos(this.currentNanos() - Assertions.assertNotNull(this.nanos));
    }

    Duration durationSince(TimePoint t) {
        if (this.isInfinite()) {
            throw new AssertionError((Object)"this timepoint is infinite, with no duration since");
        }
        if (t.isInfinite()) {
            throw new AssertionError((Object)"the other timepoint is infinite, with no duration until");
        }
        return Duration.ofNanos(this.nanos - Assertions.assertNotNull(t.nanos));
    }

    @Override
    public TimePoint timeoutAfterOrInfiniteIfNegative(long timeoutValue, TimeUnit timeUnit) {
        if (timeoutValue < 0L) {
            return TimePoint.infinite();
        }
        return this.add(Duration.ofNanos(TimeUnit.NANOSECONDS.convert(timeoutValue, timeUnit)));
    }

    TimePoint add(Duration duration) {
        if (this.isInfinite()) {
            throw new AssertionError((Object)"No time can be added to an infinite TimePoint");
        }
        long durationNanos = duration.toNanos();
        return TimePoint.at(Assertions.assertNotNull(this.nanos) + durationNanos);
    }

    @Override
    public int compareTo(TimePoint t) {
        if (Objects.equals(this.nanos, t.nanos)) {
            return 0;
        }
        if (this.isInfinite()) {
            return 1;
        }
        if (t.isInfinite()) {
            return -1;
        }
        return Long.signum(this.nanos - Assertions.assertNotNull(t.nanos));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimePoint timePoint = (TimePoint)o;
        return Objects.equals(this.nanos, timePoint.nanos);
    }

    public int hashCode() {
        return Objects.hash(this.nanos);
    }

    public String toString() {
        String remainingMs = this.isInfinite() ? "infinite" : "" + TimeUnit.MILLISECONDS.convert(this.currentNanos() - Assertions.assertNotNull(this.nanos), TimeUnit.NANOSECONDS);
        return "TimePoint{nanos=" + this.nanos + "remainingMs=" + remainingMs + '}';
    }
}

