/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection.tlschannel.async;

import com.mongodb.internal.connection.tlschannel.TlsChannel;
import com.mongodb.internal.connection.tlschannel.async.AsynchronousTlsChannelGroup;
import com.mongodb.internal.connection.tlschannel.async.ExtendedAsynchronousByteChannel;
import com.mongodb.internal.connection.tlschannel.impl.ByteBufferSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class AsynchronousTlsChannel
implements ExtendedAsynchronousByteChannel {
    private final AsynchronousTlsChannelGroup group;
    private final TlsChannel tlsChannel;
    private final AsynchronousTlsChannelGroup.RegisteredSocket registeredSocket;

    public AsynchronousTlsChannel(AsynchronousTlsChannelGroup channelGroup, TlsChannel tlsChannel, SocketChannel socketChannel) throws ClosedChannelException, IllegalArgumentException {
        if (!tlsChannel.isOpen() || !socketChannel.isOpen()) {
            throw new ClosedChannelException();
        }
        if (socketChannel.isBlocking()) {
            throw new IllegalArgumentException("socket channel must be in non-blocking mode");
        }
        this.group = channelGroup;
        this.tlsChannel = tlsChannel;
        this.registeredSocket = channelGroup.registerSocket(tlsChannel, socketChannel);
    }

    @Override
    public <A> void read(ByteBuffer dst, A attach, CompletionHandler<Integer, ? super A> handler) {
        this.checkReadOnly(dst);
        if (!dst.hasRemaining()) {
            this.completeWithZeroInt(attach, handler);
            return;
        }
        this.group.startRead(this.registeredSocket, new ByteBufferSet(dst), 0L, TimeUnit.MILLISECONDS, c -> this.group.executor.submit(() -> handler.completed((int)c, (Object)attach)), e -> this.group.executor.submit(() -> handler.failed((Throwable)e, (Object)attach)));
    }

    @Override
    public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attach, CompletionHandler<Integer, ? super A> handler) {
        this.checkReadOnly(dst);
        if (!dst.hasRemaining()) {
            this.completeWithZeroInt(attach, handler);
            return;
        }
        this.group.startRead(this.registeredSocket, new ByteBufferSet(dst), timeout, unit, c -> this.group.executor.submit(() -> handler.completed((int)c, (Object)attach)), e -> this.group.executor.submit(() -> handler.failed((Throwable)e, (Object)attach)));
    }

    @Override
    public <A> void read(ByteBuffer[] dsts, int offset, int length, long timeout, TimeUnit unit, A attach, CompletionHandler<Long, ? super A> handler) {
        ByteBufferSet bufferSet = new ByteBufferSet(dsts, offset, length);
        if (bufferSet.isReadOnly()) {
            throw new IllegalArgumentException("buffer is read-only");
        }
        if (!bufferSet.hasRemaining()) {
            this.completeWithZeroLong(attach, handler);
            return;
        }
        this.group.startRead(this.registeredSocket, bufferSet, timeout, unit, c -> this.group.executor.submit(() -> handler.completed(c, (Object)attach)), e -> this.group.executor.submit(() -> handler.failed((Throwable)e, (Object)attach)));
    }

    @Override
    public Future<Integer> read(ByteBuffer dst) {
        AsynchronousTlsChannelGroup.ReadOperation op;
        this.checkReadOnly(dst);
        if (!dst.hasRemaining()) {
            return CompletableFuture.completedFuture(0);
        }
        FutureReadResult future = new FutureReadResult();
        future.op = op = this.group.startRead(this.registeredSocket, new ByteBufferSet(dst), 0L, TimeUnit.MILLISECONDS, c -> future.complete((int)c), future::completeExceptionally);
        return future;
    }

    private void checkReadOnly(ByteBuffer dst) {
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("buffer is read-only");
        }
    }

    @Override
    public <A> void write(ByteBuffer src, A attach, CompletionHandler<Integer, ? super A> handler) {
        if (!src.hasRemaining()) {
            this.completeWithZeroInt(attach, handler);
            return;
        }
        this.group.startWrite(this.registeredSocket, new ByteBufferSet(src), 0L, TimeUnit.MILLISECONDS, c -> this.group.executor.submit(() -> handler.completed((int)c, (Object)attach)), e -> this.group.executor.submit(() -> handler.failed((Throwable)e, (Object)attach)));
    }

    @Override
    public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attach, CompletionHandler<Integer, ? super A> handler) {
        if (!src.hasRemaining()) {
            this.completeWithZeroInt(attach, handler);
            return;
        }
        this.group.startWrite(this.registeredSocket, new ByteBufferSet(src), timeout, unit, c -> this.group.executor.submit(() -> handler.completed((int)c, (Object)attach)), e -> this.group.executor.submit(() -> handler.failed((Throwable)e, (Object)attach)));
    }

    @Override
    public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attach, CompletionHandler<Long, ? super A> handler) {
        ByteBufferSet bufferSet = new ByteBufferSet(srcs, offset, length);
        if (!bufferSet.hasRemaining()) {
            this.completeWithZeroLong(attach, handler);
            return;
        }
        this.group.startWrite(this.registeredSocket, bufferSet, timeout, unit, c -> this.group.executor.submit(() -> handler.completed(c, (Object)attach)), e -> this.group.executor.submit(() -> handler.failed((Throwable)e, (Object)attach)));
    }

    @Override
    public Future<Integer> write(ByteBuffer src) {
        AsynchronousTlsChannelGroup.WriteOperation op;
        if (!src.hasRemaining()) {
            return CompletableFuture.completedFuture(0);
        }
        FutureWriteResult future = new FutureWriteResult();
        future.op = op = this.group.startWrite(this.registeredSocket, new ByteBufferSet(src), 0L, TimeUnit.MILLISECONDS, c -> future.complete((int)c), future::completeExceptionally);
        return future;
    }

    private <A> void completeWithZeroInt(A attach, CompletionHandler<Integer, ? super A> handler) {
        this.group.executor.submit(() -> handler.completed(0, (Object)attach));
    }

    private <A> void completeWithZeroLong(A attach, CompletionHandler<Long, ? super A> handler) {
        this.group.executor.submit(() -> handler.completed(0L, (Object)attach));
    }

    @Override
    public boolean isOpen() {
        return this.tlsChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.tlsChannel.close();
        this.registeredSocket.close();
    }

    private class FutureReadResult
    extends CompletableFuture<Integer> {
        AsynchronousTlsChannelGroup.ReadOperation op;

        private FutureReadResult() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            super.cancel(mayInterruptIfRunning);
            return AsynchronousTlsChannel.this.group.doCancelRead(AsynchronousTlsChannel.this.registeredSocket, this.op);
        }
    }

    private class FutureWriteResult
    extends CompletableFuture<Integer> {
        AsynchronousTlsChannelGroup.WriteOperation op;

        private FutureWriteResult() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            super.cancel(mayInterruptIfRunning);
            return AsynchronousTlsChannel.this.group.doCancelWrite(AsynchronousTlsChannel.this.registeredSocket, this.op);
        }
    }
}

