/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.annotations.Beta;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.MongoTimeUnit;
import com.mongodb.client.model.Window;
import com.mongodb.client.model.WindowedComputation;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.assertions.Assertions;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@Beta
public final class WindowedComputations {
    public static WindowedComputation of(BsonField windowedComputation) {
        return new BsonFieldWindowedComputation((BsonField)Assertions.notNull((String)"windowedComputation", (Object)windowedComputation));
    }

    public static <TExpression> WindowedComputation sum(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        return WindowedComputations.simpleParameterWindowFunction(path, "$sum", expression, window);
    }

    public static <TExpression> WindowedComputation avg(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        return WindowedComputations.simpleParameterWindowFunction(path, "$avg", expression, window);
    }

    public static <TExpression> WindowedComputation stdDevSamp(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        return WindowedComputations.simpleParameterWindowFunction(path, "$stdDevSamp", expression, window);
    }

    public static <TExpression> WindowedComputation stdDevPop(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        return WindowedComputations.simpleParameterWindowFunction(path, "$stdDevPop", expression, window);
    }

    public static <TExpression> WindowedComputation min(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        return WindowedComputations.simpleParameterWindowFunction(path, "$min", expression, window);
    }

    public static <TExpression> WindowedComputation max(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        return WindowedComputations.simpleParameterWindowFunction(path, "$max", expression, window);
    }

    public static WindowedComputation count(String path, @Nullable Window window) {
        Assertions.notNull((String)"path", (Object)path);
        return WindowedComputations.simpleParameterWindowFunction(path, "$count", null, window);
    }

    public static <TExpression> WindowedComputation derivative(String path, TExpression expression, Window window) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        Assertions.notNull((String)"window", (Object)window);
        HashMap<ParamName, Object> args = new HashMap<ParamName, Object>(1);
        args.put(ParamName.INPUT, expression);
        return WindowedComputations.compoundParameterWindowFunction(path, "$derivative", args, window);
    }

    public static <TExpression> WindowedComputation timeDerivative(String path, TExpression expression, Window window, MongoTimeUnit unit) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        Assertions.notNull((String)"window", (Object)window);
        Assertions.notNull((String)"unit", (Object)((Object)unit));
        com.mongodb.assertions.Assertions.isTrueArgument("unit must be either of WEEK, DAY, HOUR, MINUTE, SECOND, MILLISECOND", unit.fixed());
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(2);
        args.put(ParamName.INPUT, expression);
        args.put(ParamName.UNIT, unit.value());
        return WindowedComputations.compoundParameterWindowFunction(path, "$derivative", args, window);
    }

    public static <TExpression> WindowedComputation integral(String path, TExpression expression, Window window) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        Assertions.notNull((String)"window", (Object)window);
        HashMap<ParamName, Object> args = new HashMap<ParamName, Object>(1);
        args.put(ParamName.INPUT, expression);
        return WindowedComputations.compoundParameterWindowFunction(path, "$integral", args, window);
    }

    public static <TExpression> WindowedComputation timeIntegral(String path, TExpression expression, Window window, MongoTimeUnit unit) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        Assertions.notNull((String)"window", (Object)window);
        Assertions.notNull((String)"unit", (Object)((Object)unit));
        com.mongodb.assertions.Assertions.isTrueArgument("unit must be either of WEEK, DAY, HOUR, MINUTE, SECOND, MILLISECOND", unit.fixed());
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(2);
        args.put(ParamName.INPUT, expression);
        args.put(ParamName.UNIT, unit.value());
        return WindowedComputations.compoundParameterWindowFunction(path, "$integral", args, window);
    }

    public static <TExpression> WindowedComputation covarianceSamp(String path, TExpression expression1, TExpression expression2, @Nullable Window window) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression1", expression1);
        Assertions.notNull((String)"expression2", expression2);
        ArrayList<TExpression> expressions = new ArrayList<TExpression>(2);
        expressions.add(expression1);
        expressions.add(expression2);
        return WindowedComputations.simpleParameterWindowFunction(path, "$covarianceSamp", expressions, window);
    }

    public static <TExpression> WindowedComputation covariancePop(String path, TExpression expression1, TExpression expression2, @Nullable Window window) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression1", expression1);
        Assertions.notNull((String)"expression2", expression2);
        ArrayList<TExpression> expressions = new ArrayList<TExpression>(2);
        expressions.add(expression1);
        expressions.add(expression2);
        return WindowedComputations.simpleParameterWindowFunction(path, "$covariancePop", expressions, window);
    }

    public static <TExpression> WindowedComputation expMovingAvg(String path, TExpression expression, int n) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        com.mongodb.assertions.Assertions.isTrueArgument("n > 0", n > 0);
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(2);
        args.put(ParamName.INPUT, expression);
        args.put(ParamName.N, n);
        return WindowedComputations.compoundParameterWindowFunction(path, "$expMovingAvg", args, null);
    }

    public static <TExpression> WindowedComputation expMovingAvg(String path, TExpression expression, double alpha) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        com.mongodb.assertions.Assertions.isTrueArgument("alpha > 0", alpha > 0.0);
        com.mongodb.assertions.Assertions.isTrueArgument("alpha < 1", alpha < 1.0);
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(2);
        args.put(ParamName.INPUT, expression);
        args.put(ParamName.ALPHA, alpha);
        return WindowedComputations.compoundParameterWindowFunction(path, "$expMovingAvg", args, null);
    }

    public static <TExpression> WindowedComputation push(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        return WindowedComputations.simpleParameterWindowFunction(path, "$push", expression, window);
    }

    public static <TExpression> WindowedComputation addToSet(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        return WindowedComputations.simpleParameterWindowFunction(path, "$addToSet", expression, window);
    }

    public static <TExpression> WindowedComputation first(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        return WindowedComputations.simpleParameterWindowFunction(path, "$first", expression, window);
    }

    public static <TExpression> WindowedComputation last(String path, TExpression expression, @Nullable Window window) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        return WindowedComputations.simpleParameterWindowFunction(path, "$last", expression, window);
    }

    public static <TExpression> WindowedComputation shift(String path, TExpression expression, @Nullable TExpression defaultExpression, int by) {
        Assertions.notNull((String)"path", (Object)path);
        Assertions.notNull((String)"expression", expression);
        LinkedHashMap<ParamName, Object> args = new LinkedHashMap<ParamName, Object>(3);
        args.put(ParamName.OUTPUT, expression);
        args.put(ParamName.BY, by);
        if (defaultExpression != null) {
            args.put(ParamName.DEFAULT, defaultExpression);
        }
        return WindowedComputations.compoundParameterWindowFunction(path, "$shift", args, null);
    }

    public static WindowedComputation documentNumber(String path) {
        Assertions.notNull((String)"path", (Object)path);
        return WindowedComputations.simpleParameterWindowFunction(path, "$documentNumber", null, null);
    }

    public static WindowedComputation rank(String path) {
        Assertions.notNull((String)"path", (Object)path);
        return WindowedComputations.simpleParameterWindowFunction(path, "$rank", null, null);
    }

    public static WindowedComputation denseRank(String path) {
        Assertions.notNull((String)"path", (Object)path);
        return WindowedComputations.simpleParameterWindowFunction(path, "$denseRank", null, null);
    }

    private static WindowedComputation simpleParameterWindowFunction(String path, String functionName, @Nullable Object expression, @Nullable Window window) {
        return new BsonFieldWindowedComputation(new BsonField(path, new SimpleParameterFunctionAndWindow(functionName, expression, window)));
    }

    private static WindowedComputation compoundParameterWindowFunction(String path, String functionName, Map<ParamName, Object> args, @Nullable Window window) {
        return new BsonFieldWindowedComputation(new BsonField(path, new CompoundParameterFunctionAndWindow(functionName, args, window)));
    }

    private WindowedComputations() {
        throw new UnsupportedOperationException();
    }

    private static enum ParamName {
        INPUT("input"),
        UNIT("unit"),
        N("N"),
        ALPHA("alpha"),
        OUTPUT("output"),
        BY("by"),
        DEFAULT("default");

        private final String value;

        private ParamName(String value) {
            this.value = value;
        }

        String value() {
            return this.value;
        }
    }

    private static final class CompoundParameterFunctionAndWindow
    extends AbstractFunctionAndWindow {
        private final Map<ParamName, Object> args;

        CompoundParameterFunctionAndWindow(String functionName, Map<ParamName, Object> args, @Nullable Window window) {
            super(functionName, window);
            this.args = args;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.functionName());
            writer.writeStartDocument();
            this.args.forEach((paramName, paramValue) -> {
                writer.writeName(paramName.value());
                BuildersHelper.encodeValue(writer, paramValue, codecRegistry);
            });
            writer.writeEndDocument();
            this.writeWindow(codecRegistry, writer);
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompoundParameterFunctionAndWindow that = (CompoundParameterFunctionAndWindow)o;
            return this.functionName().equals(that.functionName()) && Objects.equals(this.args, that.args) && this.window().equals(that.window());
        }

        public int hashCode() {
            return Objects.hash(this.functionName(), this.args, this.window());
        }

        public String toString() {
            return "WindowFunction{name='" + this.functionName() + '\'' + ", args=" + this.args + ", window=" + this.window() + '}';
        }
    }

    private static final class SimpleParameterFunctionAndWindow
    extends AbstractFunctionAndWindow {
        @Nullable
        private final Object expression;

        SimpleParameterFunctionAndWindow(String functionName, @Nullable Object expression, @Nullable Window window) {
            super(functionName, window);
            this.expression = expression;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.functionName());
            if (this.expression == null) {
                writer.writeStartDocument();
                writer.writeEndDocument();
            } else {
                BuildersHelper.encodeValue(writer, this.expression, codecRegistry);
            }
            this.writeWindow(codecRegistry, writer);
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleParameterFunctionAndWindow that = (SimpleParameterFunctionAndWindow)o;
            return this.functionName().equals(that.functionName()) && Objects.equals(this.expression, that.expression) && this.window().equals(that.window());
        }

        public int hashCode() {
            return Objects.hash(this.functionName(), this.expression, this.window());
        }

        public String toString() {
            return "WindowFunction{name='" + this.functionName() + '\'' + ", expression=" + this.expression + ", window=" + this.window() + '}';
        }
    }

    private static abstract class AbstractFunctionAndWindow
    implements Bson {
        private final String functionName;
        @Nullable
        private final Window window;

        AbstractFunctionAndWindow(String functionName, @Nullable Window window) {
            this.functionName = functionName;
            this.window = window;
        }

        final void writeWindow(CodecRegistry codecRegistry, BsonDocumentWriter writer) {
            if (this.window != null) {
                writer.writeName("window");
                BuildersHelper.encodeValue(writer, this.window, codecRegistry);
            }
        }

        final String functionName() {
            return this.functionName;
        }

        final Optional<Window> window() {
            return Optional.ofNullable(this.window);
        }
    }

    private static final class BsonFieldWindowedComputation
    implements WindowedComputation {
        private final BsonField wrapped;

        BsonFieldWindowedComputation(BsonField field) {
            this.wrapped = com.mongodb.assertions.Assertions.assertNotNull(field);
        }

        @Override
        public BsonField toBsonField() {
            return this.wrapped;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BsonFieldWindowedComputation that = (BsonFieldWindowedComputation)o;
            return this.wrapped.equals(that.wrapped);
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public String toString() {
            return this.wrapped.toString();
        }
    }
}

