/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadWriteBinding;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.ServerTuple;
import com.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.mongodb.internal.session.ClientSessionContext;
import com.mongodb.internal.session.SessionContext;

public class ClientSessionBinding
implements AsyncReadWriteBinding {
    private final AsyncClusterAwareReadWriteBinding wrapped;
    private final AsyncClientSession session;
    private final boolean ownsSession;
    private final ClientSessionContext sessionContext;

    public ClientSessionBinding(AsyncClientSession session, boolean ownsSession, AsyncClusterAwareReadWriteBinding wrapped) {
        this.wrapped = Assertions.notNull("wrapped", wrapped);
        this.ownsSession = ownsSession;
        this.session = Assertions.notNull("session", session);
        this.sessionContext = new AsyncClientSessionContext(session);
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public void getReadConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        if (this.isActiveShardedTxn()) {
            this.getPinnedConnectionSource(callback);
        } else {
            this.wrapped.getReadConnectionSource(new WrappingCallback(callback));
        }
    }

    @Override
    public void getWriteConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        if (this.isActiveShardedTxn()) {
            this.getPinnedConnectionSource(callback);
        } else {
            this.wrapped.getWriteConnectionSource(new WrappingCallback(callback));
        }
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    private void getPinnedConnectionSource(final SingleResultCallback<AsyncConnectionSource> callback) {
        if (this.session.getPinnedServerAddress() == null) {
            this.wrapped.getCluster().selectServerAsync(new ReadPreferenceServerSelector(this.wrapped.getReadPreference()), new SingleResultCallback<ServerTuple>(){

                @Override
                public void onResult(ServerTuple serverTuple, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        ClientSessionBinding.this.session.setPinnedServerAddress(serverTuple.getServerDescription().getAddress());
                        ClientSessionBinding.this.wrapped.getConnectionSource(ClientSessionBinding.this.session.getPinnedServerAddress(), new WrappingCallback(callback));
                    }
                }
            });
        } else {
            this.wrapped.getConnectionSource(this.session.getPinnedServerAddress(), new WrappingCallback(callback));
        }
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public AsyncReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    @Override
    public void release() {
        this.wrapped.release();
        this.closeSessionIfCountIsZero();
    }

    private void closeSessionIfCountIsZero() {
        if (this.getCount() == 0 && this.ownsSession) {
            this.session.close();
        }
    }

    private boolean isActiveShardedTxn() {
        return this.session.hasActiveTransaction() && this.wrapped.getCluster().getDescription().getType() == ClusterType.SHARDED;
    }

    private class WrappingCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final SingleResultCallback<AsyncConnectionSource> callback;

        WrappingCallback(SingleResultCallback<AsyncConnectionSource> callback) {
            this.callback = callback;
        }

        @Override
        public void onResult(AsyncConnectionSource result, Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
            } else {
                this.callback.onResult(new SessionBindingAsyncConnectionSource(result), null);
            }
        }
    }

    private final class AsyncClientSessionContext
    extends ClientSessionContext
    implements SessionContext {
        private final AsyncClientSession clientSession;

        AsyncClientSessionContext(AsyncClientSession clientSession) {
            super(clientSession);
            this.clientSession = clientSession;
        }

        @Override
        public boolean isImplicitSession() {
            return ClientSessionBinding.this.ownsSession;
        }

        @Override
        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        @Override
        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        @Override
        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return this.clientSession.getTransactionOptions().getReadConcern();
            }
            return ClientSessionBinding.this.wrapped.getSessionContext().getReadConcern();
        }
    }

    private class SessionBindingAsyncConnectionSource
    implements AsyncConnectionSource {
        private AsyncConnectionSource wrapped;

        SessionBindingAsyncConnectionSource(AsyncConnectionSource wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public SessionContext getSessionContext() {
            return ClientSessionBinding.this.sessionContext;
        }

        @Override
        public void getConnection(SingleResultCallback<AsyncConnection> callback) {
            this.wrapped.getConnection(callback);
        }

        @Override
        public AsyncConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public void release() {
            this.wrapped.release();
            ClientSessionBinding.this.closeSessionIfCountIsZero();
        }
    }
}

