/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client.vault;

import com.mongodb.ClientEncryptionSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.client.model.vault.DataKeyOptions;
import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncMongoClient;
import com.mongodb.internal.async.client.AsyncMongoClients;
import com.mongodb.internal.async.client.Crypt;
import com.mongodb.internal.async.client.Crypts;
import com.mongodb.internal.async.client.vault.AsyncClientEncryption;
import java.io.Closeable;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;

class AsyncClientEncryptionImpl
implements AsyncClientEncryption,
Closeable {
    private final Crypt crypt;
    private final ClientEncryptionSettings options;
    private final AsyncMongoClient keyVaultClient;

    AsyncClientEncryptionImpl(ClientEncryptionSettings options) {
        this.keyVaultClient = AsyncMongoClients.create(options.getKeyVaultMongoClientSettings());
        this.crypt = Crypts.create(this.keyVaultClient, options);
        this.options = options;
    }

    @Override
    public void createDataKey(String kmsProvider, SingleResultCallback<BsonBinary> callback) {
        this.createDataKey(kmsProvider, new DataKeyOptions(), callback);
    }

    @Override
    public void createDataKey(String kmsProvider, DataKeyOptions dataKeyOptions, SingleResultCallback<BsonBinary> callback) {
        this.crypt.createDataKey(kmsProvider, dataKeyOptions, (RawBsonDocument dataKeyDocument, Throwable t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                MongoNamespace namespace = new MongoNamespace(this.options.getKeyVaultNamespace());
                this.keyVaultClient.getDatabase(namespace.getDatabaseName()).getCollection(namespace.getCollectionName(), BsonDocument.class).withWriteConcern(WriteConcern.MAJORITY).insertOne((BsonDocument)dataKeyDocument, (result, t1) -> {
                    if (t1 != null) {
                        callback.onResult(null, t1);
                    } else {
                        callback.onResult(dataKeyDocument.getBinary((Object)"_id"), null);
                    }
                });
            }
        });
    }

    @Override
    public void encrypt(BsonValue value, EncryptOptions options, SingleResultCallback<BsonBinary> callback) {
        this.crypt.encryptExplicitly(value, options, callback);
    }

    @Override
    public void decrypt(BsonBinary value, SingleResultCallback<BsonValue> callback) {
        this.crypt.decryptExplicitly(value, callback);
    }

    @Override
    public void close() {
        this.keyVaultClient.close();
        this.crypt.close();
    }
}

