/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.ReadPreference;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncCryptConnection;
import com.mongodb.internal.async.client.Crypt;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadWriteBinding;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.session.SessionContext;

public class AsyncCryptBinding
implements AsyncClusterAwareReadWriteBinding {
    private final AsyncClusterAwareReadWriteBinding wrapped;
    private final Crypt crypt;

    public AsyncCryptBinding(AsyncClusterAwareReadWriteBinding wrapped, Crypt crypt) {
        this.wrapped = wrapped;
        this.crypt = crypt;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public void getWriteConnectionSource(final SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getWriteConnectionSource(new SingleResultCallback<AsyncConnectionSource>(){

            @Override
            public void onResult(AsyncConnectionSource result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(new AsyncCryptConnectionSource(result), null);
                }
            }
        });
    }

    @Override
    public SessionContext getSessionContext() {
        return this.wrapped.getSessionContext();
    }

    @Override
    public void getReadConnectionSource(final SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getReadConnectionSource(new SingleResultCallback<AsyncConnectionSource>(){

            @Override
            public void onResult(AsyncConnectionSource result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(new AsyncCryptConnectionSource(result), null);
                }
            }
        });
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public AsyncReadWriteBinding retain() {
        return this.wrapped.retain();
    }

    @Override
    public void release() {
        this.wrapped.release();
    }

    @Override
    public Cluster getCluster() {
        return this.wrapped.getCluster();
    }

    private class AsyncCryptConnectionSource
    implements AsyncConnectionSource {
        private final AsyncConnectionSource wrapped;

        AsyncCryptConnectionSource(AsyncConnectionSource wrapped) {
            this.wrapped = wrapped;
            AsyncCryptBinding.this.retain();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public SessionContext getSessionContext() {
            return this.wrapped.getSessionContext();
        }

        @Override
        public void getConnection(final SingleResultCallback<AsyncConnection> callback) {
            this.wrapped.getConnection(new SingleResultCallback<AsyncConnection>(){

                @Override
                public void onResult(AsyncConnection result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        callback.onResult(new AsyncCryptConnection(result, AsyncCryptBinding.this.crypt), null);
                    }
                }
            });
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public AsyncConnectionSource retain() {
            this.wrapped.retain();
            return this;
        }

        @Override
        public void release() {
            this.wrapped.release();
        }
    }
}

