/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncAggregateIterable;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncMongoIterableImpl;
import com.mongodb.internal.async.client.OperationExecutor;
import com.mongodb.internal.async.client.WriteOperationThenCursorReadOperation;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.operation.AsyncOperations;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class AsyncAggregateIterableImpl<TDocument, TResult>
extends AsyncMongoIterableImpl<TResult>
implements AsyncAggregateIterable<TResult> {
    private final AsyncOperations<TDocument> operations;
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final CodecRegistry codecRegistry;
    private final List<? extends Bson> pipeline;
    private final AggregationLevel aggregationLevel;
    private Boolean allowDiskUse;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private String comment;
    private Bson hint;

    AsyncAggregateIterableImpl(@Nullable AsyncClientSession clientSession, String databaseName, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor executor, List<? extends Bson> pipeline, AggregationLevel aggregationLevel, boolean retryReads) {
        this(clientSession, new MongoNamespace(databaseName, "ignored"), documentClass, resultClass, codecRegistry, readPreference, readConcern, writeConcern, executor, pipeline, aggregationLevel, retryReads);
    }

    AsyncAggregateIterableImpl(@Nullable AsyncClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor executor, List<? extends Bson> pipeline, AggregationLevel aggregationLevel, boolean retryReads) {
        super(clientSession, executor, readConcern, readPreference, retryReads);
        this.operations = new AsyncOperations<TDocument>(namespace, documentClass, readPreference, codecRegistry, readConcern, writeConcern, false, retryReads);
        this.namespace = Assertions.notNull("namespace", namespace);
        this.documentClass = Assertions.notNull("documentClass", documentClass);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.aggregationLevel = Assertions.notNull("aggregationLevel", aggregationLevel);
    }

    @Override
    public void toCollection(SingleResultCallback<Void> callback) {
        if (this.getOutNamespace() == null) {
            throw new IllegalStateException("The last stage of the aggregation pipeline must be $out or $merge");
        }
        this.getExecutor().execute(this.operations.aggregateToCollection(this.pipeline, this.maxTimeMS, this.allowDiskUse, this.bypassDocumentValidation, this.collation, this.hint, this.comment, this.aggregationLevel), this.getReadConcern(), this.getClientSession(), callback);
    }

    @Override
    public AsyncAggregateIterable<TResult> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public AsyncAggregateIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public AsyncAggregateIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public AsyncAggregateIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public AsyncAggregateIterable<TResult> bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public AsyncAggregateIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public AsyncAggregateIterable<TResult> comment(@Nullable String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public AsyncAggregateIterable<TResult> hint(@Nullable Bson hint) {
        this.hint = hint;
        return this;
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<TResult>> asAsyncReadOperation() {
        MongoNamespace outNamespace = this.getOutNamespace();
        if (outNamespace != null) {
            AsyncWriteOperation<Void> aggregateToCollectionOperation = this.operations.aggregateToCollection(this.pipeline, this.maxTimeMS, this.allowDiskUse, this.bypassDocumentValidation, this.collation, this.hint, this.comment, this.aggregationLevel);
            FindOptions findOptions = new FindOptions().collation(this.collation);
            Integer batchSize = this.getBatchSize();
            if (batchSize != null) {
                findOptions.batchSize(batchSize);
            }
            AsyncReadOperation findOperation = this.operations.find(outNamespace, (Bson)new BsonDocument(), this.resultClass, findOptions);
            return new WriteOperationThenCursorReadOperation(aggregateToCollectionOperation, findOperation);
        }
        return this.operations.aggregate(this.pipeline, this.resultClass, this.maxTimeMS, this.maxAwaitTimeMS, this.getBatchSize(), this.collation, this.hint, this.comment, this.allowDiskUse, this.aggregationLevel);
    }

    @Nullable
    private MongoNamespace getOutNamespace() {
        if (this.pipeline.size() == 0) {
            return null;
        }
        Bson lastStage = Assertions.notNull("last stage", this.pipeline.get(this.pipeline.size() - 1));
        BsonDocument lastStageDocument = lastStage.toBsonDocument(this.documentClass, this.codecRegistry);
        if (lastStageDocument.containsKey((Object)"$out")) {
            return new MongoNamespace(this.namespace.getDatabaseName(), lastStageDocument.getString((Object)"$out").getValue());
        }
        if (lastStageDocument.containsKey((Object)"$merge")) {
            BsonDocument mergeDocument = lastStageDocument.getDocument((Object)"$merge");
            if (mergeDocument.isDocument((Object)"into")) {
                BsonDocument intoDocument = mergeDocument.getDocument((Object)"into");
                return new MongoNamespace(intoDocument.getString((Object)"db", new BsonString(this.namespace.getDatabaseName())).getValue(), intoDocument.getString((Object)"coll").getValue());
            }
            if (mergeDocument.isString((Object)"into")) {
                return new MongoNamespace(this.namespace.getDatabaseName(), mergeDocument.getString((Object)"into").getValue());
            }
        }
        return null;
    }
}

