/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoCredential;
import com.mongodb.MongoInternalException;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.internal.authentication.NativeAuthenticationHelper;
import com.mongodb.lang.NonNull;
import com.mongodb.operation.WriteConcernHelper;
import java.util.Arrays;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

final class UserOperationHelper {
    static BsonDocument asCommandDocument(MongoCredential credential, boolean readOnly, String commandName) {
        BsonDocument document = new BsonDocument();
        document.put(commandName, (BsonValue)new BsonString(credential.getUserName()));
        document.put("pwd", (BsonValue)new BsonString(NativeAuthenticationHelper.createAuthenticationHash(UserOperationHelper.getUserNameNonNull(credential), UserOperationHelper.getPasswordNonNull(credential))));
        document.put("digestPassword", (BsonValue)BsonBoolean.FALSE);
        document.put("roles", (BsonValue)new BsonArray(Arrays.asList(new BsonString(UserOperationHelper.getRoleName(credential, readOnly)))));
        return document;
    }

    private static String getRoleName(MongoCredential credential, boolean readOnly) {
        return credential.getSource().equals("admin") ? (readOnly ? "readAnyDatabase" : "root") : (readOnly ? "read" : "dbOwner");
    }

    static void translateUserCommandException(MongoCommandException e) {
        if (e.getErrorCode() == 100 && WriteConcernHelper.hasWriteConcernError(e.getResponse())) {
            throw WriteConcernHelper.createWriteConcernError(e.getResponse(), e.getServerAddress());
        }
        throw e;
    }

    static SingleResultCallback<Void> userCommandCallback(final SingleResultCallback<Void> wrappedCallback) {
        return new SingleResultCallback<Void>(){

            @Override
            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    if (t instanceof MongoCommandException && WriteConcernHelper.hasWriteConcernError(((MongoCommandException)t).getResponse())) {
                        wrappedCallback.onResult(null, WriteConcernHelper.createWriteConcernError(((MongoCommandException)t).getResponse(), ((MongoCommandException)t).getServerAddress()));
                    } else {
                        wrappedCallback.onResult(null, t);
                    }
                } else {
                    wrappedCallback.onResult(null, null);
                }
            }
        };
    }

    @NonNull
    private static String getUserNameNonNull(MongoCredential credential) {
        String userName = credential.getUserName();
        if (userName == null) {
            throw new MongoInternalException("User name can not be null");
        }
        return userName;
    }

    @NonNull
    private static char[] getPasswordNonNull(MongoCredential credential) {
        char[] password = credential.getPassword();
        if (password == null) {
            throw new MongoInternalException("Password can not be null");
        }
        return password;
    }

    private UserOperationHelper() {
    }
}

