/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.CommandMessage;
import com.mongodb.connection.CommandProtocol;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.ProtocolHelper;
import com.mongodb.connection.SplittablePayload;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.session.SessionContext;
import org.bson.BsonDocument;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;

class CommandProtocolImpl<T>
implements CommandProtocol<T> {
    public static final Logger LOGGER = Loggers.getLogger("protocol.command");
    private final MongoNamespace namespace;
    private final BsonDocument command;
    private final SplittablePayload payload;
    private final ReadPreference readPreference;
    private final FieldNameValidator commandFieldNameValidator;
    private final FieldNameValidator payloadFieldNameValidator;
    private final Decoder<T> commandResultDecoder;
    private final boolean responseExpected;
    private final ClusterConnectionMode clusterConnectionMode;
    private SessionContext sessionContext;

    CommandProtocolImpl(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder) {
        this(database, command, commandFieldNameValidator, readPreference, commandResultDecoder, true, null, null, ClusterConnectionMode.MULTIPLE);
    }

    CommandProtocolImpl(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, ReadPreference readPreference, Decoder<T> commandResultDecoder, boolean responseExpected, SplittablePayload payload, FieldNameValidator payloadFieldNameValidator, ClusterConnectionMode clusterConnectionMode) {
        Assertions.notNull("database", database);
        this.namespace = new MongoNamespace(Assertions.notNull("database", database), "$cmd");
        this.command = Assertions.notNull("command", command);
        this.commandFieldNameValidator = Assertions.notNull("commandFieldNameValidator", commandFieldNameValidator);
        this.readPreference = readPreference;
        this.commandResultDecoder = Assertions.notNull("commandResultDecoder", commandResultDecoder);
        this.responseExpected = responseExpected;
        this.payload = payload;
        this.payloadFieldNameValidator = payloadFieldNameValidator;
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        Assertions.isTrueArgument("payloadFieldNameValidator cannot be null if there is a payload.", payload == null || payloadFieldNameValidator != null);
    }

    @Override
    public T execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Sending command {%s : %s} to database %s on connection [%s] to server %s", this.getCommandName(), this.command.values().iterator().next(), this.namespace.getDatabaseName(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        T retval = connection.sendAndReceive(this.getCommandMessage(connection), this.commandResultDecoder, this.sessionContext);
        LOGGER.debug("Command execution completed");
        return retval;
    }

    @Override
    public void executeAsync(InternalConnection connection, final SingleResultCallback<T> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously sending command {%s : %s} to database %s on connection [%s] to server %s", this.getCommandName(), this.command.values().iterator().next(), this.namespace.getDatabaseName(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            connection.sendAndReceiveAsync(this.getCommandMessage(connection), this.commandResultDecoder, this.sessionContext, new SingleResultCallback<T>(){

                @Override
                public void onResult(T result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        callback.onResult(result, null);
                    }
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    @Override
    public CommandProtocolImpl<T> sessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        return this;
    }

    private CommandMessage getCommandMessage(InternalConnection connection) {
        return new CommandMessage(this.namespace, this.command, this.commandFieldNameValidator, this.readPreference, ProtocolHelper.getMessageSettings(connection.getDescription()), this.responseExpected, this.payload, this.payloadFieldNameValidator, this.clusterConnectionMode);
    }

    private String getCommandName() {
        return (String)this.command.keySet().iterator().next();
    }
}

