/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.connection.ByteBufBsonDocument;
import com.mongodb.connection.ByteBufferBsonOutput;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.RequestMessage;
import com.mongodb.connection.UpdateMessage;
import com.mongodb.connection.WriteProtocol;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import java.util.Collections;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;

class UpdateProtocol
extends WriteProtocol {
    private static final Logger LOGGER = Loggers.getLogger("protocol.update");
    private final List<UpdateRequest> updates;

    UpdateProtocol(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<UpdateRequest> updates) {
        super(namespace, ordered, writeConcern);
        this.updates = updates;
    }

    @Override
    public WriteConcernResult execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Updating documents in namespace %s on connection [%s] to server %s", this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        WriteConcernResult writeConcernResult = super.execute(connection);
        LOGGER.debug("Update completed");
        return writeConcernResult;
    }

    @Override
    public void executeAsync(InternalConnection connection, final SingleResultCallback<WriteConcernResult> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously updating documents in namespace %s on connection [%s] to server %s", this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            super.executeAsync(connection, new SingleResultCallback<WriteConcernResult>(){

                @Override
                public void onResult(WriteConcernResult result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        LOGGER.debug("Asynchronous update completed");
                        callback.onResult(result, null);
                    }
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    @Override
    protected BsonDocument getAsWriteCommand(ByteBufferBsonOutput bsonOutput, int firstDocumentPosition) {
        List<ByteBufBsonDocument> documents = ByteBufBsonDocument.create(bsonOutput, firstDocumentPosition);
        BsonDocument updateDocument = new BsonDocument("q", (BsonValue)documents.get(0)).append("u", (BsonValue)documents.get(1));
        if (this.updates.get(0).isMulti()) {
            updateDocument.append("multi", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.updates.get(0).isUpsert()) {
            updateDocument.append("upsert", (BsonValue)BsonBoolean.TRUE);
        }
        return this.getBaseCommandDocument("update").append("updates", (BsonValue)new BsonArray(Collections.singletonList(updateDocument)));
    }

    @Override
    protected RequestMessage createRequestMessage(MessageSettings settings) {
        return new UpdateMessage(this.getNamespace().getFullName(), this.updates, settings);
    }

    @Override
    protected void appendToWriteCommandResponseDocument(RequestMessage curMessage, RequestMessage nextMessage, WriteConcernResult writeConcernResult, BsonDocument response) {
        response.append("n", (BsonValue)new BsonInt32(writeConcernResult.getCount()));
        UpdateMessage updateMessage = (UpdateMessage)curMessage;
        UpdateRequest updateRequest = updateMessage.getUpdateRequests().get(0);
        BsonValue upsertedId = null;
        if (writeConcernResult.getUpsertedId() != null) {
            upsertedId = writeConcernResult.getUpsertedId();
        } else if (!writeConcernResult.isUpdateOfExisting() && updateRequest.isUpsert()) {
            if (updateRequest.getUpdate().containsKey((Object)"_id")) {
                upsertedId = updateRequest.getUpdate().get((Object)"_id");
            } else if (updateRequest.getFilter().containsKey((Object)"_id")) {
                upsertedId = updateRequest.getFilter().get((Object)"_id");
            }
        }
        if (upsertedId != null) {
            response.append("upserted", (BsonValue)new BsonArray(Collections.singletonList(new BsonDocument("index", (BsonValue)new BsonInt32(0)).append("_id", upsertedId))));
        }
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

