/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.RequestMessage;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBinaryWriterSettings;
import org.bson.BsonDocument;
import org.bson.BsonWriter;
import org.bson.BsonWriterSettings;
import org.bson.FieldNameValidator;
import org.bson.codecs.EncoderContext;
import org.bson.io.BsonOutput;

abstract class BaseWriteCommandMessage
extends RequestMessage {
    private static final int HEADROOM = 16384;
    private final MongoNamespace writeNamespace;
    private final boolean ordered;
    private final WriteConcern writeConcern;
    private final Boolean bypassDocumentValidation;

    BaseWriteCommandMessage(MongoNamespace writeNamespace, boolean ordered, WriteConcern writeConcern, Boolean bypassDocumentValidation, MessageSettings settings) {
        super(new MongoNamespace(writeNamespace.getDatabaseName(), "$cmd").getFullName(), RequestMessage.OpCode.OP_QUERY, settings);
        this.writeNamespace = writeNamespace;
        this.ordered = ordered;
        this.writeConcern = writeConcern;
        this.bypassDocumentValidation = bypassDocumentValidation;
    }

    public MongoNamespace getWriteNamespace() {
        return this.writeNamespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    @Override
    public BaseWriteCommandMessage encode(BsonOutput outputStream) {
        return (BaseWriteCommandMessage)super.encode(outputStream);
    }

    public abstract int getItemCount();

    @Override
    protected BaseWriteCommandMessage encodeMessageBody(BsonOutput outputStream, int messageStartPosition) {
        return (BaseWriteCommandMessage)this.encodeMessageBodyWithMetadata(outputStream, messageStartPosition).getNextMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput outputStream, int messageStartPosition) {
        BaseWriteCommandMessage nextMessage = null;
        this.writeCommandHeader(outputStream);
        int commandStartPosition = outputStream.getPosition();
        int firstDocumentStartPosition = outputStream.getPosition();
        BsonBinaryWriter writer = new BsonBinaryWriter(new BsonWriterSettings(), new BsonBinaryWriterSettings(this.getSettings().getMaxDocumentSize() + 16384), outputStream, this.getFieldNameValidator());
        try {
            writer.writeStartDocument();
            this.writeCommandPrologue(writer);
            nextMessage = this.writeTheWrites(outputStream, commandStartPosition, writer);
            writer.writeEndDocument();
        }
        finally {
            writer.close();
        }
        return new RequestMessage.EncodingMetadata(nextMessage, firstDocumentStartPosition);
    }

    protected abstract FieldNameValidator getFieldNameValidator();

    private void writeCommandHeader(BsonOutput outputStream) {
        outputStream.writeInt32(0);
        outputStream.writeCString(this.getCollectionName());
        outputStream.writeInt32(0);
        outputStream.writeInt32(-1);
    }

    protected abstract String getCommandName();

    protected abstract BaseWriteCommandMessage writeTheWrites(BsonOutput var1, int var2, BsonBinaryWriter var3);

    boolean exceedsLimits(int batchLength, int batchItemCount) {
        return this.exceedsBatchLengthLimit(batchLength, batchItemCount) || this.exceedsBatchItemCountLimit(batchItemCount);
    }

    private boolean exceedsBatchLengthLimit(int batchLength, int batchItemCount) {
        return batchLength > this.getSettings().getMaxDocumentSize() && batchItemCount > 1;
    }

    private boolean exceedsBatchItemCountLimit(int batchItemCount) {
        return batchItemCount > this.getSettings().getMaxBatchCount();
    }

    private void writeCommandPrologue(BsonBinaryWriter writer) {
        writer.writeString(this.getCommandName(), this.getWriteNamespace().getCollectionName());
        writer.writeBoolean("ordered", this.ordered);
        if (!this.getWriteConcern().isServerDefault()) {
            writer.writeName("writeConcern");
            BsonDocument document = this.getWriteConcern().asDocument();
            this.getCodec(document).encode((BsonWriter)writer, (Object)document, EncoderContext.builder().build());
        }
        if (this.getBypassDocumentValidation() != null) {
            writer.writeBoolean("bypassDocumentValidation", this.getBypassDocumentValidation().booleanValue());
        }
    }
}

