/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.validator.CollectibleDocumentFieldNameValidator;
import com.mongodb.internal.validator.MappedFieldNameValidator;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.CommandResultDocumentCodec;
import com.mongodb.operation.DocumentHelper;
import com.mongodb.operation.FindAndModifyHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.WriteOperation;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;

public class FindAndReplaceOperation<T>
implements AsyncWriteOperation<T>,
WriteOperation<T> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private final BsonDocument replacement;
    private final WriteConcern writeConcern;
    private BsonDocument filter;
    private BsonDocument projection;
    private BsonDocument sort;
    private long maxTimeMS;
    private boolean returnOriginal = true;
    private boolean upsert;
    private Boolean bypassDocumentValidation;

    @Deprecated
    public FindAndReplaceOperation(MongoNamespace namespace, Decoder<T> decoder, BsonDocument replacement) {
        this(namespace, WriteConcern.ACKNOWLEDGED, decoder, replacement);
    }

    public FindAndReplaceOperation(MongoNamespace namespace, WriteConcern writeConcern, Decoder<T> decoder, BsonDocument replacement) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.decoder = Assertions.notNull("decoder", decoder);
        this.replacement = Assertions.notNull("replacement", replacement);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getReplacement() {
        return this.replacement;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public FindAndReplaceOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public FindAndReplaceOperation<T> projection(BsonDocument projection) {
        this.projection = projection;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindAndReplaceOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public FindAndReplaceOperation<T> sort(BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public boolean isReturnOriginal() {
        return this.returnOriginal;
    }

    public FindAndReplaceOperation<T> returnOriginal(boolean returnOriginal) {
        this.returnOriginal = returnOriginal;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public FindAndReplaceOperation<T> upsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public FindAndReplaceOperation<T> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public T execute(final WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<T>(){

            @Override
            public T call(Connection connection) {
                return CommandOperationHelper.executeWrappedCommandProtocol(binding, FindAndReplaceOperation.this.namespace.getDatabaseName(), FindAndReplaceOperation.this.asCommandDocument(connection.getDescription()), FindAndReplaceOperation.this.getValidator(), CommandResultDocumentCodec.create(FindAndReplaceOperation.this.decoder, "value"), connection, FindAndModifyHelper.<BsonDocument>transformer());
            }
        });
    }

    @Override
    public void executeAsync(final AsyncWriteBinding binding, final SingleResultCallback<T> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, FindAndReplaceOperation.this.namespace.getDatabaseName(), FindAndReplaceOperation.this.asCommandDocument(connection.getDescription()), FindAndReplaceOperation.this.getValidator(), CommandResultDocumentCodec.create(FindAndReplaceOperation.this.decoder, "value"), connection, FindAndModifyHelper.<BsonDocument>transformer(), OperationHelper.releasingCallback(errHandlingCallback, connection));
                }
            }
        });
    }

    private BsonDocument asCommandDocument(ConnectionDescription description) {
        BsonDocument command = new BsonDocument("findandmodify", (BsonValue)new BsonString(this.namespace.getCollectionName()));
        DocumentHelper.putIfNotNull(command, "query", (BsonValue)this.getFilter());
        DocumentHelper.putIfNotNull(command, "fields", (BsonValue)this.getProjection());
        DocumentHelper.putIfNotNull(command, "sort", (BsonValue)this.getSort());
        DocumentHelper.putIfTrue(command, "new", !this.isReturnOriginal());
        DocumentHelper.putIfTrue(command, "upsert", this.isUpsert());
        DocumentHelper.putIfNotZero(command, "maxTimeMS", this.getMaxTime(TimeUnit.MILLISECONDS));
        command.put("update", (BsonValue)this.getReplacement());
        if (this.bypassDocumentValidation != null && OperationHelper.serverIsAtLeastVersionThreeDotTwo(description)) {
            command.put("bypassDocumentValidation", (BsonValue)BsonBoolean.valueOf((boolean)this.bypassDocumentValidation));
        }
        if (OperationHelper.serverIsAtLeastVersionThreeDotTwo(description) && this.writeConcern.isAcknowledged() && !this.writeConcern.isServerDefault()) {
            command.put("writeConcern", (BsonValue)this.writeConcern.asDocument());
        }
        return command;
    }

    private FieldNameValidator getValidator() {
        HashMap<String, FieldNameValidator> map = new HashMap<String, FieldNameValidator>();
        map.put("update", new CollectibleDocumentFieldNameValidator());
        return new MappedFieldNameValidator(new NoOpFieldNameValidator(), map);
    }
}

