/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.IndexHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.WriteOperation;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

public class DropIndexOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace namespace;
    private final String indexName;

    public DropIndexOperation(MongoNamespace namespace, String indexName) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.indexName = Assertions.notNull("indexName", indexName);
    }

    public DropIndexOperation(MongoNamespace namespace, BsonDocument keys) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.indexName = IndexHelper.generateIndexName(Assertions.notNull("keys", keys));
    }

    @Override
    public Void execute(WriteBinding binding) {
        try {
            CommandOperationHelper.executeWrappedCommandProtocol(this.namespace.getDatabaseName(), this.getCommand(), binding);
        }
        catch (MongoCommandException e) {
            CommandOperationHelper.rethrowIfNotNamespaceError(e);
        }
        return null;
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, final SingleResultCallback<Void> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(this.namespace.getDatabaseName(), this.getCommand(), binding, new OperationHelper.VoidTransformer<BsonDocument>(), new SingleResultCallback<Void>(){

            @Override
            public void onResult(Void result, Throwable t) {
                if (t != null && !CommandOperationHelper.isNamespaceError(t)) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(result, null);
                }
            }
        });
    }

    private BsonDocument getCommand() {
        return new BsonDocument("dropIndexes", (BsonValue)new BsonString(this.namespace.getCollectionName())).append("index", (BsonValue)new BsonString(this.indexName));
    }
}

