/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Function;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import java.util.ArrayList;
import java.util.List;

class MappingAsyncBatchCursor<T, U>
implements AsyncBatchCursor<U> {
    private final AsyncBatchCursor<T> batchCursor;
    private final Function<T, U> mapper;

    MappingAsyncBatchCursor(AsyncBatchCursor<T> batchCursor, Function<T, U> mapper) {
        this.batchCursor = batchCursor;
        this.mapper = mapper;
    }

    public void next(final SingleResultCallback<List<U>> callback) {
        this.batchCursor.next(new SingleResultCallback<List<T>>(){

            public void onResult(List<T> results, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (results != null) {
                    try {
                        ArrayList<Object> mappedResults = new ArrayList<Object>();
                        for (Object result : results) {
                            mappedResults.add(MappingAsyncBatchCursor.this.mapper.apply(result));
                        }
                        callback.onResult(mappedResults, null);
                    }
                    catch (Throwable t1) {
                        callback.onResult(null, t1);
                    }
                } else {
                    callback.onResult(null, null);
                }
            }
        });
    }

    public void setBatchSize(int batchSize) {
        this.batchCursor.setBatchSize(batchSize);
    }

    public int getBatchSize() {
        return this.batchCursor.getBatchSize();
    }

    public boolean isClosed() {
        return this.batchCursor.isClosed();
    }

    public void close() {
        this.batchCursor.close();
    }
}

