/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.ResponseBuffers;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import java.util.List;
import org.bson.ByteBuf;

class UsageTrackingInternalConnection
implements InternalConnection {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private volatile long openedAt;
    private volatile long lastUsedAt;
    private final int generation;
    private volatile InternalConnection wrapped;

    UsageTrackingInternalConnection(InternalConnection wrapped, int generation) {
        this.wrapped = wrapped;
        this.generation = generation;
        this.lastUsedAt = this.openedAt = Long.MAX_VALUE;
    }

    @Override
    public void open() {
        Assertions.isTrue("open", this.wrapped != null);
        this.wrapped.open();
        this.lastUsedAt = this.openedAt = System.currentTimeMillis();
    }

    @Override
    public void openAsync(final SingleResultCallback<Void> callback) {
        Assertions.isTrue("open", this.wrapped != null);
        this.wrapped.openAsync(new SingleResultCallback<Void>(){

            @Override
            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    UsageTrackingInternalConnection.this.openedAt = System.currentTimeMillis();
                    UsageTrackingInternalConnection.this.lastUsedAt = UsageTrackingInternalConnection.this.openedAt;
                    callback.onResult(null, null);
                }
            }
        });
    }

    @Override
    public void close() {
        Assertions.isTrue("open", this.wrapped != null);
        this.wrapped.close();
        this.wrapped = null;
    }

    @Override
    public boolean opened() {
        Assertions.isTrue("open", this.wrapped != null);
        return this.wrapped.opened();
    }

    @Override
    public boolean isClosed() {
        return this.wrapped == null || this.wrapped.isClosed();
    }

    @Override
    public ByteBuf getBuffer(int size) {
        Assertions.isTrue("open", this.wrapped != null);
        return this.wrapped.getBuffer(size);
    }

    @Override
    public void sendMessage(List<ByteBuf> byteBuffers, int lastRequestId) {
        Assertions.isTrue("open", this.wrapped != null);
        this.wrapped.sendMessage(byteBuffers, lastRequestId);
        this.lastUsedAt = System.currentTimeMillis();
    }

    @Override
    public ResponseBuffers receiveMessage(int responseTo) {
        Assertions.isTrue("open", this.wrapped != null);
        ResponseBuffers responseBuffers = this.wrapped.receiveMessage(responseTo);
        this.lastUsedAt = System.currentTimeMillis();
        return responseBuffers;
    }

    @Override
    public void sendMessageAsync(List<ByteBuf> byteBuffers, int lastRequestId, final SingleResultCallback<Void> callback) {
        Assertions.isTrue("open", this.wrapped != null);
        SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(new SingleResultCallback<Void>(){

            @Override
            public void onResult(Void result, Throwable t) {
                UsageTrackingInternalConnection.this.lastUsedAt = System.currentTimeMillis();
                callback.onResult(result, t);
            }
        }, LOGGER);
        this.wrapped.sendMessageAsync(byteBuffers, lastRequestId, errHandlingCallback);
    }

    @Override
    public void receiveMessageAsync(int responseTo, final SingleResultCallback<ResponseBuffers> callback) {
        Assertions.isTrue("open", this.wrapped != null);
        SingleResultCallback<ResponseBuffers> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(new SingleResultCallback<ResponseBuffers>(){

            @Override
            public void onResult(ResponseBuffers result, Throwable t) {
                UsageTrackingInternalConnection.this.lastUsedAt = System.currentTimeMillis();
                callback.onResult(result, t);
            }
        }, LOGGER);
        this.wrapped.receiveMessageAsync(responseTo, errHandlingCallback);
    }

    @Override
    public ConnectionDescription getDescription() {
        Assertions.isTrue("open", this.wrapped != null);
        return this.wrapped.getDescription();
    }

    int getGeneration() {
        return this.generation;
    }

    long getOpenedAt() {
        return this.openedAt;
    }

    long getLastUsedAt() {
        return this.lastUsedAt;
    }
}

