/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.mockito.MockedConstruction;
import org.mockito.creation.instance.InstantiationException;
import org.mockito.creation.instance.Instantiator;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.exceptions.base.MockitoInitializationException;
import org.mockito.exceptions.misusing.MockitoConfigurationException;
import org.mockito.internal.SuppressSignatureCheck;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.creation.bytebuddy.BytecodeGenerator;
import org.mockito.internal.creation.bytebuddy.ClassCreatingMockMaker;
import org.mockito.internal.creation.bytebuddy.ConstructionCallback;
import org.mockito.internal.creation.bytebuddy.InlineBytecodeGenerator;
import org.mockito.internal.creation.bytebuddy.MockAccess;
import org.mockito.internal.creation.bytebuddy.MockFeatures;
import org.mockito.internal.creation.bytebuddy.MockMethodInterceptor;
import org.mockito.internal.creation.bytebuddy.PlatformUtils;
import org.mockito.internal.creation.bytebuddy.StackWalkerChecker;
import org.mockito.internal.creation.bytebuddy.TypeCachingBytecodeGenerator;
import org.mockito.internal.creation.bytebuddy.TypeSupport;
import org.mockito.internal.creation.instance.ConstructorInstantiator;
import org.mockito.internal.util.Platform;
import org.mockito.internal.util.StringUtil;
import org.mockito.internal.util.concurrent.DetachedThreadLocal;
import org.mockito.internal.util.concurrent.WeakConcurrentMap;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.plugins.InlineMockMaker;
import org.mockito.plugins.MemberAccessor;
import org.mockito.plugins.MockMaker;

@SuppressSignatureCheck
class InlineDelegateByteBuddyMockMaker
implements ClassCreatingMockMaker,
InlineMockMaker,
Instantiator {
    private static final Instrumentation INSTRUMENTATION;
    private static final Throwable INITIALIZATION_ERROR;
    private final BytecodeGenerator bytecodeGenerator;
    private final WeakConcurrentMap<Object, MockMethodInterceptor> mocks = new WeakConcurrentMap(false);
    private final DetachedThreadLocal<Map<Class<?>, MockMethodInterceptor>> mockedStatics = new DetachedThreadLocal(DetachedThreadLocal.Cleaner.MANUAL);
    private final DetachedThreadLocal<Map<Class<?>, BiConsumer<Object, MockedConstruction.Context>>> mockedConstruction = new DetachedThreadLocal(DetachedThreadLocal.Cleaner.MANUAL);
    private final ThreadLocal<Class<?>> currentMocking = ThreadLocal.withInitial(() -> null);
    private final ThreadLocal<Object> currentSpied = new ThreadLocal();

    InlineDelegateByteBuddyMockMaker() {
        if (INITIALIZATION_ERROR != null) {
            String detail;
            if (PlatformUtils.isAndroidPlatform() || PlatformUtils.isProbablyTermuxEnvironment()) {
                detail = "It appears as if you are trying to run this mock maker on Android which does not support the instrumentation API.";
            } else {
                try {
                    detail = INITIALIZATION_ERROR instanceof NoClassDefFoundError && INITIALIZATION_ERROR.getMessage() != null && INITIALIZATION_ERROR.getMessage().startsWith("net/bytebuddy/agent/") ? StringUtil.join("It seems like you are running Mockito with an incomplete or inconsistent class path. Byte Buddy Agent could not be loaded.", "", "Byte Buddy Agent is available on Maven Central as 'net.bytebuddy:byte-buddy-agent' with the module name 'net.bytebuddy.agent'.", "Normally, your IDE or build tool (such as Maven or Gradle) should take care of your class path completion but ") : (Class.forName("javax.tools.ToolProvider").getMethod("getSystemJavaCompiler", new Class[0]).invoke(null, new Object[0]) == null ? "It appears as if you are running on a JRE. Either install a JDK or add JNA to the class path." : "It appears as if your JDK does not supply a working agent attachment mechanism.");
                }
                catch (Throwable ignored) {
                    detail = "It appears as if you are running an incomplete JVM installation that might not support all tooling APIs";
                }
            }
            throw new MockitoInitializationException(StringUtil.join("Could not initialize inline Byte Buddy mock maker.", "", detail, Platform.describe()), INITIALIZATION_ERROR);
        }
        ThreadLocal currentConstruction = new ThreadLocal();
        ThreadLocal<Boolean> isSuspended = ThreadLocal.withInitial(() -> false);
        Predicate<Class<?>> isCallFromSubclassConstructor = StackWalkerChecker.orFallback();
        Predicate<Class<?>> isMockConstruction = type -> {
            if (((Boolean)isSuspended.get()).booleanValue()) {
                return false;
            }
            if (this.currentMocking.get() != null && type.isAssignableFrom(this.currentMocking.get()) || currentConstruction.get() != null) {
                return true;
            }
            Map<Class<?>, BiConsumer<Object, MockedConstruction.Context>> interceptors = this.mockedConstruction.get();
            if (interceptors != null && interceptors.containsKey(type)) {
                if (isCallFromSubclassConstructor.test((Class<?>)type)) {
                    return false;
                }
                currentConstruction.set(type);
                return true;
            }
            return false;
        };
        ConstructionCallback onConstruction = (type, object, arguments, parameterTypeNames) -> {
            if (this.currentMocking.get() != null) {
                Object spy = this.currentSpied.get();
                if (spy == null) {
                    return null;
                }
                if (type.isInstance(spy)) {
                    return spy;
                }
                isSuspended.set(true);
                try {
                    throw new MockitoException("Unexpected spy for " + type.getName() + " on instance of " + object.getClass().getName(), object instanceof Throwable ? (Throwable)object : null);
                }
                catch (Throwable throwable) {
                    isSuspended.set(false);
                    throw throwable;
                }
            }
            if (currentConstruction.get() != type) {
                return null;
            }
            currentConstruction.remove();
            isSuspended.set(true);
            try {
                BiConsumer<Object, MockedConstruction.Context> interceptor;
                Map<Class<?>, BiConsumer<Object, MockedConstruction.Context>> interceptors = this.mockedConstruction.get();
                if (interceptors != null && (interceptor = interceptors.get(type)) != null) {
                    interceptor.accept(object, new InlineConstructionMockContext(arguments, object.getClass(), parameterTypeNames));
                }
            }
            finally {
                isSuspended.set(false);
            }
            return null;
        };
        this.bytecodeGenerator = new TypeCachingBytecodeGenerator(new InlineBytecodeGenerator(INSTRUMENTATION, this.mocks, this.mockedStatics, isMockConstruction, onConstruction), true);
    }

    @Override
    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        return this.doCreateMock(settings, handler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Optional<T> createSpy(MockCreationSettings<T> settings, MockHandler handler, T object) {
        if (object == null) {
            throw new MockitoConfigurationException("Spy instance must not be null");
        }
        this.currentSpied.set(object);
        try {
            Optional<T> optional = Optional.ofNullable(this.doCreateMock(settings, handler, true));
            return optional;
        }
        finally {
            this.currentSpied.remove();
        }
    }

    private <T> T doCreateMock(MockCreationSettings<T> settings, MockHandler handler, boolean nullOnNonInlineConstruction) {
        Class<T> type = this.createMockType(settings);
        try {
            T instance;
            if (settings.isUsingConstructor()) {
                instance = new ConstructorInstantiator(settings.getOuterClassInstance() != null, settings.getConstructorArgs()).newInstance(type);
            } else {
                try {
                    instance = this.newInstance(type);
                }
                catch (InstantiationException ignored) {
                    if (nullOnNonInlineConstruction) {
                        return null;
                    }
                    Instantiator instantiator = Plugins.getInstantiatorProvider().getInstantiator(settings);
                    instance = instantiator.newInstance(type);
                }
            }
            MockMethodInterceptor mockMethodInterceptor = new MockMethodInterceptor(handler, settings);
            this.mocks.put(instance, mockMethodInterceptor);
            if (instance instanceof MockAccess) {
                ((MockAccess)instance).setMockitoInterceptor(mockMethodInterceptor);
            }
            this.mocks.expungeStaleEntries();
            return instance;
        }
        catch (InstantiationException e) {
            throw new MockitoException("Unable to create mock instance of type '" + type.getSimpleName() + "'", e);
        }
    }

    @Override
    public <T> Class<? extends T> createMockType(MockCreationSettings<T> settings) {
        try {
            return this.bytecodeGenerator.mockClass(MockFeatures.withMockFeatures(settings.getTypeToMock(), settings.getExtraInterfaces(), settings.getSerializableMode(), settings.isStripAnnotations(), settings.getDefaultAnswer()));
        }
        catch (Exception bytecodeGenerationFailed) {
            throw this.prettifyFailure(settings, bytecodeGenerationFailed);
        }
    }

    private <T> RuntimeException prettifyFailure(MockCreationSettings<T> mockFeatures, Exception generationFailed) {
        Class<T> typeToMock = mockFeatures.getTypeToMock();
        if (typeToMock.isArray()) {
            throw new MockitoException(StringUtil.join("Arrays cannot be mocked: " + typeToMock + ".", ""), generationFailed);
        }
        if (Modifier.isFinal(typeToMock.getModifiers())) {
            throw new MockitoException(StringUtil.join("Mockito cannot mock this class: " + typeToMock + ".", "Can not mock final classes with the following settings :", " - explicit serialization (e.g. withSettings().serializable())", " - extra interfaces (e.g. withSettings().extraInterfaces(...))", "", "You are seeing this disclaimer because Mockito is configured to create inlined mocks.", "You can learn about inline mocks and their limitations under item #39 of the Mockito class javadoc.", "", "Underlying exception : " + generationFailed), generationFailed);
        }
        if (TypeSupport.INSTANCE.isSealed(typeToMock) && typeToMock.isEnum()) {
            throw new MockitoException(StringUtil.join("Mockito cannot mock this class: " + typeToMock + ".", "Sealed abstract enums can't be mocked. Since Java 15 abstract enums are declared sealed, which prevents mocking.", "You can still return an existing enum literal from a stubbed method call."), generationFailed);
        }
        if (Modifier.isPrivate(typeToMock.getModifiers())) {
            throw new MockitoException(StringUtil.join("Mockito cannot mock this class: " + typeToMock + ".", "Most likely it is a private class that is not visible by Mockito", "", "You are seeing this disclaimer because Mockito is configured to create inlined mocks.", "You can learn about inline mocks and their limitations under item #39 of the Mockito class javadoc.", ""), generationFailed);
        }
        throw new MockitoException(StringUtil.join("Mockito cannot mock this class: " + typeToMock + ".", "", "If you're not sure why you're getting this error, please open an issue on GitHub.", "", Platform.warnForVM("IBM J9 VM", "Early IBM virtual machine are known to have issues with Mockito, please upgrade to an up-to-date version.\n", "Hotspot", ""), Platform.describe(), "", "You are seeing this disclaimer because Mockito is configured to create inlined mocks.", "You can learn about inline mocks and their limitations under item #39 of the Mockito class javadoc.", "", "Underlying exception : " + generationFailed), generationFailed);
    }

    @Override
    public MockHandler getHandler(Object mock) {
        Map<Class<?>, MockMethodInterceptor> interceptors;
        MockMethodInterceptor interceptor = mock instanceof Class ? ((interceptors = this.mockedStatics.get()) != null ? interceptors.get(mock) : null) : this.mocks.get(mock);
        if (interceptor == null) {
            return null;
        }
        return interceptor.handler;
    }

    @Override
    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        MockMethodInterceptor mockMethodInterceptor = new MockMethodInterceptor(newHandler, settings);
        if (mock instanceof Class) {
            Map<Class<?>, MockMethodInterceptor> interceptors = this.mockedStatics.get();
            if (interceptors == null || !interceptors.containsKey(mock)) {
                throw new MockitoException("Cannot reset " + mock + " which is not currently registered as a static mock");
            }
            interceptors.put((Class)mock, mockMethodInterceptor);
        } else {
            if (!this.mocks.containsKey(mock)) {
                throw new MockitoException("Cannot reset " + mock + " which is not currently registered as a mock");
            }
            this.mocks.put(mock, mockMethodInterceptor);
            if (mock instanceof MockAccess) {
                ((MockAccess)mock).setMockitoInterceptor(mockMethodInterceptor);
            }
            this.mocks.expungeStaleEntries();
        }
    }

    @Override
    public void clearAllCaches() {
        this.clearAllMocks();
        this.bytecodeGenerator.clearAllCaches();
    }

    @Override
    public void clearMock(Object mock) {
        if (mock instanceof Class) {
            for (Map entry : this.mockedStatics.getBackingMap().target.values()) {
                entry.remove(mock);
            }
        } else {
            this.mocks.remove(mock);
        }
    }

    @Override
    public void clearAllMocks() {
        this.mockedStatics.getBackingMap().clear();
        this.mocks.clear();
    }

    @Override
    public MockMaker.TypeMockability isTypeMockable(final Class<?> type) {
        return new MockMaker.TypeMockability(){

            @Override
            public boolean mockable() {
                return INSTRUMENTATION.isModifiableClass(type) && !InlineBytecodeGenerator.EXCLUDES.contains(type);
            }

            @Override
            public String nonMockableReason() {
                if (this.mockable()) {
                    return "";
                }
                if (type.isPrimitive()) {
                    return "primitive type";
                }
                if (InlineBytecodeGenerator.EXCLUDES.contains(type)) {
                    return "Cannot mock wrapper types, String.class or Class.class";
                }
                return "VM does not support modification of given type";
            }
        };
    }

    @Override
    public <T> MockMaker.StaticMockControl<T> createStaticMock(Class<T> type, MockCreationSettings<T> settings, MockHandler handler) {
        if (type == ConcurrentHashMap.class) {
            throw new MockitoException("It is not possible to mock static methods of ConcurrentHashMap to avoid infinitive loops within Mockito's implementation of static mock handling");
        }
        if (type == Thread.class || type == System.class || type == Arrays.class || ClassLoader.class.isAssignableFrom(type)) {
            throw new MockitoException("It is not possible to mock static methods of " + type.getName() + " to avoid interfering with class loading what leads to infinite loops");
        }
        this.bytecodeGenerator.mockClassStatic(type);
        Map<Class<?>, MockMethodInterceptor> interceptors = this.mockedStatics.get();
        if (interceptors == null) {
            interceptors = new WeakHashMap();
            this.mockedStatics.set(interceptors);
        }
        this.mockedStatics.getBackingMap().expungeStaleEntries();
        return new InlineStaticMockControl<T>(type, interceptors, settings, handler);
    }

    @Override
    public <T> MockMaker.ConstructionMockControl<T> createConstructionMock(Class<T> type, Function<MockedConstruction.Context, MockCreationSettings<T>> settingsFactory, Function<MockedConstruction.Context, MockHandler<T>> handlerFactory, MockedConstruction.MockInitializer<T> mockInitializer) {
        if (type == Object.class) {
            throw new MockitoException("It is not possible to mock construction of the Object class to avoid inference with default object constructor chains");
        }
        if (type.isPrimitive() || Modifier.isAbstract(type.getModifiers())) {
            throw new MockitoException("It is not possible to construct primitive types or abstract types: " + type.getName());
        }
        this.bytecodeGenerator.mockClassConstruction(type);
        Map<Class<?>, BiConsumer<Object, MockedConstruction.Context>> interceptors = this.mockedConstruction.get();
        if (interceptors == null) {
            interceptors = new WeakHashMap();
            this.mockedConstruction.set(interceptors);
        }
        this.mockedConstruction.getBackingMap().expungeStaleEntries();
        return new InlineConstructionMockControl<T>(type, settingsFactory, handlerFactory, mockInitializer, interceptors);
    }

    @Override
    public <T> T newInstance(Class<T> cls) throws InstantiationException {
        Constructor<?>[] constructors = cls.getDeclaredConstructors();
        if (constructors.length == 0) {
            throw new InstantiationException(cls.getName() + " does not define a constructor");
        }
        Constructor<?> selected = constructors[0];
        for (Constructor<?> constructor : constructors) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            selected = constructor;
            break;
        }
        Class<?>[] types = selected.getParameterTypes();
        Object[] arguments = new Object[types.length];
        int index = 0;
        for (Class<?> type : types) {
            arguments[index++] = this.makeStandardArgument(type);
        }
        MemberAccessor memberAccessor = Plugins.getMemberAccessor();
        try {
            return (T)memberAccessor.newInstance(selected, callback -> {
                this.currentMocking.set(cls);
                try {
                    Object object = callback.newInstance();
                    return object;
                }
                finally {
                    this.currentMocking.remove();
                }
            }, arguments);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate " + cls.getName(), e);
        }
    }

    private Object makeStandardArgument(Class<?> type) {
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Instrumentation instrumentation;
        Throwable initializationError = null;
        if (System.getProperty("os.name") == null) {
            throw new IllegalStateException(StringUtil.join("The Byte Buddy agent cannot be loaded.", "", "To initialise the Byte Buddy agent, a subprocess may need to be created. To do this, the JVM requires knowledge of the 'os.name' System property in most JRE implementations. This property is not present, which means this operation will fail to complete. Please first make sure you are not clearing this property anywhere, and failing that, raise a bug with your JVM vendor."));
        }
        try {
            try {
                instrumentation = ByteBuddyAgent.install();
                if (!instrumentation.isRetransformClassesSupported()) {
                    throw new IllegalStateException(StringUtil.join("Byte Buddy requires retransformation for creating inline mocks. This feature is unavailable on the current VM.", "", "You cannot use this mock maker on this VM"));
                }
                File boot = File.createTempFile("mockitoboot", ".jar");
                boot.deleteOnExit();
                try (JarOutputStream outputStream = new JarOutputStream(new FileOutputStream(boot));){
                    String source = "org/mockito/internal/creation/bytebuddy/inject/MockMethodDispatcher";
                    InputStream inputStream = InlineDelegateByteBuddyMockMaker.class.getClassLoader().getResourceAsStream(source + ".raw");
                    if (inputStream == null) {
                        throw new IllegalStateException(StringUtil.join("The MockMethodDispatcher class file is not locatable: " + source + ".raw", "", "The class loader responsible for looking up the resource: " + InlineDelegateByteBuddyMockMaker.class.getClassLoader()));
                    }
                    outputStream.putNextEntry(new JarEntry(source + ".class"));
                    try {
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = inputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, length);
                        }
                    }
                    finally {
                        inputStream.close();
                    }
                    outputStream.closeEntry();
                }
                try (JarFile jarfile = new JarFile(boot);){
                    instrumentation.appendToBootstrapClassLoaderSearch(jarfile);
                }
                try {
                    Class.forName("org.mockito.internal.creation.bytebuddy.inject.MockMethodDispatcher", false, null);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalStateException(StringUtil.join("Mockito failed to inject the MockMethodDispatcher class into the bootstrap class loader", "", "It seems like your current VM does not support the instrumentation API correctly."), cnfe);
                }
            }
            catch (IOException ioe) {
                throw new IllegalStateException(StringUtil.join("Mockito could not self-attach a Java agent to the current VM. This feature is required for inline mocking.", "This error occured due to an I/O error during the creation of this agent: " + ioe, "", "Potentially, the current VM does not support the instrumentation API correctly"), ioe);
            }
        }
        catch (Throwable throwable) {
            instrumentation = null;
            initializationError = throwable;
        }
        INSTRUMENTATION = instrumentation;
        INITIALIZATION_ERROR = initializationError;
    }

    private static class InlineStaticMockControl<T>
    implements MockMaker.StaticMockControl<T> {
        private final Class<T> type;
        private final Map<Class<?>, MockMethodInterceptor> interceptors;
        private final MockCreationSettings<T> settings;
        private final MockHandler handler;

        private InlineStaticMockControl(Class<T> type, Map<Class<?>, MockMethodInterceptor> interceptors, MockCreationSettings<T> settings, MockHandler handler) {
            this.type = type;
            this.interceptors = interceptors;
            this.settings = settings;
            this.handler = handler;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        @Override
        public void enable() {
            if (this.interceptors.putIfAbsent(this.type, new MockMethodInterceptor(this.handler, this.settings)) != null) {
                throw new MockitoException(StringUtil.join("For " + this.type.getName() + ", static mocking is already registered in the current thread", "", "To create a new mock, the existing static mock registration must be deregistered"));
            }
        }

        @Override
        public void disable() {
            if (this.interceptors.remove(this.type) == null) {
                throw new MockitoException(StringUtil.join("Could not deregister " + this.type.getName() + " as a static mock since it is not currently registered", "", "To register a static mock, use Mockito.mockStatic(" + this.type.getSimpleName() + ".class)"));
            }
        }
    }

    private class InlineConstructionMockControl<T>
    implements MockMaker.ConstructionMockControl<T> {
        private final Class<T> type;
        private final Function<MockedConstruction.Context, MockCreationSettings<T>> settingsFactory;
        private final Function<MockedConstruction.Context, MockHandler<T>> handlerFactory;
        private final MockedConstruction.MockInitializer<T> mockInitializer;
        private final Map<Class<?>, BiConsumer<Object, MockedConstruction.Context>> interceptors;
        private final List<Object> all = new ArrayList<Object>();
        private int count;

        private InlineConstructionMockControl(Class<T> type, Function<MockedConstruction.Context, MockCreationSettings<T>> settingsFactory, Function<MockedConstruction.Context, MockHandler<T>> handlerFactory, MockedConstruction.MockInitializer<T> mockInitializer, Map<Class<?>, BiConsumer<Object, MockedConstruction.Context>> interceptors) {
            this.type = type;
            this.settingsFactory = settingsFactory;
            this.handlerFactory = handlerFactory;
            this.mockInitializer = mockInitializer;
            this.interceptors = interceptors;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        @Override
        public void enable() {
            if (this.interceptors.putIfAbsent(this.type, (object, context) -> {
                ((InlineConstructionMockContext)context).count = ++this.count;
                MockMethodInterceptor interceptor = new MockMethodInterceptor(this.handlerFactory.apply((MockedConstruction.Context)context), this.settingsFactory.apply((MockedConstruction.Context)context));
                InlineDelegateByteBuddyMockMaker.this.mocks.put(object, interceptor);
                try {
                    Object cast = object;
                    this.mockInitializer.prepare(cast, (MockedConstruction.Context)context);
                }
                catch (Throwable t) {
                    InlineDelegateByteBuddyMockMaker.this.mocks.remove(object);
                    throw new MockitoException("Could not initialize mocked construction", t);
                }
                this.all.add(object);
            }) != null) {
                throw new MockitoException(StringUtil.join("For " + this.type.getName() + ", static mocking is already registered in the current thread", "", "To create a new mock, the existing static mock registration must be deregistered"));
            }
        }

        @Override
        public void disable() {
            if (this.interceptors.remove(this.type) == null) {
                throw new MockitoException(StringUtil.join("Could not deregister " + this.type.getName() + " as a static mock since it is not currently registered", "", "To register a static mock, use Mockito.mockStatic(" + this.type.getSimpleName() + ".class)"));
            }
            this.all.clear();
        }

        @Override
        public List<T> getMocks() {
            return this.all;
        }
    }

    private static class InlineConstructionMockContext
    implements MockedConstruction.Context {
        private static final Map<String, Class<?>> PRIMITIVES = new HashMap();
        private int count;
        private final Object[] arguments;
        private final Class<?> type;
        private final String[] parameterTypeNames;

        private InlineConstructionMockContext(Object[] arguments, Class<?> type, String[] parameterTypeNames) {
            this.arguments = arguments;
            this.type = type;
            this.parameterTypeNames = parameterTypeNames;
        }

        @Override
        public int getCount() {
            if (this.count == 0) {
                throw new MockitoConfigurationException("mocked construction context is not initialized");
            }
            return this.count;
        }

        @Override
        public Constructor<?> constructor() {
            Object[] parameterTypes = new Class[this.parameterTypeNames.length];
            int index = 0;
            for (String parameterTypeName : this.parameterTypeNames) {
                if (PRIMITIVES.containsKey(parameterTypeName)) {
                    parameterTypes[index++] = PRIMITIVES.get(parameterTypeName);
                    continue;
                }
                try {
                    parameterTypes[index++] = Class.forName(parameterTypeName, false, this.type.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new MockitoException("Could not find parameter of type " + parameterTypeName, e);
                }
            }
            try {
                return this.type.getDeclaredConstructor((Class<?>[])parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw new MockitoException(StringUtil.join("Could not resolve constructor of type", "", this.type.getName(), "", "with arguments of types", Arrays.toString(parameterTypes)), e);
            }
        }

        @Override
        public List<?> arguments() {
            return Collections.unmodifiableList(Arrays.asList(this.arguments));
        }

        static {
            PRIMITIVES.put(Boolean.TYPE.getName(), Boolean.TYPE);
            PRIMITIVES.put(Byte.TYPE.getName(), Byte.TYPE);
            PRIMITIVES.put(Short.TYPE.getName(), Short.TYPE);
            PRIMITIVES.put(Character.TYPE.getName(), Character.TYPE);
            PRIMITIVES.put(Integer.TYPE.getName(), Integer.TYPE);
            PRIMITIVES.put(Long.TYPE.getName(), Long.TYPE);
            PRIMITIVES.put(Float.TYPE.getName(), Float.TYPE);
            PRIMITIVES.put(Double.TYPE.getName(), Double.TYPE);
        }
    }
}

